/*
 * Copyright (c) 1997, 1998
 *      Jens Arvid Nilsson, jnilsson@ludd.luth.se. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*$Id: readconfig.c,v 1.6 1998/05/24 14:14:15 jens Exp $*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "readconfig.h"
#include "jque.h"
#include "error.h"
#include "util.h"

#define J_CONF_STR 1024

static struct J_conf *pCH = NULL, *pC = NULL;
static struct J_value *pVH = NULL, *pV = NULL;

struct J_conf *
pJ_read_config(FILE * pConfigFile, char **pFields, int nSize)
{
	char    szTokSep[] = " =";
	int     nFields, i, nRow;
	char   *szTok, *szRow;
	char    szSlusk[J_CONF_STR];

	/*
	 * pFields r en nFields * nSize matris, dr nFields r antalet rader
	 * och nSize r lngden p varje rad. Sista raden r "".
	 */

	for (nFields = 0; 
			(((char *) pFields) + (nFields * nSize))[0] != (char) NULL;
			nFields++);

	Q_INIT(pCH, sizeof(*pCH));
	nRow = 0;

	while (fgets(szSlusk, J_CONF_STR, pConfigFile)) {
		if ((strlen(szSlusk) != 0) &&
		    (szSlusk[strlen(szSlusk) - 1] == '\n'))
			szSlusk[strlen(szSlusk) - 1] = (char) NULL;

		szRow = strdup(szSlusk);
		nRow++;

		szTok = strtok(szSlusk, szTokSep);
		if (szTok == NULL || szTok[0] == '#') {
			free(szRow);
			continue;
		}

		for (i = 0;
		    i < nFields &&
			strcmp(szTok, ((char *) pFields) + (i * nSize)) != 0;
		    i++);

		if (i >= nFields) 
			i = -1;
		else
			szTok = strtok(NULL, szTokSep);
		pC = Malloc(sizeof(struct J_conf));
		pC->nIdx = i;
		pC->nRow = nRow;
		pC->szOrig = szRow;
		Q_APPEND(pC, pCH);
		Q_INIT(pVH, sizeof(struct J_value));
		pC->pValue = pVH;
		if (szTok != NULL)
			do {
				pV = Malloc(sizeof(struct J_value));
				pV->szValue = strdup(szTok);
				Q_APPEND(pV, pVH);
			} while ((szTok = strtok(NULL, szTokSep)) != NULL 
						&& szTok[0] != '#');
	}

	pC = Q_NEXT(pCH);
	pVH = pV = pC->pValue;
	return pCH;
}


int nJ_conf_row(void)
{
	return (pC == NULL) ? -1 : pC->nRow;
}

int nJ_conf_idx(void)
{
	return (pC == NULL) ? -1 : pC->nIdx;
}

char *szJ_conf_orig(void)
{
	return (pC == NULL) ? NULL : pC->szOrig;
}

int
nJ_next_row()
{
	if (bJ_eo_conf())
		return -1;

	if (Q_EOQ(pC, pCH)) {
		pC = NULL;
		return -1;
	}

	pC = Q_NEXT(pC);
	pVH = pV = pC->pValue;
	return pC->nRow;
}

int
bJ_eo_conf(void)
{
	return pCH == NULL || pC == NULL; /* || Q_EOQ(pC, pCH);*/
}

char *
szJ_next_token(void)
{
	if (pVH == NULL || pV == NULL || Q_EOQ(pV, pVH))
		pV = NULL;
	else
		pV = Q_NEXT(pV);
	return szJ_token();
}

char *
szJ_token(void)
{
	return (pV == NULL) ? NULL : pV->szValue;
}

char *
szJ_Next_token(void)
{
	char *str;

	if ((str = szJ_next_token()) == NULL)
		err_quit("config row: %d", nJ_conf_row());
	return str;
}

void
vJ_Expect_next_token(char *str)
{
	if (strcmp(str, szJ_Next_token()) != 0)
		err_quit("config row: %d", nJ_conf_row());
}

void
vJ_free_config(struct J_conf *pCHead)
{
	if (pCHead == NULL) {
		while (!Q_EMPTY(pCH)) {
			pC = Q_NEXT(pCH);
			pVH = pC->pValue;
			while (!Q_EMPTY(pVH)) {
				pV = Q_NEXT(pVH);
				Q_REM(pV);
				free(pV->szValue);
				free(pV);
			}
			free(pVH);
			free(pC->szOrig);
		}
		free(pCH);
		pCH = pC = NULL;
		pVH = pV = NULL;
	} else {
		struct J_conf *pCH = pCHead, *pC;
		struct J_value *pVH, *pV;

		while (!Q_EMPTY(pCH)) {
            pC = Q_NEXT(pCH);
            pVH = pC->pValue;
            while (!Q_EMPTY(pVH)) {
                pV = Q_NEXT(pVH);
                Q_REM(pV);
                free(pV->szValue);
                free(pV);
            }
            free(pVH);
            free(pC->szOrig);
        }
        free(pCH);
	}
}
