import sys
#from pdb import set_trace as trace
import binascii

import SSLCrypto

def myCallback(type, num):
    if type == -1:
        print
    elif type == 0:
        sys.stdout.write(".")
    elif type == 1:
        sys.stdout.write("+")
    else:
        sys.stdout.write("*")
    sys.stdout.flush()

print "Creating DH objects"
dhAlice = SSLCrypto.dh()
dhBob = SSLCrypto.dh()

print "Generating parms"
parms = dhAlice.genParms(512, 2, myCallback)
#parms = dhAlice.genParms(512, 2)
dhBob.importParms(parms)

print "Generating Alice's public key"
pubAlice = dhAlice.genPubKey()
print "Alice's prikey=%ld" % dhAlice.privKey()
print "Generating Bob's public key"
pubBob = dhBob.genPubKey()
print "Bob's privkey=%ld" % dhBob.privKey()

print "Generating Alice's session key"
sessAlice = dhAlice.genSessKey(pubBob)
print "Generating Bob's session key"
sessBob = dhBob.genSessKey(pubAlice)

print "Comparing session keys"
if sessAlice == sessBob:
    sessAliceHex = binascii.hexlify(sessAlice)
    print "size=%d" % (len(sessAliceHex) / 2)
    print sessAliceHex
    print "Success"
else:
    print "Alice: %ld" % binascii.hexlify(sessAlice)
    print "Bob  : %ld" % binascii.hexlify(sessBob)
    print "Fail"
