#!/usr/bin/env python

"""
example7.py

Demonstrate the use of passphrases with private keys
"""

import sys
import SSLCrypto

mysecret = "Don't look at this!!!"

raw = "Here is a string to encrypt"

# Create a key object
try:
    k = SSLCrypto.key(passphrase=mysecret)
except:
    print "failed to create key object"
    sys.exit(1)

# Export public/private key
publicAndPrivateKey = k.exportKeyPrivate()

# Encrypt against this keypair
enc = k.encString(raw)

# Create a new key object, and import keys (with passphrase)
k1 = SSLCrypto.key(publicAndPrivateKey, passphrase=mysecret)

# Decrypt text
dec = k.decString(enc)

# test
if dec == raw:
    print "Successful decryption using correct passphrase"
else:
    print "Failed somewhere"

print "Trying now with a bad passphrase"
try:
    k2 = SSLCrypto.key(publicAndPrivateKey, passphrase="cracking attempt")
except SSLCrypto.CryptoKeyError:
    print "Oops - our feeble cracking attempt failed (which is a good thing)."
except:
    print "got another exception"
else:
    print "Cracking attempt succeeded - we're not safe"
    # We're in - let's plunder
    dec2 = k2.decString(enc)

