/* 1245, Mon 17 May 99

   RTFM_ATR.H:  RTFM attribute definitions

   Copyright (C) 1998-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: rtfm_atr.h,v $
 * Revision 1.1.1.2.2.12  2002/02/23 01:57:41  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.7  2000/11/29 21:40:17  nevil
 * Bug fixes for stream / packet queue handling
 *
 * Revision 1.1.1.2.2.6  2000/08/08 19:44:59  nevil
 * 44b8 release
 *
 * Revision 1.1.1.2.2.4  2000/06/06 03:38:32  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  2000/01/12 02:57:15  nevil
 * Implement 'packet pair matched' turnaroundtime distribution attributes.
 * Fix ASN-related bugs in NeTraMet, distribution-related bugs in fd_filter.
 *
 * Revision 1.1.1.2  1999/10/03 21:06:33  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.7  1999/05/18 03:36:30  nevil
 * Implement IPv6 in NeTraMet, and its manager/collectors.
 * - This is controlled by the V6 #define
 * - NeTraMet recognises v6 packets and fishes through their extension
 *     headers until it finds the actual payload.
 * - NeMaC et al display v6 addresses in the fom specified by RFC 2373
 * - fd_util and fd_extract allow colons in addresses (for defining tags)
 *
 * Revision 1.1.1.1.2.6  1999/04/09 03:49:00  nevil
 * Implemented IPv6 addresses for SRL
 *   -D define V6 to enable the v6 code
 *   Added IPv4 and IPv6 as address families (IP => IPv4)
 *   Added get_v6address ro srl_scan
 *   v6err() routine to print v6 address errors
 *   V6DEBUG turns on v6 parser debugging
 *
 * Revision 1.1.1.1.2.5  1999/01/28 03:12:09  nevil
 * Mis-spelt attribute names are now correctly reported as errors
 *
 * Revision 1.1.1.1.2.4  1999/01/27 04:26:16  nevil
 * Minor corrections to fix compiler warnings
 *
 * Revision 1.1.1.1.2.3  1999/01/08 01:38:40  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1.2.2  1998/11/19 02:13:25  nevil
 * Allow mask_from_width() to accept zero width
 *
 * Revision 1.1.1.1.2.1  1998/11/17 23:02:42  nevil
 * Implement DS attributes SourceDScodepoint(118), DestDScodepoint(119)
 * and (experimental) TCP attribute TCPdata(121)
 *
 * Revision 1.1.1.1  1998/11/16 03:22:03  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.2.1  1998/10/22 21:40:36  nevil
 * Moved srl from src/manager to its own subdirectory
 *
 * Revision 1.1.3.2  1998/10/18 23:44:12  nevil
 * Added Nicolai's patches, some 'tidying up' of the source
 *
 * Revision 1.1.3.1  1998/10/13 02:48:26  nevil
 * Import of Nicolai's 4.2.2
 *
 * Revision 1.1.1.1  1998/08/24 12:09:29  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.2  1998/07/21 00:43:57  rtfm
 * Change attrib numbers for 'New Attribs' I-D
 * First release version of SRL
 */

#ifndef RTFMEXT
#define RTFMEXT  extern
#define DECLARE  0
#define INIT(v)
#else
#define RTFMEXT
#define DECLARE  1
#define INIT(v)  = v
#endif


#define MAC_ADDR_LEN      6  /* Address lengths */

#define IP4_ADDR_LEN      4
#define IP6_ADDR_LEN     16
#define DN_ADDR_LEN       3
#define ET_ADDR_LEN       3
#if FULL_IPX
# define IPX_ADDR_LEN    10
# undef 
#else
# define IPX_ADDR_LEN     4
#endif
#define NSAP_ADDR_LEN    20

#define TRANS_ADDR_LEN    2

#if CLNS
# define PEER_ADDR_LEN  NSAP_ADDR_LEN
# define RULE_ADDR_LEN  NSAP_ADDR_LEN
#elif V6 || FULL_IPX
# define PEER_ADDR_LEN   IP6_ADDR_LEN
# define RULE_ADDR_LEN   IP6_ADDR_LEN
#else  /* v4 */
# define PEER_ADDR_LEN   IP4_ADDR_LEN
# define RULE_ADDR_LEN   MAC_ADDR_LEN
#endif

RTFMEXT char addr_len[]  /* Lengths for each address type */
#if DECLARE
   = {
      PEER_ADDR_LEN,    /*  0 */
      IP4_ADDR_LEN,     /*  1 IP4 */
      IP6_ADDR_LEN,     /*  2 IP6 */
      NSAP_ADDR_LEN,    /*  3 CLNS */
      0,                /*  4 */
      0,                /*  5 */
      TRANS_ADDR_LEN,   /*  6 Other */
      0,                /*  7 */
      0,                /*  8 */
      0,                /*  9 */
      0,                /* 10 */
      IPX_ADDR_LEN,     /* 11 Novell IPX */
      ET_ADDR_LEN,      /* 12 EtherTalk */
      DN_ADDR_LEN       /* 13 DECnet */
      }
#endif
   ;


#define AT_DUMMY       0  /* Addr_type values */

#define AT_IP4         1  /* Address Family Numbers */
#define AT_IP6         2
#define AT_CLNS        3
#define AT_OTHER       6  /* 'generic' 802 address family */
#define AT_ETHERNET    7  /* ifType medium */
#define AT_TOKENRING   9  /* ifType medium */
#define AT_NOVELL     11
#define AT_ETHERTALK  12
#define AT_DECNET     13
#define AT_FDDI       15  /* ifType medium */
#define AT_AAL5       49  /* ifType AAL5 over ATM */

#define MX_PROTOCOLS  AT_DECNET

#define AT3_IGNORE     0  /* Addr_type values */
#define AT3_DUMMY      1
#define AT3_ADJACENT   1
#define AT3_IP         2
#define AT3_CLNS       3
#define AT3_IDPR       4
#define AT3_DECNET     5
#define AT3_NOVELL     6
#define AT3_ETHERTALK  7
#define AT3_TRANS      8
#define AT3_IP_FRAG   11
#define AT3_OTHER     12

#define PT_ICMP       1  /* IP protocol type values */
#define PT_TCP        6
#define PT_UDP       17
#define PT_OSPF      89  /* OSPF IGP */

#define WNP_FTPDATA  20  /* Well-known tcp/udp port numbers */
#define WNP_FTP      21
#define WNP_TELNET   23
#define WNP_SMTP     25
#define WNP_DOMAIN   53
#define WNP_GOPHER   70
#define WNP_WWW      80
#define WNP_NNTP    119
#define WNP_NTP     123
#define WNP_SNMP    161

#define RA_SUCCEED       0  /* Ignore */
#define RA_IGNORE        1
#define RA_NOMATCH       2
#define RA_COUNT         3
#define RA_COUNTPKT      4
#define RA_RETURN        5
#define RA_GOSUB         6
#define RA_GOSUBACT      7
#define RA_ASSIGN        8
#define RA_ASSIGNACT     9
#define RA_GOTO         10
#define RA_GOTOACT      11
#define RA_PUSHTO       12
#define RA_PUSHTOACT    13
#define RA_PUSHPKTTO    14
#define RA_PUSHPKTTOACT 15
#define RA_POPTO        16
#define RA_POPTOACT     17

#define RA_NEXT         21  /* 'the next rule,' not an action */

#define FTFLOWINDEX		1  /* Flow table attribute values */
#define FTFLOWTIMEMARK          2
#define FTFLOWSTATUS		3

#define FTLOWINTERFACE          4
#define FTLOWADJACENTTYPE       5
#define FTLOWADJACENTADDRESS    6
#define FTLOWADJACENTMASK       7
#define FTLOWPEERTYPE		8
#define FTLOWPEERADDRESS	9
#define FTLOWPEERMASK	       10
#define FTLOWTRANSTYPE         11
#define FTLOWTRANSADDRESS      12
#define FTLOWTRANSMASK         13

#define FTHIINTERFACE          14
#define FTHIADJACENTTYPE       15
#define FTHIADJACENTADDRESS    16
#define FTHIADJACENTMASK       17
#define FTHIPEERTYPE	       18
#define FTHIPEERADDRESS	       19
#define FTHIPEERMASK	       20
#define FTHITRANSTYPE          21
#define FTHITRANSADDRESS       22
#define FTHITRANSMASK          23

#define FTPDUSCALE             24
#define FTOCTETSCALE           25
#define FTRULESET              26
#define FTUPOCTETS	       27
#define FTUPPDUS	       28
#define FTDOWNOCTETS	       29
#define FTDOWNPDUS	       30
#define FTFIRSTTIME	       31
#define FTLASTTIME	       32

#define FTLOWSUBSCRIBERID      33
#define FTHISUBSCRIBERID       34
#define FTSESSIONID            35

#define FTSOURCECLASS          36
#define FTDESTCLASS            37
#define FTFLOWCLASS            38
#define FTSOURCEKIND           39
#define FTDESTKIND             40
#define FTFLOWKIND             41

#define FTDSCODEPOINT         118
#if !NEW_ATR
#define N_OLD_ATRS     (FTFLOWKIND + 1)  /* 1 DS attribute */
#define LASTATTRIB      FTHIDSCODEPOINT   /* May be redefined below */
#else
#define FTTOLOSTPDUS          121
#define FTFROMLOSTPDUS        122
#define FTTOPQOVERFLOWS       123  /* PQOF */
#define FTFROMPQOVERFLOWS     124
#define N_OLD_ATRS     (FTFLOWKIND + 1 + 4)  /* DSCP + OverflowPDUs */
#define LASTATTRIB      FTFROMPQOVERFLOWS    /* May be redefined below */
#endif

#define FTFORWARD              50
#define FTV1                   51
#define FTV2                   52
#define FTV3                   53
#define FTV4                   54
#define FTV5                   55

#define USER_ATTRIB(a)  (a >= FTV1 && a <= FTV5)
#define N_METER_ATRS    (FTV5+1 - FTFORWARD)
#define N_VBLS          (FTV5+1 - FTV1)  /* Nbr of user variables */

#if !defined(NEW_ATR)
#define N_DIST_ATRS        0
#else
#define FTDISTRIBUTIONS        65 /* Bit set for each distribution in flow */
#define FTTOPACKETSIZE         66
#define FTFROMPACKETSIZE       67
#define FTTOINTERARRIVALTIME   68
#define FTFROMINTERARRIVALTIME 69
#define FTTOTURNAROUNDTIME     70
#define FTFROMTURNAROUNDTIME   71
#define FTTOBITRATE            72
#define FTFROMBITRATE          73
#define FTTOPDURATE            74
#define FTFROMPDURATE          75

#define FTTOTCPTIME            76
#define FTFROMTCPTIME          77
#define FTTOTCPSIZE            78
#define FTFROMTCPSIZE          79
#define FTTOTCPRATE1           80
#define FTFROMTCPRATE1         81
#define FTTOTCPRATE2           82
#define FTFROMTCPRATE2         83

#define FTTOTURNAROUNDTIME1    70
#define FTFROMTURNAROUNDTIME1  71
#define FTTOTURNAROUNDTIME2    84
#define FTFROMTURNAROUNDTIME2  85
#define FTTOTURNAROUNDTIME3    86
#define FTFROMTURNAROUNDTIME3  87
#define FTTOTURNAROUNDTIME4    88
#define FTFROMTURNAROUNDTIME4  89

#define FTTOFLOWOCTETS         90
#define FTFROMFLOWOCTETS       91
#define FTTOFLOWPDUS           92
#define FTFROMFLOWPDUS         93
#define FTFLOWTIME             94

#define LAST_DISTRIB           FTFLOWTIME

#define DISTRIB_ATTRIB(a)  (a >= FTTOPACKETSIZE && a <= LAST_DISTRIB)
#define DISTRIB_BASE       FTTOPACKETSIZE
#define N_DIST_ATRS   (1 + (LAST_DISTRIB - FTDISTRIBUTIONS))
# if LASTATTRIB < LAST_DISTRIB
#  undef LASTATTRIB
#  define LASTATTRIB      LAST_DISTRIB  /* max(basic, dist) */
# endif
#endif

#if !defined(NETFLOW)
#define N_NF_ATRS               0
#else
#define FTMETERID             112
#define FTLOWROUTEASN         113
#define FTLOWROUTEPREFIX      114
#define FTHIROUTEASN          115
#define FTHIROUTEPREFIX       116

#define NF_ATTRIB(a)  (a >= FTMETERID && a <= FTHIASWIDTH)
#define N_NF_ATRS     (FTHIROUTEPREFIX+1 - FTMETERID)
# if LASTATTRIB < FTHIROUTEPREFIX
#  undef LASTATTRIB
#  define LASTATTRIB  FTHIROUTEPREFIX  /* max(basic, dist, nf) */
# endif
#endif

#if !defined(NEW_ATR)
#define N_TCP_ATRS              0
#else
#define FTTCPDATA             125
#define N_TCP_ATRS              1
# if LASTATTRIB < FTTCPDATA
#  undef LASTATTRIB
#  define LASTATTRIB    FTTCPDATA  /* max(basic, dist, nf, tcp) */
# endif
#endif

#define N_ATTRIBS  (N_OLD_ATRS + N_METER_ATRS + N_DIST_ATRS \
                      + N_NF_ATRS + N_TCP_ATRS)


#if NEW_ATR
#define DIST_PARAM_LEN  6
#define MXBUCKETS     100
struct distribution {
   unsigned char selector,  /* Attribute number */
      mask_params[DIST_PARAM_LEN], value_params[DIST_PARAM_LEN];
   unsigned int counts[MXBUCKETS+1];

   unsigned char Transform, ScaleFactor; /* 'mask' parameters */
   unsigned int LowerLimit, UpperLimit;
   unsigned char Buckets, Parameter1;  /* 'value' parameters */
   unsigned int Parameter2, Parameter3;

   struct distribution *next;
   };
#define DS_NULL  0  /* Distribution transform type values */
#define DS_LIN   1
#define DS_LOG   2
#endif


#define ADJ_ADDR    1  /* Address attribute types */
#define PEER_ADDR   2
#define TRANS_ADDR  3


struct attrib_info {
   char *name;
   unsigned char index;
   unsigned char properties;
   unsigned char len;
   };

RTFMEXT int attr_ix[LASTATTRIB+1];  /* Index to attribs[] */

#define if_OK(x)      ((attribs[attr_ix[x]].properties & 0x08) != 0)
#define save_OK(x)    ((attribs[attr_ix[x]].properties & 0x04) != 0)
#define store_OK(x)   ((attribs[attr_ix[x]].properties & 0x02) != 0)
#define format_OK(x)  ((attribs[attr_ix[x]].properties & 0x01) != 0)

#define P(ifbit, savebit, storebit, formatbit)  \
   (ifbit*0x08 | savebit*0x04 | storebit*0x02 | formatbit)

#define N_SYNONYMS   2
     /* Synonyms: To/From TurnaroundTime */
#define SZ_ATTRIBS  (1 + N_ATTRIBS + N_SYNONYMS)  /* 1 for Null */

RTFMEXT struct attrib_info attribs[SZ_ATTRIBS]
#if DECLARE
   = {
   /*  name                 index             (if save store format)  len */
   "null",                  0,                      P(0,0,0,0), 0,
   "flowindex",             FTFLOWINDEX,            P(0,0,0,1), 4,
   "flowtimemark",          FTFLOWTIMEMARK,         P(0,0,0,0), 4,
   "flowstatus",            FTFLOWSTATUS,           P(0,0,0,0), 1,
   "sourceinterface",       FTLOWINTERFACE,         P(1,1,0,1), 1,
   "sourceadjacenttype",    FTLOWADJACENTTYPE,      P(1,1,0,1), 1,
   "sourceadjacentaddress", FTLOWADJACENTADDRESS,   P(1,1,0,1), MAC_ADDR_LEN,
   "sourceadjacentmask",    FTLOWADJACENTMASK,      P(0,0,0,0), MAC_ADDR_LEN,
   "sourcepeertype",        FTLOWPEERTYPE,          P(1,1,0,1), 1,
   "sourcepeeraddress",     FTLOWPEERADDRESS,       P(1,1,0,1), PEER_ADDR_LEN,
   "sourcepeermask",        FTLOWPEERMASK,          P(0,0,0,0), PEER_ADDR_LEN,
   "sourcetranstype",       FTLOWTRANSTYPE,         P(1,1,0,1), 1,
   "sourcetransaddress",    FTLOWTRANSADDRESS,      P(1,1,0,1), TRANS_ADDR_LEN,
   "sourcetransmask",       FTLOWTRANSMASK,         P(0,0,0,0), TRANS_ADDR_LEN,

   "destinterface",         FTHIINTERFACE,          P(1,1,0,1), 1,
   "destadjacenttype",      FTHIADJACENTTYPE,       P(1,1,0,1), 1,
   "destadjacentaddress",   FTHIADJACENTADDRESS,    P(1,1,0,1), MAC_ADDR_LEN,
   "destadjacentmask",      FTHIADJACENTMASK,       P(0,0,0,0), MAC_ADDR_LEN,
   "destpeertype",          FTHIPEERTYPE,           P(1,1,0,1), 1,
   "destpeeraddress",       FTHIPEERADDRESS,        P(1,1,0,1), PEER_ADDR_LEN,
   "destpeermask",          FTHIPEERMASK,           P(0,0,0,0), PEER_ADDR_LEN,
   "desttranstype",         FTHITRANSTYPE,          P(1,1,0,1), 1,
   "desttransaddress",      FTHITRANSADDRESS,       P(1,1,0,1), TRANS_ADDR_LEN,
   "desttransmask",         FTHITRANSMASK,          P(0,0,0,0), TRANS_ADDR_LEN,

   "pduscale",              FTPDUSCALE,             P(0,0,0,0), 0,
   "octetscale",            FTOCTETSCALE,           P(0,0,0,0), 0,
   "flowruleset",           FTRULESET,              P(1,1,0,1), 1,
   "tooctets",              FTUPOCTETS,             P(0,0,0,1), 8,
   "topdus",                FTUPPDUS,               P(0,0,0,1), 8,
   "fromoctets",            FTDOWNOCTETS,           P(0,0,0,1), 8,
   "frompdus",              FTDOWNPDUS,             P(0,0,0,1), 8,
   "firsttime",             FTFIRSTTIME,            P(0,0,0,1), 4,
   "lasttime",              FTLASTTIME,             P(0,0,0,1), 4,

   "sourcesubscriberid",    FTLOWSUBSCRIBERID,      P(0,0,0,0), 0,
   "destsubscriberid",      FTHISUBSCRIBERID,       P(0,0,0,0), 0,
   "sessionid",             FTSESSIONID,            P(0,0,0,0), 0,

   "sourceclass",           FTSOURCECLASS,          P(1,0,1,1), 1,
   "destclass",             FTDESTCLASS,            P(1,0,1,1), 1,
   "flowclass",             FTFLOWCLASS,            P(1,0,1,1), 1,
   "sourcekind",            FTSOURCEKIND,           P(1,0,1,1), 1,
   "destkind",              FTDESTKIND,             P(1,0,1,1), 1,
   "flowkind",              FTFLOWKIND,             P(1,0,1,1), 1,

   "dscodepoint",           FTDSCODEPOINT,          P(1,1,0,1), 1,

   "tolostpdus",            FTTOLOSTPDUS,           P(0,1,0,1), 1,
   "fromlostpdus",          FTFROMLOSTPDUS,         P(0,1,0,1), 1,
   "topqoverflows",         FTTOPQOVERFLOWS,        P(0,1,0,1), 1,
   "frompqoverflows",       FTFROMPQOVERFLOWS,      P(0,1,0,1), 1,

   "matchingstod",          FTFORWARD,              P(1,0,0,0), 1,
   "v1",                    FTV1,                   P(0,0,0,0), RULE_ADDR_LEN,
   "v2",                    FTV2,                   P(0,0,0,0), RULE_ADDR_LEN,
   "v3",                    FTV3,                   P(0,0,0,0), RULE_ADDR_LEN,
   "v4",                    FTV4,                   P(0,0,0,0), RULE_ADDR_LEN,
   "v5",                    FTV5,                   P(0,0,0,0), RULE_ADDR_LEN

#if defined(NEW_ATR)
   ,
   "distributions",         FTDISTRIBUTIONS,        P(0,0,0,0), 0,
   "topacketsize",          FTTOPACKETSIZE,         P(0,1,0,1), DIST_PARAM_LEN,
   "frompacketsize",        FTFROMPACKETSIZE,       P(0,1,0,1), DIST_PARAM_LEN,
   "tointerarrivaltime",    FTTOINTERARRIVALTIME,   P(0,1,0,1), DIST_PARAM_LEN,
   "frominterarrivaltime",  FTFROMINTERARRIVALTIME, P(0,1,0,1), DIST_PARAM_LEN,
   "toturnaroundtime",      FTTOTURNAROUNDTIME,     P(0,1,0,1), DIST_PARAM_LEN,
   "fromturnaroundtime",    FTFROMTURNAROUNDTIME,   P(0,1,0,1), DIST_PARAM_LEN,
   "tobitrate",             FTTOBITRATE,            P(0,1,0,1), DIST_PARAM_LEN,
   "frombitrate",           FTFROMBITRATE,          P(0,1,0,1), DIST_PARAM_LEN,
   "topdurate",             FTTOPDURATE,            P(0,1,0,1), DIST_PARAM_LEN,
   "frompdurate",           FTFROMPDURATE,          P(0,1,0,1), DIST_PARAM_LEN,
   "totcptime",             FTTOTCPTIME,            P(0,1,0,1), DIST_PARAM_LEN,
   "fromtcptime",           FTFROMTCPTIME,          P(0,1,0,1), DIST_PARAM_LEN,
   "totcpsize",             FTTOTCPSIZE,            P(0,1,0,1), DIST_PARAM_LEN,
   "fromtcpsize",           FTFROMTCPSIZE,          P(0,1,0,1), DIST_PARAM_LEN,
   "totcprate1",            FTTOTCPRATE1,           P(0,1,0,1), DIST_PARAM_LEN,
   "fromtcprate1",          FTFROMTCPRATE1,         P(0,1,0,1), DIST_PARAM_LEN,
   "totcprate2",            FTTOTCPRATE2,           P(0,1,0,1), DIST_PARAM_LEN,
   "fromtcprate2",          FTFROMTCPRATE2,         P(0,1,0,1), DIST_PARAM_LEN,

   "toturnaroundtime1",     FTTOTURNAROUNDTIME1,    P(0,1,0,1), DIST_PARAM_LEN,
   "fromturnaroundtime1",   FTFROMTURNAROUNDTIME1,  P(0,1,0,1), DIST_PARAM_LEN,
   "toturnaroundtime2",     FTTOTURNAROUNDTIME2,    P(0,1,0,1), DIST_PARAM_LEN,
   "fromturnaroundtime2",   FTFROMTURNAROUNDTIME2,  P(0,1,0,1), DIST_PARAM_LEN,
   "toturnaroundtime3",     FTTOTURNAROUNDTIME3,    P(0,1,0,1), DIST_PARAM_LEN,
   "fromturnaroundtime3",   FTFROMTURNAROUNDTIME3,  P(0,1,0,1), DIST_PARAM_LEN,
   "toturnaroundtime4",     FTTOTURNAROUNDTIME4,    P(0,1,0,1), DIST_PARAM_LEN,
   "fromturnaroundtime4",   FTFROMTURNAROUNDTIME4,  P(0,1,0,1), DIST_PARAM_LEN,

   "toflowoctets",          FTTOFLOWOCTETS,         P(0,1,0,1), DIST_PARAM_LEN,
   "fromflowoctets",        FTFROMFLOWOCTETS,       P(0,1,0,1), DIST_PARAM_LEN,
   "toflowpdus",            FTTOFLOWPDUS,           P(0,1,0,1), DIST_PARAM_LEN,
   "fromflowpdus",          FTFROMFLOWPDUS,         P(0,1,0,1), DIST_PARAM_LEN,
   "flowtime",              FTFLOWTIME,             P(0,1,0,1), DIST_PARAM_LEN
#endif

#if defined(NETFLOW)
   ,
   "meterid",               FTMETERID,              P(1,1,0,1), 1,
   "sourceasn",             FTLOWROUTEASN,          P(1,1,0,1), TRANS_ADDR_LEN,
   "sourceprefix",          FTLOWROUTEPREFIX,       P(1,1,0,1), 1,
   "destasn",               FTHIROUTEASN,           P(1,1,0,1), TRANS_ADDR_LEN,
   "destprefix",            FTHIROUTEPREFIX,        P(1,1,0,1), 1
#endif

#if defined(NEW_ATR)
   ,
   "tcpdata",               FTTCPDATA,              P(0,1,0,1), 1
                                /* Mask and value not used for TCP data */
#endif
   }
#endif
   ;

#undef DECLARE
#undef INIT
