/* 1155, Fri 13 Sep 96

   SNMPIMPL.H:  Global declarations for snmpauth.c and anmpagnt.c
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmpimpl.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:40  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:31  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:33  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:49  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:40  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:32  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:03  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:32  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2.2.2  1998/10/22 01:28:10  nevil
 * Community data wasn't being copied when PDUs were cloned, which gave
 * unpredictable results when the cloned pdu was freed.  Added code to
 * copy community data properly.  Also added PDU_MALLOC_CHECK define
 * to trace malloc() and Free() operations on pdus.
 *
 * Revision 1.1.3.2.2.1  1998/10/19 02:30:41  nevil
 * Use log_msg() to report errors instead of fprintf(stderr ..)
 *
 * Revision 1.1.3.2  1998/10/14 04:13:49  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.3.1  1998/10/13 02:49:00  nevil
 * Import of Nicolai's 4.2.2
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifdef __cplusplus
extern "C" {
#endif

/*
 * Error codes:
 *
 * These must not clash with SNMP error codes (all positive).
 */
#define PARSE_ERROR -1
#define BUILD_ERROR -2

#define COMMUNITY_MAX_LEN  64
#define MAX_NAME_LEN       64  /* Nbr of subid's in an objid (was 128!) */
          /* Needs to be this long for 'selector' strings within OIDs */
          /* >>> Should be >= AGENT_OID_LEN in agent/snmp_vars.h <<< */

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

struct packet_info {
   int  version;
   u_char   pdutype;

   /* Community based authentication */
   u_char   community[COMMUNITY_MAX_LEN + 1];
   int      community_len;
   int      community_id;

   u_char   *packet_end;
   };

#define READ        1
#define WRITE       0

#define RESERVE1    0
#define RESERVE2    1
#define COMMIT      2
#define ACTION      3
#define FREE        4

/*
 * ##############################################################
 * IMPORTANT NOTE:
 * ##############################################################
 *
 * The format of the acl word in these entries has changed.  It is still
 * 2 bits per community, offset from the right by the index of the community.
 * The leftmost two bits denotes read access, and the rightmost denotes
 * write access.
 * The change is that the rightmost two bits are now reserved for the object's
 * max-access.  This is the minimum of what makes "protocol sense" for the
 * object and whether set support was implemented for that object.
 * These two bits will not map to any community.  The first community
 * entry will map to the 3rd and 4th bits.
 */

#define RONLY    0xAAAA /* Read access for everyone */
/* #define RWRITE    0xAABB   Add write access for community private */
#define RWRITE   0xAAEB /* Add write access for 'private' (wrong bit set above!) */
#define NOACCESS 0x0000 /* No access for anybody */

#define INTEGER     ASN_INTEGER
#define STRING      ASN_OCTET_STR
#define OBJID       ASN_OBJECT_ID
#define NULLOBJ     ASN_NULL
#define BITSTRING   ASN_BIT_STR

/* defined types (from the SMI, RFC 1157) */
#define IPADDRESS   (ASN_APPLICATION | 0)
#define COUNTER     (ASN_APPLICATION | 1)
#define GAUGE       (ASN_APPLICATION | 2)
#define TIMETICKS   (ASN_APPLICATION | 3)
#define OPAQUE      (ASN_APPLICATION | 4)

/* defined types (from the SMI, RFC 1902) */
#define NSAP        (ASN_APPLICATION | 5)
#define COUNTER64   (ASN_APPLICATION | 6)
#define UINTEGER    (ASN_APPLICATION | 7)

/* Textual Conventions (from  RFC 1903) */
#define RS_ACTIVE         1  /* RowStatus values */
#define RS_NOTINSERVICE   2
#define RS_NOTREADY       3
#define RS_CREATEANDGO    4
#define RS_CREATEANDWAIT  5
#define RS_DESTROY        6


struct trapVar {
   oid     *varName;
   int     varNameLen;
   u_char  varType;
   int     varLen;
   u_char  *varVal;
   struct trapVar *next;
   };

#ifdef DEBUG
#define ERROR(string)   \
   log_msg(LOG_DEBUG, 0, "%s(%d): %s\n",__FILE__, __LINE__,string)
      /* In ..\netramet\met_vars.c */
#else
#define ERROR(string)
#endif

#ifdef DOS
extern int scr_lrow;       /* In ..\netramet\pktsnap.h */
void scpos(int x, int y);  /* In ..\netramet\chart.cpp */
#endif

/* From snmp.c */
extern u_char   sid[];  /* Size SID_MAX_LEN */

int snmp_agent_parse(u_char *data, int length,  /* In snmpagnt.c */
   u_char *out_data, int *out_length, Bit32 sourceip);

u_char *snmp_auth_parse(u_char *data, int *length,  /* In snmpauth.c */
   u_char *sid, int *slen, int *version);
u_char *snmp_auth_build(u_char *data, int *length,
   u_char *sid, int *slen, int *version, int messagelen);

typedef int (*write_fn_type)(  /* In meter/met_vars.c */
      int action, u_char *var_val, u_char var_val_type, int var_val_len,
      u_char far *statP, oid *name, int name_len);

u_char far *getStatPtr(
   oid *name, int *namelen, u_char *type, int *len,
   u_short *acl, int exact, write_fn_type *write_method,
   struct packet_info *pi, int *noSuchObject);

#ifdef __cplusplus
}           // end extern "C"
#endif
