/* 1710, Mon 9 Sep 96

   SNMPCLNT.H:  Global declarations for SNMP client routines.
                NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmpclnt.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:40  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:31  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:33  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:40  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:32  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:32  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/14 04:13:49  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:02  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

struct synch_state {
   int  waiting;
   int status;
/* status codes */
#define STAT_SUCCESS    0
#define STAT_ERROR  1
#define STAT_TIMEOUT 2
   int reqid;
   struct snmp_pdu *pdu;
   };

extern struct synch_state snmp_synch_state;

struct snmp_pdu *snmp_pdu_create(int command);
void snmp_add_null_var(struct snmp_pdu *pdu,
   oid *name, int name_length);
int snmp_synch_input(int op, struct snmp_session *session,
   int reqid, struct snmp_pdu *pdu, void *magic);
struct snmp_pdu *snmp_fix_pdu(struct snmp_pdu *pdu, int command);
struct snmp_pdu *snmp_clone_pdu(struct snmp_pdu *pdu);
int snmp_synch_response(struct snmp_session *ss,
   struct snmp_pdu *pdu, struct snmp_pdu **response);
void snmp_synch_setup(struct snmp_session *session);
char *snmp_errstring(int errstat);

#ifdef __cplusplus
}           // end extern "C"
#endif
