/* 1010, Mon 9 Sep 96

   SNMPAUTH.C:  Routines to parse and build community-based
                   authentication headers for SNMP.
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */


/*
 * $Log: snmpauth.c,v $
 * Revision 1.1.1.2.2.8  2002/02/23 01:57:40  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.4  2000/06/06 03:38:30  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  1999/11/29 00:17:30  nevil
 * Make changes to support NetBSD on an Alpha (see version.history for details)
 *
 * Revision 1.1.1.2  1999/10/03 21:06:32  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:48  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:39  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:32  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:31  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/14 04:13:48  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:02  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/**********************************************************************
    Copyright 1988, 1989, 1991, 1992 by Carnegie Mellon University
  
			 All Rights Reserved
  
Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  
  
CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#if HAVE_CONFIG_H
#include <ntm_conf.h>
#endif

#include <stdlib.h>
#include <stdio.h>  /* Used by ERROR() define */

#if !defined(DOS)
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#endif

#ifdef vms
#include <in.h>
#endif

#include "ausnmp.h"

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"


u_char *snmp_auth_parse(u_char *data, int *length,
   u_char *sid, int *slen, int *version)
{
   u_char type;
   Bit32 dummy;
   
   data = asn_parse_header(data, length, &type);
   if (data == NULL){
      ERROR("auth: bad header");
      return NULL;
      }
   if (type != (ASN_SEQUENCE | ASN_CONSTRUCTOR)){
       ERROR("auth: wrong header type");
       return NULL;
      }
   data = asn_parse_int(data, length, &type, &dummy, sizeof dummy);
   if (data == NULL){
      ERROR("bad parse of version");
      return NULL;
      }
   *version = (int)dummy;
   data = asn_parse_string(data, length, &type, sid, slen);
   if (data == NULL){
      ERROR("bad parse of community");
      return NULL;
      }
   sid[*slen] = '\0';
   return (u_char *)data;
   }

u_char *snmp_auth_build(
   u_char  *data,
   int     *length,
   u_char  *sid,
   int     *slen,
   int    *version,
   int     messagelen)
{
   data = asn_build_sequence(data, length,
      (u_char)(ASN_SEQUENCE | ASN_CONSTRUCTOR), messagelen + *slen + 5);
   if (data == NULL){
      ERROR("buildheader");
      return NULL;
      }
   data = asn_build_int(data, length,
      (u_char)(ASN_UNIVERSAL | ASN_PRIMITIVE | ASN_INTEGER),
      (Bit32 *)version, sizeof *version);
   if (data == NULL){
      ERROR("buildint");
      return NULL;
      }
   data = asn_build_string(data, length,
      (u_char)(ASN_UNIVERSAL | ASN_PRIMITIVE | ASN_OCTET_STR),
      sid, *slen);
   if (data == NULL){
      ERROR("buildstring");
      return NULL;
      }
   return (u_char *)data;
   }
