/* 1000, Mon 9 Sep 96

   SNMP.C:  Routines to parse and build SNMP PDUs
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmp.c,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:38  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:27  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:30  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:47  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:37  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:31  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:31  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2.2.2  1998/10/22 01:28:07  nevil
 * Community data wasn't being copied when PDUs were cloned, which gave
 * unpredictable results when the cloned pdu was freed.  Added code to
 * copy community data properly.  Also added PDU_MALLOC_CHECK define
 * to trace malloc() and Free() operations on pdus.
 *
 * Revision 1.1.3.2.2.1  1998/10/19 02:30:38  nevil
 * Use log_msg() to report errors instead of fprintf(stderr ..)
 *
 * Revision 1.1.3.2  1998/10/14 04:13:46  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:01  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.3  1998/06/03 04:42:38  rtfm
 * Include select.h (for snmpapi.h)
 */

/**********************************************************************
	Copyright 1988, 1989, 1991, 1992 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#if HAVE_CONFIG_H
#include <ntm_conf.h>
#endif

#define TESTING  0

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef DOS
#include "tcp.h"
#else
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#endif

#ifdef vms
#include <in.h>
#endif

#include "ausnmp.h"

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "snmpapi.h"

#include "mib.h"
#include "parse.h"


void xdump(u_char *cp, int length, char *prefix)
{
   int col, count;

   count = 0;
   while (count < length) {
      printf("%s", prefix);
      for (col = 0;count + col < length && col < 16; col++) {
	 if (col != 0 && (col % 4) == 0)
	    printf(" ");
	 printf("%02X ", cp[count + col]);
	 }
      while (col++ < 16) {  /* Pad end of buffer with zeros */
	 if ((col % 4) == 0)
	    printf(" ");
	 printf("   ");
	 }
      printf("  ");
      for (col = 0;count + col < length && col < 16; col++) {
	 if (isprint(cp[count + col]))
	    printf("%c", cp[count + col]);
	 else printf(".");
	 }
      printf("\n");
      count += col;
      }
   }


u_char *snmp_parse_var_op(
   u_char *data,          /* IN - pointer to the start of object */
   oid	  *var_name,      /* OUT - object id of variable */
   int	  *var_name_len,  /* IN/OUT - length of variable name */
   u_char *var_val_type,  /* OUT - type of variable (int or octet string) (one byte) */
   int	  *var_val_len,   /* OUT - length of variable */
   u_char **var_val,	  /* OUT - pointer to ASN1 encoded value of variable */
   int	  *listlength)    /* IN/OUT - number of valid bytes left in var_op_list */
{
   u_char  var_op_type;
   int	   var_op_len = *listlength;
   u_char  *var_op_start = data;

   data = asn_parse_header(data, &var_op_len, &var_op_type);
   if (data == NULL) {
      ERROR("couldn't parse header");
      return NULL;
      }
   if (var_op_type != (u_char)(ASN_SEQUENCE | ASN_CONSTRUCTOR))
      return NULL;
   data = asn_parse_objid(data, &var_op_len, &var_op_type,
      var_name, var_name_len);
   if (data == NULL) {
      ERROR("couldn't parse var_name");
      return NULL;
      }
   if (var_op_type != (u_char)(ASN_UNIVERSAL | ASN_PRIMITIVE | ASN_OBJECT_ID))
      return NULL;
   *var_val = data;	/* save pointer to this object */
   /* find out what type of object this is */
   data = asn_parse_header(data, &var_op_len, var_val_type);
   if (data == NULL) {
      ERROR("couldn't parse object type");
      return NULL;
      }
   *var_val_len = var_op_len;
   data += var_op_len;
   *listlength -= (int)(data - var_op_start);
   return data;
   }

u_char *snmp_build_var_op(
   u_char     *data,	      /* IN - pointer to start of output buffer */
   oid	      *var_name,      /* IN - object id of variable */
   int	      *var_name_len,  /* IN - length of object id */
   u_char     var_val_type,   /* IN - type of variable */
   int	      var_val_len,    /* IN - length of variable */
   u_char far *var_val,	      /* IN - value of variable */
   int        *listlength)    /* IN/OUT - number of valid bytes left in
				   output buffer */
{
   int	   dummyLen, headerLen, header_shift;
   u_char  *dataPtr;
#if TESTING
   int j;
#endif

   dummyLen = *listlength;
   dataPtr = data;
#if TESTING
   scpos(0,24);
   printf("build_var_op(): type=%d, length=%d\n   name_len=%d, *value=%p, data=%p, listlen=%d\n",
      var_val_type,var_val_len,  *var_name_len,var_val,data,dummyLen);
#endif
   data += 4;  /* asn_build_sequence() always takes 4 bytes */
   dummyLen -=4;
   if (dummyLen < 0)
      return NULL;

   headerLen = data - dataPtr;
   *listlength -= headerLen;
   data = asn_build_objid(data, listlength,
      (u_char)(ASN_UNIVERSAL | ASN_PRIMITIVE | ASN_OBJECT_ID),
      var_name, *var_name_len);
   if (data == NULL) {  /* OID would over-run data array */
/*      ERROR("");  ntm */
      return NULL;
      }
#if TESTING
   printf("   header & oid OK, data=%p\n",data);
#endif
   switch(var_val_type) {
   case ASN_INTEGER:
      data = asn_build_int(data, listlength, var_val_type,
	 (Bit32 far *)var_val, var_val_len);
#if TESTING
      printf("   build_int(%d) returned %p\n", 
         *((Int32 far *)var_val), data);
#endif
      break;
   case GAUGE:
   case COUNTER:
   case TIMETICKS:
   case UINTEGER:
      data = asn_build_unsigned_int(data, listlength, var_val_type,
         (Bit32 far *)var_val, var_val_len);
#if TESTING
      printf("   build_us_int(%u) returned %p\n", 
         *((Bit32 far *)var_val), data);
#endif
      break;
   case COUNTER64:
      data = asn_build_unsigned_int64(data, listlength, var_val_type,
         (counter64 far *)var_val, var_val_len);
#if TESTING
      printf("   build_us_int64 returned %p\n", data);
#endif
      break;
   case ASN_OCTET_STR:
   case IPADDRESS:
   case OPAQUE:
   case NSAP:
#if TESTING
      scpos(0,24);
      printf("snmp_build_var_op(string): var_val=%Fp, value=", var_val);
      for (j = 0; j != 4; ++j) printf(".%0x",var_val[j]);
      printf("\n");
#endif
      data = asn_build_string(data, listlength, var_val_type,
         var_val, var_val_len);
      break;
   case ASN_OBJECT_ID:
      data = asn_build_objid(data, listlength, var_val_type,
         (oid far *)var_val, var_val_len / sizeof(oid));
      break;
   case ASN_NULL:
      data = asn_build_null(data, listlength, var_val_type);
      break;
   case ASN_BIT_STR:
      data = asn_build_bitstring(data, listlength, var_val_type,
         var_val, var_val_len);
      break;
   case SNMP_NOSUCHOBJECT:
   case SNMP_NOSUCHINSTANCE:
   case SNMP_ENDOFMIBVIEW:
      data = asn_build_null(data, listlength, var_val_type);
      break;
   default:
      ERROR("wrong type");
      return NULL;
      }
   if (data == NULL) {  /* Value would over-run data array */
/*      ERROR("");  ntm */
      return NULL;
      }
   dummyLen = (data - dataPtr) - headerLen;

   asn_build_sequence(dataPtr, &dummyLen,
      (u_char)(ASN_SEQUENCE | ASN_CONSTRUCTOR), dummyLen);
   return data;
   }
