#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "/home/nevil/dag-2.2.1s/include/dag.h"
#include <sys/ioctl.h>
#include <fcntl.h>


int dag_reset(int ifd)
{  /* Ask dag card to do a level 2 reset */
   dagioaddr dagioa;
   int r;

   /* The card has a reset register at 0x88.  The relevant bitmap is:
         Bit 31: Trigger level 2 reset (auto clearing)
         Bit 30: Trigger level 1 reset (not auto clearing) */

   dagioa.offset = 0x88;
   dagioa.val = 0x80000000;
   printf("dag_reset(0): about to reset /dev/dag%d\n", ifd);
   r = ioctl(ifd, DAG_IOWRITE, &dagioa);
   printf("dag_reset(1): ioctl returned %d\n", r);
   if (r != 0)
      printf("   error %d, %s\n", errno, strerror(errno));
   }

int main(int argc, char *argv[])
{
   int ifd, flags;

   if ((ifd = open("/dev/dag0", O_RDONLY)) < 0) {
      printf("iif: open(): errno=%d, %s\n", errno, strerror(errno));
      exit(1);  /* Fail */
      }
   if ((flags = fcntl(ifd, F_GETFL, 0)) < 0) {
      printf("iif: getfl(): fcntl get failed\n");
      exit(2);  /* Fail */
      }
   flags |= O_NONBLOCK;
   if (fcntl(ifd, F_SETFL, flags) < 0) {
      printf("iif: nonblck(): fcntl set failed\n");
      exit(3);  /* Fail */
      }
   dag_reset(ifd);

   }
