/* 1949, Wed 16 Feb 00

   LOOK_TST.C: Test libpcap device/network lookup routines
               This shows you what Nevil's Cygwin/Windump/pcap
               will use as the default interface

   Copyright (C) 2000-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

#include <stdio.h>
#include <stdlib.h>

#include "pcap.h"

int main()
{
   char *dev, eb[100];
   int r;  bpf_u_int32 addr, mask;

   if ((dev = pcap_lookupdev(eb)) == NULL)
      printf("lookupdev() failed, %s\n", eb);
   else printf("lookupdev() returned %s\n", dev);

   if (pcap_lookupnet(dev, &addr,&mask, eb) != 0)
      printf("lookupnet() failed, %s\n", eb);
   else  printf("lookupnet() returned addr=%08x, mask=%08x\n", addr,mask);
   }
