#ifndef _SUBNETP_H
#define _SUBNETP_H




#define MAX_SUBNET_MEMREFS  1
#define MAX_TREE_LEAVES     BIT32_MAX



/* radix trie node used internally for Subnet lookup
 */
typedef struct SubnetTree_ SubnetTree;
struct SubnetTree_
{
   SubnetTree *zero;        /* if bit is zero */
   SubnetTree *one;         /* if bit is one  */
   SubnetTree *parent;      /* for backtracing, NULL if root of tree */
   int bit;                 /* which bit to test, counting 0 as lsb       must be signed to allow host routes! */
   Bit32 mask;              /* speeds up the single-bit test; in network byte order */
   Subnet *external;        /* if non NULL, the address and mask */
};



#endif      /* not included yet */
