#ifndef _SUBNETD_H
#define _SUBNETD_H




#define BITS_PER_NODE       8
#define POINTERS_PER_NODE   (1 << BITS_PER_NODE)
#define NODE_INDEX_MASK     (POINTERS_PER_NODE - 1)

#define BITS_PER_ROOT       16
#define POINTERS_PER_ROOT   (1 << BITS_PER_ROOT)
#define ROOT_INDEX_MASK     (POINTERS_PER_ROOT - 1)

#if SIZEOF_LONG == 4
# define POINTER_DATATYPE   Bit32
#else  /* Alpha */
# define POINTER_DATATYPE   unsigned long  /* 64-bit */
#endif
#define POINTER_MAX         BIT32_MAX  /* types/types.h uses ULONG_MAX */

#define MAX_SUBNET_MEMREFS  (1 + ((MAX_ADDR_BITS - BITS_PER_ROOT + BITS_PER_NODE - 1) / BITS_PER_NODE))
#define MAX_TREE_NODES      4096
#define MAX_TREE_LEAVES     (POINTER_MAX - MAX_TREE_NODES)



/* macros
 */
#define EXTERN_FROM_NODE(node)  ((node)==MAX_TREE_NODES ? NULL : first_external+((node)-MAX_TREE_NODES-1))
#define NODE_FROM_EXTERN(ext)   ((ext)==NULL ? MAX_TREE_NODES : ((Subnet *)(ext)-first_external)+MAX_TREE_NODES+1)
#define PTR_FROM_NODE(node)     (subnet_pool+(node))
#define IS_NODE_A_LEAF(node)    ((node) >= MAX_TREE_NODES)
#define XLATE_PTR(ptr,base)     ((POINTER_DATATYPE)(ptr) - (POINTER_DATATYPE)(base))
#define XLATE_PTR_COND(ptr,lbase,nbase)     (IS_NODE_A_LEAF(ptr) ? XLATE_PTR(EXTERN_FROM_NODE(ptr),lbase) : XLATE_PTR(PTR_FROM_NODE(ptr),nbase))
#define level_from_bits(addr_bits_left,level_bits)  ((addr_bits_left-level_bits+1)/BITS_PER_NODE)



/* radix trie node used internally for Subnet lookup
 */
typedef struct SubnetTree_ SubnetTree;
struct SubnetTree_
{
   POINTER_DATATYPE pointers[ POINTERS_PER_NODE ];
};



#endif      /* not included yet */
