#ifndef _CONSTANT_H
#define _CONSTANT_H



/* manifest constants

   it is okay for these to have forward references
   because the string substitution doesnt occur
   until the macro is used in the code far below
*/

/* Irix compiler doesn*t like apostrophes in // comments! */

#ifndef CAPTURE_TO_DISK
#define CAPTURE_TO_DISK             FALSE
#endif
#ifndef CARD_COPIES_ATM_PAYLOAD
#define CARD_COPIES_ATM_PAYLOAD     TRUE        // set to FALSE when only ATM header was captured
#endif
#ifndef CELLS_PER_PACKET
#define CELLS_PER_PACKET            1           // number of non-last cells copied to host
#endif
#ifndef CARD_SKIPS_GIGASWITCH
#define CARD_SKIPS_GIGASWITCH       FALSE       // set to TRUE for NIC to toss 16 bytes at beg of 1st cell, keep 16 bytes at beg of 2nd cell, ignoring VPI/VCI
#endif
#ifndef HOST_SKIPS_GIGASWITCH
#define HOST_SKIPS_GIGASWITCH       FALSE       // set to TRUE for host to use gigaswitch layout for 1st and 2nd cells
#endif
#ifndef HOST_SKIPS_LANE
#define HOST_SKIPS_LANE             FALSE       // set to TRUE for host to use LAN emulation layout for 1st and 2nd cells
#endif
#ifndef LINK_HAS_LLC_SNAP
#define LINK_HAS_LLC_SNAP           TRUE        // set to TRUE for host to check LLC/SNAP in front of packet, FALSE to assume it isnt there
#endif
#ifndef LINK_HAS_NLPID
#define LINK_HAS_NLPID              FALSE       // set to TRUE for host to check NLPID in front of packet, FALSE to assume it isnt there
#endif
#ifndef CARD_COPIES_LAST_CELL                   /* should this be runtime controlled? */
#define CARD_COPIES_LAST_CELL       FALSE       // this is independent of how many first cells are copied
#endif
#ifndef CARD_COPIES_OAM_CELLS                   /* should this be runtime controlled? */
#define CARD_COPIES_OAM_CELLS       FALSE       // ignored by FORE cards for now
#endif
#ifndef CARD_COPIES_ALL_CELLS
#define CARD_COPIES_ALL_CELLS       FALSE       // set to TRUE when all cells were captured, overrides CARD_COPIES_LAST_CELL and CARD_COPIES_OAM_CELLS
#endif
#ifndef CARD_IS_OC12
#define CARD_IS_OC12                FALSE
#endif

#define CELL_SIZE                   48L         // including only payload
#if !NETRAMET
#if CARD_COPIES_ATM_PAYLOAD  /* 1 char too long for Irix compiler! */
#define BUFFER_SIZE                 (12 + 1*CELL_SIZE) // including headers that SAR wants per buffer
#else
#define BUFFER_SIZE                 12          // including headers that SAR wants per buffer
#endif
#endif  /* !NETRAMET */
#define SEND_BUFFER_SIZE            sizeof(tracerec_send)
#define WORDS_PER_SEND              (SEND_BUFFER_SIZE / 4)
#define SECTOR_SIZE                 512
#define MAX_BLOCK_SIZE              (1024*1024) // one megabyte

/* how many receive records will fit into MAX_BLOCK_SIZE
   while still occupying an even multiple of SECTOR_SIZE
*/
#define COMPL_RING_ENTRIES          (HW_RING_ENTRIES)
#define HW_RING_ENTRIES             (SECTOR_SIZE * (MAX_BLOCK_SIZE / (BUFFER_SIZE * SECTOR_SIZE)))

/* how many transmit records will fit into a BufferBlock
   while still occupying an even multiple of SECTOR_SIZE

   (not how many transmit records will fit into MAX_BLOCK_SIZE
   while still occupying an even multiple of SECTOR_SIZE,
   or how many can be packed into a BufferBlock)
*/
#define SEND_RING_ENTRIES           (SECTOR_SIZE * ((COMPL_RING_ENTRIES * BUFFER_SIZE) / (SEND_BUFFER_SIZE * SECTOR_SIZE)))

/* how many cards we will use in host computer
*/
#define MAX_ATM_NICS                2

/* which is the first ATM card we will use (counting from zero)?

   this is meaningful when there are more cards in machine that wanted
*/
#define ATM_NIC_OFFSET              0

/* compile-time switches which depend on others
*/
#if NETRAMET
#define DO_FOREGROUND_STATS         TRUE
#else
#if CARD_COPIES_ATM_PAYLOAD && !CAPTURE_TO_DISK
#define DO_FOREGROUND_STATS         TRUE
#else
#define DO_FOREGROUND_STATS         FALSE
#endif
#endif  /* !NETRAMET */

#if CARD_IS_OC12
#define CARD_SWAPS_ATM_HEADER       FALSE
#else
#define CARD_SWAPS_ATM_HEADER       TRUE
#endif

/* (relative) directories and filenames for headers
   which depend on the ATM interface card we are using
*/
#if CARD_IS_OC12
#define CARD_CLOCK_HEADER           "../apptel/cardstmp.h"
#define CARD_CLOCK_SOURCE           "../apptel/cardstmp.cpp"
#define CARD_DRIVER_HEADER          "../apptel/driver.h"
#else
#define CARD_CLOCK_HEADER           "../fore/cardstmp.h"
#define CARD_CLOCK_SOURCE           "../fore/cardstmp.cpp"
#define CARD_DRIVER_HEADER          "../fore/driver.h"
#endif


#endif      // not included yet
