#               InspIRCd Main Makefile
#
#       (C) InspIRCd Development Team, 2002-2009
# This file is automagically generated by configure, from
#     .Makefile.inc. Any changes make will go away!
#   Please do not edit unless you know what you're doing.
#

@GNU_ONLY COMPILE_ROOT = $(shell pwd)
@BSD_ONLY COMPILE_ROOT != pwd

@IFDEF D
    NICEFLAGS = @DEVELOPER@
    HEADER = debug-header
@ENDIF

NICEFLAGS ?= @FLAGS@
HEADER ?= std-header

NICEFLAGS += -I$(COMPILE_ROOT)/include

CC = @CC@
FLAGS = $(NICEFLAGS) -pedantic
LDLIBS = @LDLIBS@
BASE = "@BASE_DIR@"
CONPATH = "@CONFIG_DIR@"
MODPATH = "@MODULE_DIR@"
BINPATH = "@BINARY_DIR@"
LAUNCHDPATH = "/System/Library/LaunchDaemons"
LIBPATH = "@LIBRARY_DIR@"
MODULES = @MODULES@
INSTMODE = 0755
@GNU_ONLY MAKEFLAGS += --no-print-directory

@IFDEF V
    RUNCC = $(CC)
@ELSE
    @GNU_ONLY MAKEFLAGS += --silent
    RUNCC = $(COMPILE_ROOT)/make/run-cc.pl $(CC)
@ENDIF

@GNU_ONLY export COMPILE_ROOT RUNCC FLAGS NICEFLAGS CC LDLIBS MODULES MODPATH LIBPATH INSTMODE
@BSD_ONLY MAKEARGS = -s 'RUNCC=${RUNCC}' 'FLAGS=${FLAGS}' 'NICEFLAGS=${NICEFLAGS}' 'CC=${CC}' 'LDLIBS=${LDLIBS}' 'MODULES=${MODULES}' 'MODPATH=${MODPATH}' 'LIBPATH=${LIBPATH}' 'INSTMODE=${INSTMODE}'

# Default target

@IFDEF M
   _all: module
@ENDIF

all: ircd mods finishmessage

debug:
	@${MAKE} D=1 all

debug-header:
	@echo "*************************************"
	@echo "*    BUILDING WITH DEBUG SYMBOLS    *"
	@echo "*                                   *"
	@echo "*   This will take a *long* time.   *"
	@echo "*  Please be aware that this build  *"
	@echo "*  will consume a very large amount *"
	@echo "*  of disk space (150MB+), and can  *"
	@echo "*  run slower. Use the debug build  *"
	@echo "*  for module development or if you *"
	@echo "*    are experiencing problems.     *"
	@echo "*                                   *"
	@echo "*************************************"

std-header:
	@echo "*************************************"
	@echo "*       BUILDING INSPIRCD           *"
	@echo "*                                   *"
	@echo "*   This will take a *long* time.   *"
	@echo "*     Why not read our wiki at      *"
	@echo "*     http://wiki.inspircd.org      *"
	@echo "*  while you wait for make to run?  *"
	@echo "*************************************"

ircd: $(HEADER)
	@${MAKE} -C src $(MAKEARGS) inspircd commands

mods: $(HEADER)
	@${MAKE} -C src/modules $(MAKEARGS)

# Make this depend on 'ircd' and 'mods', so its always output last even with -j
finishmessage: ircd mods
	@echo ""
	@echo "*************************************"
	@echo "*        BUILD COMPLETE!            *"
	@echo "*                                   *"
	@echo "*   To install InspIRCd, type:      *"
	@echo "*         make install              *"
	@echo "*************************************"

install: ircd mods@EXTRA_DIR@
	@-install -d -m $(INSTMODE) $(BASE)
	@-install -d -m $(INSTMODE) $(LIBPATH)
	@-install -d -m $(INSTMODE) $(BINPATH)
	@-install -d -m $(INSTMODE) $(CONPATH)
	@-install -d -m $(INSTMODE) $(MODPATH)
	-install -m $(INSTMODE) @STARTSCRIPT@ $(@DESTINATION@) 2>/dev/null
@INSTALL_LIST@	@echo ""
	@echo "*************************************"
	@echo "*        INSTALL COMPLETE!          *"
	@echo "*                                   *"
	@echo "* It is safe to ignore any messages *"
	@echo "* related to copying of conf files. *"
	@echo "*                                   *"
	@echo "* REMEMBER TO EDIT YOUR CONFIG FILE *"
	@echo "*************************************"

module:
	@BSD_ONLY @${MAKE} -C src/modules $(MAKEARGS) ${M:S/.so$//}.so
	@GNU_ONLY @${MAKE} -C src/modules $(MAKEARGS) $(M:.so=).so

clean:
	@echo Cleaning...
	@rm -f src/inspircd src/modes/modeclasses.a
	@rm -f src/*.so src/modules/*.so src/commands/*.so src/modules/*/*.so
	@rm -f src/*.o src/*/*.o src/modules/*/*.o
	@echo Completed.

modclean:
	rm -f src/modules/*.so
	rm -f src/modules/*.o
	rm -f src/modules/*/*.so
	rm -f src/modules/*/*.o

deinstall:
@UNINSTALL_LIST@

squeakyclean: distclean

launchd_dir:
	@-install -d -m $(INSTMODE) ${LAUNCHDPATH}

configureclean:
	rm -f .config.cache
	rm -f src/modules/Makefile
	rm -f src/commands/Makefile
	rm -f src/Makefile
	-rm -f Makefile
	rm -f BSDmakefile
	rm -f GNUmakefile
	rm -f include/inspircd_config.h
	rm -f include/inspircd_se_config.h

distclean: modclean clean configureclean

help:
	@echo 'InspIRCd Makefile'
	@echo ''
	@echo 'Use: ${MAKE} [flags] [targets]'
	@echo ''
	@echo 'Flags:'
	@echo ' V=1       Show the full command being executed instead of "BUILD: dns.cpp"'
	@echo ' D=1       Enable debug build, for module development or crash tracing'
	@echo ' -j <N>    Run a parallel build using N jobs'
	@echo ''
	@echo 'User targets:'
	@echo ' all       Complete build of InspIRCd, without installing'
	@echo ' install   Build and install InspIRCd to the directory chosen in ./configure'
	@echo '           Currently installs to ${BASE}'
	@echo ' debug     Compile a debug build. Equivalent to "make D=1 all"'
	@echo ' module    Builds a single module, which is specified by "M=m_modname"'
	@echo '           The command "make M=m_modname" is a shortcut for this target'
	@echo ''
	@echo ' clean     Cleans object files produced by the compile'
	@echo ' distclean Cleans all files produced by compile and ./configure'
	@echo ' deinstall Removes the files created by "make install"'
	@echo

.PHONY: all help debug debug-header std-header ircd mods finishmessage install module clean modclean deinstall squeakyclean launchd_dir configureclean
