/* header file for hash functions */

#ifndef HASH_H
#define HASH_H

#define FLAG_A 1
#define FLAG_B 2
#define FLAG_P 3
#define HASH_MISS -21000
#define HASH_MOVE -21001

/* standard hash record - 16 bytes long */
struct hash_rec
{
  unsigned long key;
  unsigned short address;
  short score;
  char flag;
  unsigned char depth;
  move hmove;
  unsigned char id;
  unsigned char mate_ext;
};

/* pawn hash record - 20 bytes long */
struct pawn_rec
{
  unsigned long key;
  short score;
  unsigned char wposts;
  unsigned char bposts;
  unsigned char ks_defects_w;
  unsigned char qs_defects_w;
  unsigned char ks_defects_b;
  unsigned char qs_defects_b;
  unsigned char open_files;
  unsigned char half_open_files_w;
  unsigned char half_open_files_b;
  unsigned char passed_w;
  unsigned char passed_b;
  unsigned char light_pawns_w;
  unsigned char light_pawns_b;
};

/* Number of hash related functions */
void open_hash();
void close_hash();
void set_hash_size(int Mbytes);
void put_hash(h_code h_key, int score, int alpha, int beta, int depth, move hmove, int mate_ext);
int get_hash(h_code h_key, int alpha, int beta, int depth, int *mate_ext, int *null_hash, move *gmove);
int get_move(h_code h_key);
h_code gen_code(position *p);
void start_code();
float ran(long *idum);

/* Macro for or'ing two hash codes */
#define or(A, B)   A.address ^= B.address;  A.key ^= B.key

#endif HASH_H
