/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6819270431752240878L;
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private volatile boolean getConnectionCalled;
    private ConnectionPoolDataSource dataSource;
    private String dataSourceName;
    private String description;
    private Properties jndiEnvironment;
    private Duration loginTimeoutDuration = Duration.ZERO;
    private PrintWriter logWriter;
    private String instanceKey;
    private volatile boolean defaultBlockWhenExhausted = true;
    private String defaultEvictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private volatile boolean defaultLifo = true;
    private volatile int defaultMaxIdle = 8;
    private volatile int defaultMaxTotal = -1;
    private Duration defaultMaxWaitDuration = BaseObjectPoolConfig.DEFAULT_MAX_WAIT;
    private Duration defaultMinEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    private volatile int defaultMinIdle = 0;
    private volatile int defaultNumTestsPerEvictionRun = 3;
    private Duration defaultSoftMinEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION;
    private volatile boolean defaultTestOnCreate = false;
    private volatile boolean defaultTestOnBorrow = false;
    private volatile boolean defaultTestOnReturn = false;
    private volatile boolean defaultTestWhileIdle = false;
    private Duration defaultDurationBetweenEvictionRuns = BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS;
    private String validationQuery;
    private Duration validationQueryTimeoutDuration = Duration.ofSeconds(-1L);
    private volatile boolean rollbackAfterValidation;
    private Duration maxConnDuration = Duration.ofMillis(-1L);
    private Boolean defaultAutoCommit;
    private volatile int defaultTransactionIsolation = -1;
    private Boolean defaultReadOnly;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    @Override
    public abstract void close() throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo pooledConnectionAndInfo) {
        if (pooledConnectionAndInfo != null) {
            try {
                pooledConnectionAndInfo.getPooledConnection().getConnection().close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + exception.getMessage());
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Object object;
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
        }
        catch (RuntimeException | SQLException exception2) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw exception2;
        }
        catch (Exception exception3) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLException("Cannot borrow connection from pool", exception3);
        }
        if (!(null != string2 ? string2.equals(pooledConnectionAndInfo.getPassword()) : null == pooledConnectionAndInfo.getPassword())) {
            try {
                this.testCPDS(string, string2);
            }
            catch (SQLException sQLException) {
                this.closeDueToException(pooledConnectionAndInfo);
                throw new SQLException("Given password did not match password used to create the PooledConnection.", sQLException);
            }
            catch (NamingException namingException) {
                throw new SQLException("NamingException encountered connecting to database", namingException);
            }
            object = pooledConnectionAndInfo.getUserPassKey();
            PooledConnectionManager pooledConnectionManager = this.getConnectionManager((UserPassKey)object);
            pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
            pooledConnectionManager.setPassword(((UserPassKey)object).getPasswordCharArray());
            pooledConnectionAndInfo = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
                }
                catch (RuntimeException | SQLException exception4) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw exception4;
                }
                catch (Exception exception5) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw new SQLException("Cannot borrow connection from pool", exception5);
                }
                if (pooledConnectionAndInfo != null && string2 != null && string2.equals(pooledConnectionAndInfo.getPassword())) break;
                if (pooledConnectionAndInfo != null) {
                    pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
                }
                pooledConnectionAndInfo = null;
            }
            if (pooledConnectionAndInfo == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        object = pooledConnectionAndInfo.getPooledConnection().getConnection();
        try {
            this.setupDefaults((Connection)object, string);
            object.clearWarnings();
            return object;
        }
        catch (SQLException sQLException) {
            Utils.close((AutoCloseable)object, exception -> this.getLogWriter().println("ignoring exception during close: " + String.valueOf(exception)));
            throw sQLException;
        }
    }

    protected abstract PooledConnectionManager getConnectionManager(UserPassKey var1);

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getDefaultBlockWhenExhausted() {
        return this.defaultBlockWhenExhausted;
    }

    public Duration getDefaultDurationBetweenEvictionRuns() {
        return this.defaultDurationBetweenEvictionRuns;
    }

    public String getDefaultEvictionPolicyClassName() {
        return this.defaultEvictionPolicyClassName;
    }

    public boolean getDefaultLifo() {
        return this.defaultLifo;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public int getDefaultMaxTotal() {
        return this.defaultMaxTotal;
    }

    public Duration getDefaultMaxWait() {
        return this.defaultMaxWaitDuration;
    }

    @Deprecated
    public long getDefaultMaxWaitMillis() {
        return this.getDefaultMaxWait().toMillis();
    }

    public Duration getDefaultMinEvictableIdleDuration() {
        return this.defaultMinEvictableIdleDuration;
    }

    @Deprecated
    public long getDefaultMinEvictableIdleTimeMillis() {
        return this.defaultMinEvictableIdleDuration.toMillis();
    }

    public int getDefaultMinIdle() {
        return this.defaultMinIdle;
    }

    public int getDefaultNumTestsPerEvictionRun() {
        return this.defaultNumTestsPerEvictionRun;
    }

    public Duration getDefaultSoftMinEvictableIdleDuration() {
        return this.defaultSoftMinEvictableIdleDuration;
    }

    @Deprecated
    public long getDefaultSoftMinEvictableIdleTimeMillis() {
        return this.defaultSoftMinEvictableIdleDuration.toMillis();
    }

    public boolean getDefaultTestOnBorrow() {
        return this.defaultTestOnBorrow;
    }

    public boolean getDefaultTestOnCreate() {
        return this.defaultTestOnCreate;
    }

    public boolean getDefaultTestOnReturn() {
        return this.defaultTestOnReturn;
    }

    public boolean getDefaultTestWhileIdle() {
        return this.defaultTestWhileIdle;
    }

    @Deprecated
    public long getDefaultTimeBetweenEvictionRunsMillis() {
        return this.defaultDurationBetweenEvictionRuns.toMillis();
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public String getDescription() {
        return this.description;
    }

    protected String getInstanceKey() {
        return this.instanceKey;
    }

    public String getJndiEnvironment(String string) {
        String string2 = null;
        if (this.jndiEnvironment != null) {
            string2 = this.jndiEnvironment.getProperty(string);
        }
        return string2;
    }

    @Override
    @Deprecated
    public int getLoginTimeout() {
        return (int)this.loginTimeoutDuration.getSeconds();
    }

    public Duration getLoginTimeoutDuration() {
        return this.loginTimeoutDuration;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        }
        return this.logWriter;
    }

    public Duration getMaxConnDuration() {
        return this.maxConnDuration;
    }

    @Deprecated
    public Duration getMaxConnLifetime() {
        return this.maxConnDuration;
    }

    @Deprecated
    public long getMaxConnLifetimeMillis() {
        return this.maxConnDuration.toMillis();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Deprecated
    public int getValidationQueryTimeout() {
        return (int)this.validationQueryTimeoutDuration.getSeconds();
    }

    public Duration getValidationQueryTimeoutDuration() {
        return this.validationQueryTimeoutDuration;
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.dataSource != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.dataSource = connectionPoolDataSource;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public void setDataSourceName(String string) {
        this.assertInitializationAllowed();
        if (this.dataSource != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = string;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = bl;
    }

    public void setDefaultBlockWhenExhausted(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultBlockWhenExhausted = bl;
    }

    public void setDefaultDurationBetweenEvictionRuns(Duration duration) {
        this.assertInitializationAllowed();
        this.defaultDurationBetweenEvictionRuns = duration;
    }

    public void setDefaultEvictionPolicyClassName(String string) {
        this.assertInitializationAllowed();
        this.defaultEvictionPolicyClassName = string;
    }

    public void setDefaultLifo(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultLifo = bl;
    }

    public void setDefaultMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = n;
    }

    public void setDefaultMaxTotal(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxTotal = n;
    }

    public void setDefaultMaxWait(Duration duration) {
        this.assertInitializationAllowed();
        this.defaultMaxWaitDuration = duration;
    }

    @Deprecated
    public void setDefaultMaxWaitMillis(long l) {
        this.setDefaultMaxWait(Duration.ofMillis(l));
    }

    public void setDefaultMinEvictableIdle(Duration duration) {
        this.assertInitializationAllowed();
        this.defaultMinEvictableIdleDuration = duration;
    }

    @Deprecated
    public void setDefaultMinEvictableIdleTimeMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultMinEvictableIdleDuration = Duration.ofMillis(l);
    }

    public void setDefaultMinIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMinIdle = n;
    }

    public void setDefaultNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this.defaultNumTestsPerEvictionRun = n;
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = bl;
    }

    public void setDefaultSoftMinEvictableIdle(Duration duration) {
        this.assertInitializationAllowed();
        this.defaultSoftMinEvictableIdleDuration = duration;
    }

    @Deprecated
    public void setDefaultSoftMinEvictableIdleTimeMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultSoftMinEvictableIdleDuration = Duration.ofMillis(l);
    }

    public void setDefaultTestOnBorrow(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnBorrow = bl;
    }

    public void setDefaultTestOnCreate(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnCreate = bl;
    }

    public void setDefaultTestOnReturn(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnReturn = bl;
    }

    public void setDefaultTestWhileIdle(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestWhileIdle = bl;
    }

    @Deprecated
    public void setDefaultTimeBetweenEvictionRunsMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultDurationBetweenEvictionRuns = Duration.ofMillis(l);
    }

    public void setDefaultTransactionIsolation(int n) {
        this.assertInitializationAllowed();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = n;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    void setJndiEnvironment(Properties properties) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        } else {
            this.jndiEnvironment.clear();
        }
        this.jndiEnvironment.putAll((Map<?, ?>)properties);
    }

    public void setJndiEnvironment(String string, String string2) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(string, string2);
    }

    public void setLoginTimeout(Duration duration) {
        this.loginTimeoutDuration = duration;
    }

    @Override
    @Deprecated
    public void setLoginTimeout(int n) {
        this.loginTimeoutDuration = Duration.ofSeconds(n);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setMaxConnLifetime(Duration duration) {
        this.maxConnDuration = duration;
    }

    @Deprecated
    public void setMaxConnLifetimeMillis(long l) {
        this.setMaxConnLifetime(Duration.ofMillis(l));
    }

    public void setRollbackAfterValidation(boolean bl) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = bl;
    }

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    public void setValidationQuery(String string) {
        this.assertInitializationAllowed();
        this.validationQuery = string;
    }

    public void setValidationQueryTimeout(Duration duration) {
        this.validationQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeoutDuration = Duration.ofSeconds(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPoolDataSource testCPDS(String string, String string2) throws NamingException, SQLException {
        Object object;
        ConnectionPoolDataSource connectionPoolDataSource = this.dataSource;
        if (connectionPoolDataSource == null) {
            object = null;
            object = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object object2 = object.lookup(this.dataSourceName);
            if (!(object2 instanceof ConnectionPoolDataSource)) {
                throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + object2.getClass().getName() + ") doesn't implement javax.sql.ConnectionPoolDataSource");
            }
            connectionPoolDataSource = (ConnectionPoolDataSource)object2;
        }
        object = null;
        try {
            object = string != null ? connectionPoolDataSource.getPooledConnection(string, string2) : connectionPoolDataSource.getPooledConnection();
            if (object == null) {
                throw new SQLException("Cannot connect using the supplied userName/password");
            }
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return connectionPoolDataSource;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append('[');
        this.toStringFields(stringBuilder);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected void toStringFields(StringBuilder stringBuilder) {
        stringBuilder.append("getConnectionCalled=");
        stringBuilder.append(this.getConnectionCalled);
        stringBuilder.append(", dataSource=");
        stringBuilder.append(this.dataSource);
        stringBuilder.append(", dataSourceName=");
        stringBuilder.append(this.dataSourceName);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        stringBuilder.append(", jndiEnvironment=");
        stringBuilder.append(this.jndiEnvironment);
        stringBuilder.append(", loginTimeoutDuration=");
        stringBuilder.append(this.loginTimeoutDuration);
        stringBuilder.append(", logWriter=");
        stringBuilder.append(this.logWriter);
        stringBuilder.append(", instanceKey=");
        stringBuilder.append(this.instanceKey);
        stringBuilder.append(", defaultBlockWhenExhausted=");
        stringBuilder.append(this.defaultBlockWhenExhausted);
        stringBuilder.append(", defaultEvictionPolicyClassName=");
        stringBuilder.append(this.defaultEvictionPolicyClassName);
        stringBuilder.append(", defaultLifo=");
        stringBuilder.append(this.defaultLifo);
        stringBuilder.append(", defaultMaxIdle=");
        stringBuilder.append(this.defaultMaxIdle);
        stringBuilder.append(", defaultMaxTotal=");
        stringBuilder.append(this.defaultMaxTotal);
        stringBuilder.append(", defaultMaxWaitDuration=");
        stringBuilder.append(this.defaultMaxWaitDuration);
        stringBuilder.append(", defaultMinEvictableIdleDuration=");
        stringBuilder.append(this.defaultMinEvictableIdleDuration);
        stringBuilder.append(", defaultMinIdle=");
        stringBuilder.append(this.defaultMinIdle);
        stringBuilder.append(", defaultNumTestsPerEvictionRun=");
        stringBuilder.append(this.defaultNumTestsPerEvictionRun);
        stringBuilder.append(", defaultSoftMinEvictableIdleDuration=");
        stringBuilder.append(this.defaultSoftMinEvictableIdleDuration);
        stringBuilder.append(", defaultTestOnCreate=");
        stringBuilder.append(this.defaultTestOnCreate);
        stringBuilder.append(", defaultTestOnBorrow=");
        stringBuilder.append(this.defaultTestOnBorrow);
        stringBuilder.append(", defaultTestOnReturn=");
        stringBuilder.append(this.defaultTestOnReturn);
        stringBuilder.append(", defaultTestWhileIdle=");
        stringBuilder.append(this.defaultTestWhileIdle);
        stringBuilder.append(", defaultDurationBetweenEvictionRuns=");
        stringBuilder.append(this.defaultDurationBetweenEvictionRuns);
        stringBuilder.append(", validationQuery=");
        stringBuilder.append(this.validationQuery);
        stringBuilder.append(", validationQueryTimeoutDuration=");
        stringBuilder.append(this.validationQueryTimeoutDuration);
        stringBuilder.append(", rollbackAfterValidation=");
        stringBuilder.append(this.rollbackAfterValidation);
        stringBuilder.append(", maxConnDuration=");
        stringBuilder.append(this.maxConnDuration);
        stringBuilder.append(", defaultAutoCommit=");
        stringBuilder.append(this.defaultAutoCommit);
        stringBuilder.append(", defaultTransactionIsolation=");
        stringBuilder.append(this.defaultTransactionIsolation);
        stringBuilder.append(", defaultReadOnly=");
        stringBuilder.append(this.defaultReadOnly);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw new SQLException(String.valueOf(this) + " is not a wrapper for " + String.valueOf(clazz));
    }
}

