/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.AtNumberOfNumber;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.IndexingOption;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import java.io.IOException;
import java.util.Vector;

public class PrintUnsrtTable
extends ControlSequence {
    private GlossariesSty sty;

    public PrintUnsrtTable(GlossariesSty glossariesSty) {
        this("printunsrttable", glossariesSty);
    }

    public PrintUnsrtTable(String string, GlossariesSty glossariesSty) {
        super(string);
        this.sty = glossariesSty;
    }

    @Override
    public Object clone() {
        return new PrintUnsrtTable(this.getName(), this.sty);
    }

    protected Vector<GlsLabel> getLabels(Glossary glossary, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        TeXParserListener teXParserListener = teXParser.getListener();
        Vector<GlsLabel> vector = new Vector<GlsLabel>();
        ControlSequence controlSequence = teXParserListener.getControlSequence("glstableiffilter");
        NumericRegister numericRegister = teXSettings.getNumericRegister("@glsxtr@leveloffset");
        int n = numericRegister.number(teXParser);
        for (String string : glossary) {
            GlossaryEntry glossaryEntry = this.sty.getEntry(string);
            if (glossaryEntry == null) {
                this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", string);
                continue;
            }
            int n2 = glossaryEntry.getLevel() + n;
            if (n2 > 0) continue;
            GlsLabel glsLabel = new GlsLabel("glscurrententrylabel", string, glossaryEntry);
            if (!(controlSequence instanceof AtNumberOfNumber)) {
                teXParser.putControlSequence(true, new AtFirstOfOne("glsxtr@process"));
                TeXObjectList teXObjectList2 = teXParserListener.createStack();
                teXObjectList2.add(controlSequence);
                teXObjectList2.add(glsLabel);
                teXObjectList2.add(teXParserListener.getControlSequence("printunsrtglossaryskipentry"));
                teXObjectList2.add(teXParserListener.createGroup());
                TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
                if (!(teXParser.getControlSequence("glsxtr@process") instanceof AtFirstOfOne)) continue;
            }
            vector.add(glsLabel);
        }
        TeXParserUtils.process(teXParserListener.getControlSequence("printunsrtglossarypredoglossary"), teXParser, teXObjectList);
        return vector;
    }

    protected void html(boolean bl, boolean bl2, boolean bl3, int n, int n2, boolean bl4, Glossary glossary, TeXObjectList teXObjectList, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        int n3;
        Object object;
        TeXObject teXObject;
        TeXObject teXObject2;
        TeXObjectList teXObjectList3;
        Object object2;
        TeXObject teXObject3;
        TeXObject teXObject4;
        int n4 = n * n2;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        teXParser.putControlSequence(true, new AtNumberOfNumber("glstable@parcase", 1, 3));
        String string = teXParser.expandToString(l2HConverter.getControlSequence("glstable@blockalignsep"), teXObjectList2);
        boolean bl5 = string.equals("|");
        String string2 = teXParser.expandToString(l2HConverter.getControlSequence("glstablenamecolalign"), teXObjectList2);
        String string3 = teXParser.expandToString(l2HConverter.getControlSequence("glstabledesccolalign"), teXObjectList2);
        String string4 = teXParser.expandToString(l2HConverter.getControlSequence("glstablesymbolcolalign"), teXObjectList2);
        String string5 = "glossary-name";
        if (string2.equals("c")) {
            string5 = string5 + " cell-noborder-bothsep-c";
        } else if (string2.equals("l")) {
            string5 = string5 + " cell-noborder-bothsep-l";
        } else if (string2.equals("r")) {
            string5 = string5 + " cell-noborder-bothsep-r";
        }
        String string6 = "glossary-other";
        String string7 = "glossary-desc";
        if (string3.equals("c")) {
            string7 = string7 + " cell-noborder-bothsep-c";
            string6 = string6 + " cell-noborder-bothsep-c";
        } else if (string3.equals("l")) {
            string7 = string7 + " cell-noborder-bothsep-l";
            string6 = string6 + " cell-noborder-bothsep-l";
        } else if (string3.equals("r")) {
            string7 = string7 + " cell-noborder-bothsep-r";
            string6 = string6 + " cell-noborder-bothsep-r";
        }
        String string8 = "glossary-symbol";
        if (string4.equals("c")) {
            string8 = string8 + " cell-noborder-bothsep-c";
        } else if (string4.equals("l")) {
            string8 = string8 + " cell-noborder-bothsep-l";
        } else if (string4.equals("r")) {
            string8 = string8 + " cell-noborder-bothsep-r";
        }
        Vector<GlsLabel> vector = this.getLabels(glossary, teXParser, teXObjectList2);
        StartElement startElement = new StartElement("table", true);
        if (bl2) {
            startElement.putAttribute("class", "glossary-ruled");
        } else {
            startElement.putAttribute("class", "glossary");
        }
        teXObjectList.add(startElement);
        if (bl4) {
            l2HConverter.stepcounter("table");
            teXObject4 = new StartElement("caption", true);
            teXObject3 = TeXParserUtils.expandOnce(l2HConverter.getControlSequence("@@glossaryseclabel"), teXParser, teXObjectList2);
            if (!teXObject3.isEmpty() && teXParser.isStack(teXObject3) && (object2 = (teXObjectList3 = (TeXObjectList)teXObject3).peekStack()) instanceof ControlSequence && ((ControlSequence)object2).getName().equals("label")) {
                object2 = teXObjectList3.popStack(teXParser);
                String string9 = TeXParserUtils.popLabelString(teXParser, teXObjectList3);
                if (!string9.isEmpty()) {
                    ((StartElement)teXObject4).putAttribute("id", string9);
                }
            }
            teXObjectList.add(teXObject4);
            teXObjectList.add(l2HConverter.getControlSequence("@makecaption"));
            teXObjectList3 = l2HConverter.createGroup();
            teXObjectList.add(teXObjectList3);
            teXObjectList3.add(l2HConverter.getControlSequence("tablename"));
            teXObjectList3.add(l2HConverter.getControlSequence("nobreakspace"));
            teXObjectList3.add(l2HConverter.getControlSequence("thetable"));
            teXObjectList.add(l2HConverter.getControlSequence("glossarytitle"));
            teXObjectList.add(new EndElement("caption", true));
        }
        if (!(teXObject4 = TeXParserUtils.expandOnce(l2HConverter.getControlSequence("glossarypreamble"), teXParser, teXObjectList2)).isEmpty()) {
            teXObjectList.add(new StartElement("tr"));
            startElement = new StartElement("td");
            startElement.putAttribute("colspan", "" + n4);
            startElement.putAttribute("class", "glossary-preamble");
            teXObjectList.add(startElement);
            teXObjectList.add(teXObject4);
            teXObjectList.add(new EndElement("td"));
            teXObjectList.add(new EndElement("tr"));
        }
        if (bl) {
            startElement = new StartElement("tr");
            if (bl2) {
                startElement.putAttribute("class", "glossary-ruled");
            }
            teXObjectList.add(startElement);
        }
        teXObject3 = TeXParserUtils.expandOnce(l2HConverter.getControlSequence("glstableblockheader"), teXParser, teXObjectList2);
        teXObjectList3 = l2HConverter.createStack();
        object2 = new String[n2];
        int n5 = 0;
        if (teXObject3 instanceof TeXObjectList) {
            TeXObjectList teXObjectList4 = (TeXObjectList)teXObject3;
            startElement = null;
            teXObject2 = null;
            while (!teXObjectList4.isEmpty()) {
                teXObject = teXObjectList4.popStack(teXParser);
                if (teXObject instanceof Tab) {
                    if (startElement == null) {
                        teXObjectList3.add(new StartElement("th"));
                    }
                    teXObject2 = new EndElement("th");
                    teXObjectList3.add(teXObject2);
                    startElement = null;
                    ++n5;
                    continue;
                }
                if (teXObject instanceof ControlSequence) {
                    object = ((ControlSequence)teXObject).getName();
                    if (((String)object).equals("glstableHeaderFmt")) {
                        startElement = new StartElement("th", true);
                        teXObjectList3.add(startElement);
                        teXObject2 = null;
                        continue;
                    }
                    if (startElement == null) {
                        startElement = new StartElement("th", true);
                        teXObjectList3.add(startElement);
                        teXObject2 = null;
                    }
                    if (((String)object).equals("glstablenameheader")) {
                        startElement.putAttribute("class", string5);
                        object2[n5] = string5;
                    } else if (((String)object).equals("glstabledescheader")) {
                        startElement.putAttribute("class", string7);
                        object2[n5] = string7;
                    } else if (((String)object).equals("glstablesymbolheader")) {
                        startElement.putAttribute("class", string8);
                        object2[n5] = string8;
                    } else if (((String)object).equals("glstableotherheader")) {
                        startElement.putAttribute("class", string6);
                        object2[n5] = string6;
                    }
                    teXObjectList3.add(teXObject);
                    continue;
                }
                teXObjectList3.add(teXObject);
            }
            if (startElement != null && teXObject2 == null) {
                teXObjectList3.add(new EndElement("th"));
            }
        } else {
            teXObjectList3.add(new StartElement("th"));
            teXObjectList3.add(teXObject3);
            teXObjectList3.add(new EndElement("th"));
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (n3 == 0) {
                if (!bl) continue;
                teXObjectList.addAll(teXObjectList3);
                continue;
            }
            teXObject2 = (TeXObjectList)teXObjectList3.clone();
            if (bl5 && !((Vector)((Object)teXObject2)).isEmpty() && (teXObject = (TeXObject)((Vector)((Object)teXObject2)).firstElement()) instanceof StartElement) {
                object = ((StartElement)teXObject).getAttribute("class");
                object = object == null ? "cell-left-border" : (String)object + " cell-left-border";
                ((StartElement)teXObject).putAttribute("class", (String)object);
            }
            if (!bl) continue;
            teXObjectList.addAll(teXObject2);
        }
        if (bl) {
            teXObjectList.add(new EndElement("tr", true));
        }
        TeXParserUtils.process(teXObjectList, teXParser, teXObjectList2);
        n3 = 0;
        teXObject2 = null;
        teXObject = null;
        object = l2HConverter.getControlSequence("glstableblockentry");
        TeXObjectList teXObjectList5 = l2HConverter.createStack();
        teXObjectList5 = l2HConverter.createStack();
        TeXObjectList teXObjectList6 = l2HConverter.createStack();
        teXObjectList6.add(new TeXCsRef("glscurrententrylabel"));
        teXObjectList5.add(TeXParserUtils.expandOnce((TeXObject)object, teXParser, teXObjectList6), true);
        Object object3 = vector.iterator();
        while (object3.hasNext()) {
            GlsLabel glsLabel = object3.next();
            teXParser.putControlSequence(true, glsLabel);
            if (n3 == 0) {
                teXObject2 = new StartElement("tr", true);
                teXObjectList.add(teXObject2);
                teXObject = null;
            }
            startElement = null;
            EndElement endElement = null;
            n5 = 0;
            for (TeXObject teXObject5 : teXObjectList5) {
                if (teXObject5 instanceof Tab) {
                    if (startElement != null) {
                        endElement = new EndElement("td");
                        teXObjectList.add(endElement);
                        ++n5;
                    }
                    startElement = new StartElement("td", true);
                    startElement.putAttribute("class", object2[n5]);
                    teXObjectList.add(startElement);
                    endElement = null;
                    continue;
                }
                if (startElement == null) {
                    startElement = new StartElement("td", true);
                    String string10 = object2[n5];
                    if (bl5 && n5 == 0 && n3 > 0) {
                        string10 = string10 + " cell-left-border";
                    }
                    startElement.putAttribute("class", string10);
                    teXObjectList.add(startElement);
                    endElement = null;
                }
                teXObjectList.add((TeXObject)teXObject5.clone());
            }
            if (++n3 >= n) {
                n3 = 0;
                teXObject = new EndElement("tr");
                teXObjectList.add(teXObject);
                teXObject2 = null;
            }
            TeXParserUtils.process(teXObjectList, teXParser, teXObjectList2);
        }
        if (teXObject2 != null && teXObject == null) {
            for (int i = n3; i < n; ++i) {
                startElement = new StartElement("td");
                startElement.putAttribute("colspan", "" + n2);
                if (bl5 && n3 > 0) {
                    startElement.putAttribute("class", "cell-left-border");
                }
                teXObjectList.add(startElement);
                teXObjectList.add(new EndElement("td"));
            }
            teXObjectList.add(new EndElement("tr"));
        }
        if (!(object3 = TeXParserUtils.expandOnce(l2HConverter.getControlSequence("glossarypostamble"), teXParser, teXObjectList2)).isEmpty()) {
            teXObjectList.add(new StartElement("tr"));
            startElement = new StartElement("td");
            startElement.putAttribute("colspan", "" + n4);
            startElement.putAttribute("class", "glossary-postamble");
            teXObjectList.add(startElement);
            teXObjectList.add((TeXObject)object3);
            teXObjectList.add(new EndElement("td"));
            teXObjectList.add(new EndElement("tr"));
        }
        teXObjectList.add(new EndElement("table", true));
    }

    protected void latex(boolean bl, boolean bl2, boolean bl3, int n, int n2, boolean bl4, Glossary glossary, TeXObjectList teXObjectList, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXSettings teXSettings = teXParser.getSettings();
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        Group group = laTeXParserListener.createGroup();
        TeXObject teXObject = teXParser.expandfully(laTeXParserListener.getControlSequence("glstableblockalign"), teXObjectList2);
        if (teXParser.isStack(teXObject)) {
            teXObjectList3 = (TeXObjectList)teXObject;
        } else {
            teXObjectList3 = laTeXParserListener.createStack();
            teXObjectList3.add(teXObject);
        }
        for (int i = 0; i < n; ++i) {
            group.addAll((TeXObjectList)teXObjectList3.clone());
        }
        teXObjectList.add(laTeXParserListener.getControlSequence("begin"));
        teXObjectList.add(laTeXParserListener.createGroup("longtable"));
        teXObjectList.add(group);
        teXObjectList.add(laTeXParserListener.getControlSequence("caption"));
        teXObjectList.add(laTeXParserListener.getOther(91));
        teXObjectList.add(laTeXParserListener.getControlSequence("glossarytoctitle"));
        teXObjectList.add(laTeXParserListener.getOther(93));
        teXObjectList.add(laTeXParserListener.getControlSequence("glossarytitle"));
        ControlSequence controlSequence = laTeXParserListener.getControlSequence("@@glossaryseclabel");
        teXObjectList.add(TeXParserUtils.expandOnce(controlSequence, teXParser, teXObjectList2), true);
        if (bl2) {
            teXObjectList.add(new TeXCsRef("toprule"));
        }
        teXObjectList.add(new TeXCsRef("tabularnewline"));
        teXObjectList.add(new TeXCsRef("endfirsthead"));
        teXObjectList.add(laTeXParserListener.getControlSequence("caption"));
        teXObjectList.add(laTeXParserListener.getOther(91));
        teXObjectList.add(laTeXParserListener.getOther(93));
        teXObjectList.add(laTeXParserListener.getControlSequence("glossarytoctitle"));
        if (bl2) {
            teXObjectList.add(new TeXCsRef("toprule"));
        }
        teXObjectList.add(new TeXCsRef("tabularnewline"));
        teXObjectList.add(new TeXCsRef("endhead"));
        NumericRegister numericRegister = teXSettings.getNumericRegister("glstablecurrentblockindex");
        numericRegister.setValue(teXParser, UserNumber.ONE);
        Vector<GlsLabel> vector = this.getLabels(glossary, teXParser, teXObjectList2);
        teXObjectList.add(laTeXParserListener.getControlSequence("end"));
        teXObjectList.add(laTeXParserListener.createGroup("longtable"));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        KeyValList keyValList = TeXParserUtils.popOptKeyValList(teXParser, teXObjectList);
        teXParser.startGroup();
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXSettings teXSettings = teXParser.getSettings();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        if (keyValList != null) {
            keyValList.remove("style");
        }
        Glossary glossary = this.sty.initPrintGloss(IndexingOption.UNSRT, keyValList, teXObjectList);
        Boolean bl = null;
        boolean bl2 = true;
        Boolean bl3 = null;
        boolean bl4 = true;
        Boolean bl5 = null;
        boolean bl6 = true;
        Boolean bl7 = null;
        boolean bl8 = true;
        NumericRegister numericRegister = teXSettings.getNumericRegister("glstableblockperrowcount");
        int n = numericRegister.number(teXParser);
        ControlSequence controlSequence = teXParser.getControlSequence("glstable@init");
        if (keyValList != null) {
            Object object;
            Numerical numerical = keyValList.getNumerical("blocks", teXParser, teXObjectList);
            if (numerical != null) {
                n = numerical.number(teXParser);
                numericRegister.setValue(teXParser, numerical);
            }
            bl = keyValList.getBoolean("header", teXParser, teXObjectList);
            bl3 = keyValList.getBoolean("rules", teXParser, teXObjectList);
            bl5 = keyValList.getBoolean("groups", teXParser, teXObjectList);
            bl7 = keyValList.getBoolean("caption", teXParser, teXObjectList);
            TeXObject teXObject = keyValList.getValue("blocksep");
            if (teXObject != null) {
                teXParser.putControlSequence(true, new GenericCommand(true, "glstable@blockalignsep", null, teXObject));
            }
            if ((teXObject = keyValList.getExpandedValue("par", teXParser, teXObjectList)) != null) {
                object = teXObject.toString(teXParser);
                if (((String)object).equals("false")) {
                    teXParser.putControlSequence(true, new AtNumberOfNumber("glstable@parcase", 1, 3));
                } else if (((String)object).equals("justified")) {
                    teXParser.putControlSequence(true, new AtNumberOfNumber("glstable@parcase", 2, 3));
                } else {
                    teXParser.putControlSequence(true, new AtNumberOfNumber("glstable@parcase", 3, 3));
                }
            }
            if ((teXObject = keyValList.getExpandedValue("other", teXParser, teXObjectList)) != null) {
                teXParser.putControlSequence(true, new TextualContentCommand("glstableotherfield", teXObject.toString(teXParser)));
            }
            if ((teXObject = keyValList.getExpandedValue("block-style", teXParser, teXObjectList)) != null) {
                teXObjectList2.add(teXParserListener.getControlSequence("glstablesetstyle"));
                teXObjectList2.add(TeXParserUtils.createGroup(teXParserListener, teXObject));
            }
            if ((teXObject = keyValList.getValue("init")) != null) {
                object = teXParser.isStack(teXObject) ? (TeXObjectList)teXObject : TeXParserUtils.createStack(teXParserListener, teXObject);
                controlSequence = new GenericCommand(true, "glstable@init", null, (TeXObject)object);
            }
        }
        bl8 = bl7 == null ? TeXParserUtils.isTrue("ifKV@printglosstable@caption", teXParser) : bl7;
        if (TeXParserUtils.isTrue("if@glsxtr@floats", teXParser) && bl8) {
            teXParser.putControlSequence(true, new TextualContentCommand("glscounter", "table"));
        }
        if (!TeXParserUtils.isVoid(controlSequence, teXParser)) {
            TeXParserUtils.process(controlSequence, teXParser, teXObjectList);
        }
        if (!teXObjectList2.isEmpty()) {
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        }
        if (bl == null) {
            bl2 = TeXParserUtils.isTrue("ifKV@printglosstable@header", teXParser);
        } else {
            bl2 = bl;
            if (bl2) {
                teXParser.putControlSequence(true, new IfTrue("ifKV@printglosstable@header"));
            } else {
                teXParser.putControlSequence(true, new IfFalse("ifKV@printglosstable@header"));
            }
        }
        if (bl3 == null) {
            bl4 = TeXParserUtils.isTrue("ifKV@printglosstable@rules", teXParser);
        } else {
            bl4 = bl3;
            if (bl4) {
                teXParser.putControlSequence(true, new IfTrue("ifKV@printglosstable@rules"));
            } else {
                teXParser.putControlSequence(true, new IfFalse("ifKV@printglosstable@rules"));
            }
        }
        bl6 = bl5 == null ? TeXParserUtils.isTrue("ifglsxtr@printgloss@groups", teXParser) : bl5;
        if (bl6) {
            teXParser.putControlSequence(true, new LaTeXGenericCommand(true, "glstable@groupheading", "m", TeXParserUtils.createStack(teXParserListener, teXParserListener.getControlSequence("glstablegroupheading"), TeXParserUtils.createGroup(teXParserListener, teXParserListener.getParam(1)))));
        } else {
            teXParser.putControlSequence(true, new AtGobble("glstable@groupheading"));
        }
        numericRegister = teXSettings.getNumericRegister("glstablecolsperblock");
        int n2 = numericRegister.number(teXParser);
        numericRegister = teXSettings.getNumericRegister("glstabletotalcols");
        numericRegister.setValue(teXParser, new UserNumber(n2 * n));
        if (teXParserListener instanceof L2HConverter) {
            this.html(bl2, bl4, bl6, n, n2, bl8, glossary, teXObjectList2, teXParser, teXObjectList);
        } else {
            this.latex(bl2, bl4, bl6, n, n2, bl8, glossary, teXObjectList2, teXParser, teXObjectList);
        }
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        teXParser.endGroup();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

