/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.MimeTable;
import com.sun.media.util.Registry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MimeManager {
    private static Hashtable additionalMimeTable = null;
    protected static final Hashtable defaultHashTable = new Hashtable();
    private static MimeTable mimeTable = new MimeTable();
    private static MimeTable defaultMimeTable;
    protected static final Hashtable extTable;

    private MimeManager() {
    }

    public static final boolean addMimeType(String fileExtension, String mimeType) {
        if (additionalMimeTable == null) {
            additionalMimeTable = new Hashtable();
        }
        if (mimeTable.doPut(fileExtension, mimeType)) {
            additionalMimeTable.put(fileExtension, mimeType);
            return true;
        }
        return false;
    }

    public static final boolean removeMimeType(String fileExtension) {
        if (mimeTable.doRemove(fileExtension)) {
            if (additionalMimeTable != null) {
                additionalMimeTable.remove(fileExtension);
            }
            return true;
        }
        return false;
    }

    public static final String getMimeType(String fileExtension) {
        return (String)mimeTable.get(fileExtension);
    }

    public static final Hashtable getMimeTable() {
        return mimeTable;
    }

    public static final Hashtable getDefaultMimeTable() {
        return defaultMimeTable;
    }

    public static final String getDefaultExtension(String mimeType) {
        return (String)extTable.get(mimeType);
    }

    public static void commit() {
        Registry.set("additionalMimeTable", additionalMimeTable);
        try {
            Registry.commit();
        }
        catch (IOException e) {
            System.err.println("IOException on commit " + e.getMessage());
        }
    }

    static {
        extTable = new Hashtable();
        mimeTable.doPut("mov", "video/quicktime");
        defaultHashTable.put("mov", "video/quicktime");
        mimeTable.doPut("avi", "video/x_msvideo");
        defaultHashTable.put("avi", "video/x_msvideo");
        mimeTable.doPut("mpg", "video/mpeg");
        defaultHashTable.put("mpg", "video/mpeg");
        mimeTable.doPut("mpv", "video/mpeg");
        defaultHashTable.put("mpv", "video/mpeg");
        mimeTable.doPut("viv", "video/vivo");
        defaultHashTable.put("viv", "video/vivo");
        mimeTable.doPut("au", "audio/basic");
        defaultHashTable.put("au", "audio/basic");
        mimeTable.doPut("wav", "audio/x_wav");
        defaultHashTable.put("wav", "audio/x_wav");
        mimeTable.doPut("aiff", "audio/x_aiff");
        defaultHashTable.put("aiff", "audio/x_aiff");
        mimeTable.doPut("aif", "audio/x_aiff");
        defaultHashTable.put("aif", "audio/x_aiff");
        mimeTable.doPut("mid", "audio/midi");
        defaultHashTable.put("mid", "audio/midi");
        mimeTable.doPut("midi", "audio/midi");
        defaultHashTable.put("midi", "audio/midi");
        mimeTable.doPut("rmf", "audio/rmf");
        defaultHashTable.put("rmf", "audio/rmf");
        mimeTable.doPut("gsm", "audio/x_gsm");
        defaultHashTable.put("gsm", "audio/x_gsm");
        mimeTable.doPut("mp2", "audio/mpeg");
        defaultHashTable.put("mp2", "audio/mpeg");
        mimeTable.doPut("mp3", "audio/mpeg");
        defaultHashTable.put("mp3", "audio/mpeg");
        mimeTable.doPut("mpa", "audio/mpeg");
        defaultHashTable.put("mpa", "audio/mpeg");
        mimeTable.doPut("g728", "audio/g728");
        defaultHashTable.put("g728", "audio/g728");
        mimeTable.doPut("g729", "audio/g729");
        defaultHashTable.put("g729", "audio/g729");
        mimeTable.doPut("g729a", "audio/g729a");
        defaultHashTable.put("g729a", "audio/g729a");
        mimeTable.doPut("cda", "audio/cdaudio");
        defaultHashTable.put("cda", "audio/cdaudio");
        mimeTable.doPut("mvr", "application/mvr");
        defaultHashTable.put("mvr", "application/mvr");
        mimeTable.doPut("swf", "application/x-shockwave-flash");
        defaultHashTable.put("swf", "application/x-shockwave-flash");
        mimeTable.doPut("spl", "application/futuresplash");
        defaultHashTable.put("spl", "application/futuresplash");
        mimeTable.doPut("jmx", "application/x_jmx");
        defaultHashTable.put("jmx", "application/x_jmx");
        Object t = Registry.get("additionalMimeTable");
        if (t != null && t instanceof Hashtable) {
            additionalMimeTable = (Hashtable)t;
        }
        if (additionalMimeTable != null && !additionalMimeTable.isEmpty()) {
            Enumeration e = additionalMimeTable.keys();
            while (e.hasMoreElements()) {
                String ext = (String)e.nextElement();
                if (defaultHashTable.containsKey(ext)) {
                    additionalMimeTable.remove(ext);
                    continue;
                }
                mimeTable.doPut(ext, (String)additionalMimeTable.get(ext));
            }
        }
        defaultMimeTable = (MimeTable)mimeTable.clone();
    }
}

