/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.core.shader.ShinyDiffuseShader;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class TexturedShinyDiffuseShader
extends ShinyDiffuseShader {
    private Texture tex = null;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String string = parameterList.getString("texture", null);
        if (string != null) {
            this.tex = sunflowAPI.getTextureCache().getTexture(sunflowAPI.resolveTextureFilename(string), false);
        }
        return this.tex != null && super.update(parameterList, sunflowAPI);
    }

    public Color getDiffuse(ShadingState shadingState) {
        return this.tex.getPixel(shadingState.getUV().x, shadingState.getUV().y);
    }

    public Color getRadiance(ShadingState shadingState) {
        float f;
        block3: {
            block2: {
                float f2;
                if (this.isOpaque()) break block2;
                f = this.tex.getOpacityAlpha(shadingState.getUV().x, shadingState.getUV().y);
                if (!((double)f2 > 0.99999)) break block3;
            }
            return super.getRadiance(shadingState);
        }
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Color color = shadingState.diffuse(this.getDiffuse(shadingState));
        Vector3 vector3 = shadingState.getRay().getDirection();
        Color color2 = shadingState.traceRefraction(new Ray(shadingState.getPoint(), vector3), 0);
        return color.mul(f).madd(1.0f - f, color2);
    }

    public boolean isOpaque() {
        return !this.tex.isTransparent();
    }

    public Color getOpacity(ShadingState shadingState) {
        return this.tex.getOpacity(shadingState.getUV().x, shadingState.getUV().y);
    }
}

