/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.DirectionalLightRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class DirectionalLight
extends Light {
    public static final int ALLOW_DIRECTION_READ = 18;
    public static final int ALLOW_DIRECTION_WRITE = 19;
    private static final int[] readCapabilities = new int[]{18};

    public DirectionalLight() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public DirectionalLight(Color3f color3f, Vector3f vector3f) {
        super(color3f);
        this.setDefaultReadCapabilities(readCapabilities);
        ((DirectionalLightRetained)this.retained).initDirection(vector3f);
    }

    public DirectionalLight(boolean bl, Color3f color3f, Vector3f vector3f) {
        super(bl, color3f);
        this.setDefaultReadCapabilities(readCapabilities);
        ((DirectionalLightRetained)this.retained).initDirection(vector3f);
    }

    @Override
    void createRetained() {
        this.retained = new DirectionalLightRetained();
        this.retained.setSource(this);
    }

    public void setDirection(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight0"));
        }
        if (this.isLive()) {
            ((DirectionalLightRetained)this.retained).setDirection(vector3f);
        } else {
            ((DirectionalLightRetained)this.retained).initDirection(vector3f);
        }
    }

    public void setDirection(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight1"));
        }
        if (this.isLive()) {
            ((DirectionalLightRetained)this.retained).setDirection(f, f2, f3);
        } else {
            ((DirectionalLightRetained)this.retained).initDirection(f, f2, f3);
        }
    }

    public void getDirection(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight2"));
        }
        ((DirectionalLightRetained)this.retained).getDirection(vector3f);
    }

    @Override
    public Node cloneNode(boolean bl) {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.duplicateNode(this, bl);
        return directionalLight;
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        Vector3f vector3f = new Vector3f();
        ((DirectionalLightRetained)node.retained).getDirection(vector3f);
        ((DirectionalLightRetained)this.retained).initDirection(vector3f);
    }
}

