# - Config file for the rpp package
# It defines the following variables
#  use rpp_INCLUDE_DIR   - include directory for rpp
#  use rpp_LIB_DIR       - library directory for rpp
#  use rpp_LIBRARY       - library to link against
#  use rpp_LIBRARIES     - library to link against

# compute paths
get_filename_component(rpp_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rpp-config-version.cmake)
set(rpp_VERSION ${PACKAGE_VERSION})

# targets
include(${CMAKE_CURRENT_LIST_DIR}/rpp-targets.cmake)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rpp-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(LIB_TYPE so)
if(APPLE)
  set(LIB_TYPE dylib)
endif()

set_and_check(rpp_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rpp_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(rpp_LIBRARY "${PACKAGE_PREFIX_DIR}/lib/librpp.${LIB_TYPE}")
set_and_check(rpp_LIBRARIES "${PACKAGE_PREFIX_DIR}/lib/librpp.${LIB_TYPE}")

if(NOT TARGET rpp::rpp)
  add_library(rpp::rpp INTERFACE IMPORTED)
  set_target_properties(rpp::rpp PROPERTIES INTERFACE_LINK_LIBRARIES ${rpp_LIBRARY})
endif ()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rpp
    FOUND_VAR rpp_FOUND
    REQUIRED_VARS rpp_INCLUDE_DIR rpp_LIB_DIR rpp_LIBRARY rpp_LIBRARIES
    VERSION_VAR rpp_VERSION
    HANDLE_COMPONENTS)

