'''OpenGL extension NV.framebuffer_mixed_samples

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.framebuffer_mixed_samples to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows multisample rendering with a raster and
	depth/stencil sample count that is larger than the color sample count.
	Rasterization and the results of the depth and stencil tests together
	determine the portion of a pixel that is "covered".  It can be useful to
	evaluate coverage at a higher frequency than color samples are stored.
	This coverage is then "reduced" to a collection of covered color samples,
	each having an opacity value corresponding to the fraction of the color
	sample covered.  The opacity can optionally be blended into individual
	color samples.
	
	In the current hardware incarnation both depth and stencil testing are
	supported with mixed samples, although the API accommodates supporting
	only one or the other.
	
	Rendering with fewer color samples than depth/stencil samples can greatly
	reduce the amount of memory and bandwidth consumed by the color buffer.
	However, converting the coverage values into opacity can introduce
	artifacts where triangles share edges and may not be suitable for normal
	triangle mesh rendering.
	
	One expected use case for this functionality is Stencil-then-Cover path
	rendering (NV_path_rendering).  The stencil step determines the coverage
	(in the stencil buffer) for an entire path at the higher sample frequency,
	and then the cover step can draw the path into the lower frequency color
	buffer using the coverage information to antialias path edges. With this
	two-step process, internal edges are fully covered when antialiasing is
	applied and there is no corruption on these edges.
	
	The key features of this extension are:
	
	- It allows a framebuffer object to be considered complete when its depth
	  or stencil samples are a multiple of the number of color samples.
	
	- It redefines SAMPLES to be the number of depth/stencil samples (if any);
	  otherwise, it uses the number of color samples. SAMPLE_BUFFERS is one if
	  there are multisample depth/stencil attachments.  Multisample
	  rasterization and multisample fragment ops are allowed if SAMPLE_BUFFERS
	  is one.
	
	- It replaces several error checks involving SAMPLE_BUFFERS by error
	  checks directly referencing the number of samples in the relevant
	  attachments.
	
	- A coverage reduction step is added to Per-Fragment Operations which
	  converts a set of covered raster/depth/stencil samples to a set of
	  covered color samples.  The coverage reduction step also includes an
	  optional coverage modulation step, multiplying color values by a
	  fractional opacity corresponding to the number of associated
	  raster/depth/stencil samples covered.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/framebuffer_mixed_samples.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.framebuffer_mixed_samples import *
from OpenGL.raw.GLES2.NV.framebuffer_mixed_samples import _EXTENSION_NAME

def glInitFramebufferMixedSamplesNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glCoverageModulationTableNV.v size not checked against n
glCoverageModulationTableNV=wrapper.wrapper(glCoverageModulationTableNV).setInputArraySize(
    'v', None
)
### END AUTOGENERATED SECTION