/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEditorKitOntologyShortFormProvider;
import org.protege.editor.owl.model.OWLEditorKitShortFormProvider;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchResult;
import org.protege.editor.owl.model.search.SearchResultMatch;
import org.protege.editor.owl.model.search.SearchResultSet;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.context.OWLObjectRenderingContext;
import org.protege.editor.owl.ui.renderer.styledstring.FontWeightAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.ForegroundAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.OWLObjectStyledStringRenderer;
import org.protege.editor.owl.ui.renderer.styledstring.ProtegeStyles;
import org.protege.editor.owl.ui.renderer.styledstring.StrikeThroughAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.Style;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.protege.editor.owl.ui.renderer.styledstring.StyledStringPanel;
import org.protege.editor.owl.ui.search.SearchResultClickedListener;
import org.protege.editor.owl.ui.search.SearchResultsTableModel;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class SearchResultsPanel
extends JPanel {
    public static final int HEADER_SPACING = 10;
    public static final int CATEGORY_COLUMN_PREFERRED_WIDTH = 60;
    public static final int ENTITY_COLUMN_PREFERRED_WIDTH = 200;
    private OWLEditorKit editorKit;
    private JTable resultsTable;
    private SearchResultSet searchResultSet;
    private final JScrollPane scrollPane;
    private SearchResultsTableModel model;
    private SearchResultClickedListener searchResultClickedListener = (searchResult, e) -> {};

    public SearchResultsPanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.model = new SearchResultsTableModel(editorKit);
        this.setLayout(new BorderLayout());
        this.resultsTable = new JTable(this.model);
        this.resultsTable.setIntercellSpacing(new Dimension(0, 0));
        this.scrollPane = ComponentFactory.createScrollPane((JComponent)this.resultsTable);
        this.resultsTable.setBorder(null);
        this.resultsTable.setRowMargin(0);
        this.add(this.scrollPane);
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SearchResultsPanel.this.handleMouseReleased(e);
            }
        });
        this.scrollPane.getViewport().addChangeListener(e -> this.handleScrollpaneViewportChanged());
    }

    public void setSearchResultClickedListener(SearchResultClickedListener l) {
        this.searchResultClickedListener = (SearchResultClickedListener)Preconditions.checkNotNull((Object)l);
    }

    private void setupColumnRenderers() {
        TableColumnModel columnModel = this.resultsTable.getColumnModel();
        TableColumn categoryColumn = columnModel.getColumn(0);
        categoryColumn.setCellRenderer(new ResultsTableCellRendererWrapper(new CategoryRenderer()));
        categoryColumn.setPreferredWidth(60);
        TableColumn entityColumn = columnModel.getColumn(1);
        entityColumn.setCellRenderer(new ResultsTableCellRendererWrapper(new EntityRenderer()));
        entityColumn.setPreferredWidth(200);
        int oboIdColumn = this.model.getOboIdColumn();
        if (oboIdColumn != -1) {
            columnModel.getColumn(oboIdColumn).setCellRenderer(new ResultsTableCellRendererWrapper(new DefaultTableCellRenderer()));
        }
        int resultColumn = this.model.getResultsColumn();
        columnModel.getColumn(resultColumn).setCellRenderer(new ResultsTableCellRendererWrapper(new EntityFinderResultsRenderer(this.editorKit)));
    }

    private void handleScrollpaneViewportChanged() {
        Rectangle tableVisibleRect = this.resultsTable.getVisibleRect();
        TableColumn categoryColumn = this.resultsTable.getColumnModel().getColumn(0);
        int columnWidth = categoryColumn.getWidth();
        int rowHeight = this.resultsTable.getRowHeight() * 2;
        this.scrollPane.repaint(new Rectangle(tableVisibleRect.x, tableVisibleRect.y, columnWidth, rowHeight));
    }

    private void handleMouseReleased(MouseEvent e) {
        Optional<SearchResult> selectedSearchResult;
        if (e.getClickCount() == 2 && (selectedSearchResult = this.getSelectedSearchResult()).isPresent()) {
            this.searchResultClickedListener.handleSearchResultClicked((SearchResult)selectedSearchResult.get(), e);
        }
    }

    public void setSearchResults(SearchResultSet searchResultSet, int categorySizeLimit) {
        this.searchResultSet = searchResultSet;
        this.setData(searchResultSet.getSearchResults());
    }

    public void clearSearchResults() {
        this.clearData();
    }

    public void setCategorySizeLimit(int sizeLimit) {
        this.model.setCategorySizeLimit(sizeLimit);
        this.refill();
    }

    public void clearCategorySizeLimit() {
        this.model.clearCategorySizeLimit();
        this.refill();
    }

    public Optional<SearchResult> getSelectedSearchResult() {
        int selRow = this.resultsTable.getSelectedRow();
        if (selRow == -1) {
            return Optional.absent();
        }
        return Optional.of((Object)this.model.getSearchResult(selRow));
    }

    public void refill() {
        if (this.searchResultSet != null) {
            this.setData(this.searchResultSet.getSearchResults());
        }
    }

    public Optional<OWLEntity> getEntityAtRow(int selRow) {
        Object object = this.model.getValueAt(selRow, 1);
        if (object instanceof OWLEntity) {
            return Optional.of((Object)((OWLEntity)object));
        }
        return Optional.absent();
    }

    public Optional<OWLEntity> getSelectedEntity() {
        int selRow = this.resultsTable.getSelectedRow();
        if (selRow == -1) {
            return Optional.absent();
        }
        return this.getEntityAtRow(selRow);
    }

    public List<OWLEntity> getSelectedEntities() {
        ArrayList<OWLEntity> results = new ArrayList<OWLEntity>();
        for (int selIndex : this.resultsTable.getSelectedRows()) {
            Optional<OWLEntity> entity = this.getEntityAtRow(selIndex);
            if (!entity.isPresent()) continue;
            results.add((OWLEntity)entity.get());
        }
        return results;
    }

    public void moveSelectionDown() {
        int size = this.model.getRowCount();
        if (size == 0) {
            return;
        }
        int selectedIndex = this.resultsTable.getSelectionModel().getLeadSelectionIndex();
        int nextSelIndex = selectedIndex + 1;
        if (nextSelIndex == size) {
            nextSelIndex = 0;
        }
        this.resultsTable.getSelectionModel().setSelectionInterval(nextSelIndex, nextSelIndex);
        this.resultsTable.scrollRectToVisible(this.resultsTable.getCellRect(nextSelIndex, 0, true));
    }

    public void moveSelectionUp() {
        int size = this.model.getRowCount();
        if (size == 0) {
            return;
        }
        int selectedIndex = this.resultsTable.getSelectionModel().getLeadSelectionIndex();
        int nextSelIndex = selectedIndex - 1;
        if (nextSelIndex < 0) {
            nextSelIndex = size - 1;
        }
        this.resultsTable.getSelectionModel().setSelectionInterval(nextSelIndex, nextSelIndex);
        this.resultsTable.scrollRectToVisible(this.resultsTable.getCellRect(nextSelIndex, 0, true));
    }

    private void setData(Collection<SearchResult> results) {
        this.model.setResultList(results);
        this.setupColumnRenderers();
        Font font = OWLRendererPreferences.getInstance().getFont();
        this.resultsTable.setFont(font);
        this.resultsTable.setAutoResizeMode(3);
        int rowHeight = font.getSize() + 4;
        this.resultsTable.setRowHeight(rowHeight);
        for (int i = 1; i < this.model.getRowCount(); ++i) {
            if (!this.isHeaderRow(i)) continue;
            this.resultsTable.setRowHeight(i, rowHeight + 10);
        }
        if (this.resultsTable.getModel().getRowCount() > 0) {
            this.resultsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void clearData() {
        this.model.clear();
    }

    private boolean isHeaderRow(int rowIndex) {
        return this.resultsTable.getModel().getRowCount() != 0 && this.model.isFirstRowInCategory(rowIndex);
    }

    private class ResultsTableCellRendererWrapper
    implements TableCellRenderer {
        private TableCellRenderer delegate;

        private ResultsTableCellRendererWrapper(TableCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (SearchResultsPanel.this.isHeaderRow(row) && row != 0) {
                Border border = c.getBorder();
                MatteBorder headerBorder = BorderFactory.createMatteBorder(10, 0, 0, 0, table.getBackground());
                if (border == null) {
                    c.setBorder(headerBorder);
                } else {
                    c.setBorder(BorderFactory.createCompoundBorder(headerBorder, border));
                }
            }
            return c;
        }
    }

    private class CategoryRenderer
    extends DefaultTableCellRenderer {
        private CategoryRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String toRender = "";
            if (SearchResultsPanel.this.model.isFirstRowInCategory(row)) {
                toRender = value.toString();
            } else {
                Rectangle previousCellRect = table.getCellRect(row - 1, column, true);
                if (!table.getVisibleRect().intersects(previousCellRect)) {
                    toRender = value.toString();
                }
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, toRender, isSelected, hasFocus, row, column);
            label.setHorizontalTextPosition(4);
            label.setHorizontalAlignment(4);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            if (!isSelected) {
                label.setForeground(Color.GRAY);
            }
            return label;
        }
    }

    private class EntityRenderer
    extends DefaultTableCellRenderer {
        private StyledStringPanel styledStringPanel = new StyledStringPanel();

        private EntityRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof OWLObject) {
                OWLObject owlObject = (OWLObject)value;
                OWLObjectRenderingContext renderingContext = new OWLObjectRenderingContext(new OWLEditorKitShortFormProvider(SearchResultsPanel.this.editorKit), new OWLEditorKitOntologyShortFormProvider(SearchResultsPanel.this.editorKit));
                OWLObjectStyledStringRenderer renderer = new OWLObjectStyledStringRenderer(renderingContext);
                StyledString styledString = renderer.getRendering(owlObject);
                StyledString.Builder builder = styledString.builder();
                SearchResult searchResult = SearchResultsPanel.this.model.getSearchResult(row);
                if (searchResult.getCategory() == SearchCategory.DISPLAY_NAME) {
                    for (SearchResultMatch match : searchResult.getMatches()) {
                        int start = match.getStart();
                        int end = match.getEnd();
                        builder.applyStyleAttributes(start, end, FontWeightAttribute.getBoldFontWeight());
                    }
                }
                if (SearchResultsPanel.this.editorKit.getOWLModelManager().isDeprecated(owlObject)) {
                    builder.applyStyleAttributes(StrikeThroughAttribute.getSingle());
                }
                if (isSelected) {
                    this.styledStringPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 10, table.getSelectionBackground()));
                    this.styledStringPanel.setForeground(table.getSelectionForeground());
                    this.styledStringPanel.setBackground(table.getSelectionBackground());
                    builder.applyStyleAttributes(ForegroundAttribute.get(table.getSelectionForeground()));
                } else {
                    this.styledStringPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 10, table.getBackground()));
                    this.styledStringPanel.setForeground(null);
                    this.styledStringPanel.setBackground(null);
                }
                this.styledStringPanel.setStyledString(builder.build());
                this.styledStringPanel.setFont(OWLRendererPreferences.getInstance().getFont());
                this.styledStringPanel.setIcon(SearchResultsPanel.this.editorKit.getOWLWorkspace().getOWLIconProvider().getIcon(owlObject));
                return this.styledStringPanel;
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            if (!isSelected) {
                label.setForeground(Color.LIGHT_GRAY);
            }
            return label;
        }
    }

    private class EntityFinderResultsRenderer
    implements TableCellRenderer {
        private DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        private StyledStringPanel styledStringPanel = new StyledStringPanel();

        private EntityFinderResultsRenderer(OWLEditorKit editorKit) {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String && SearchResultsPanel.this.model.getSearchResult(row) != null) {
                SearchResult searchResult = SearchResultsPanel.this.model.getSearchResult(row);
                StyledString styledStringRep = searchResult.getStyledSearchSearchString();
                StyledString.Builder builder = styledStringRep.builder();
                this.styledStringPanel.setBorder(BorderFactory.createEmptyBorder());
                this.styledStringPanel.setFont(OWLRendererPreferences.getInstance().getFont());
                if (isSelected) {
                    this.styledStringPanel.setBackground(table.getSelectionBackground());
                    this.styledStringPanel.setForeground(table.getSelectionForeground());
                    builder.applyStyleAttributes(ForegroundAttribute.get(table.getSelectionForeground()));
                } else {
                    this.styledStringPanel.setBackground(table.getBackground());
                    this.styledStringPanel.setForeground(table.getForeground());
                }
                Style highlightStyle = ProtegeStyles.getHighlightStyle();
                for (SearchResultMatch match : searchResult.getMatches()) {
                    int from = match.getStart();
                    int to = match.getEnd();
                    builder.applyStyle(from, to, highlightStyle);
                }
                this.styledStringPanel.setStyledString(builder.build());
                return this.styledStringPanel;
            }
            return this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

