# AsyncOverheadBenchmark
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-90)</span>

Default benchmark for measuring asynchronous overhead.


```pony
class iso AsyncOverheadBenchmark is
  AsyncMicroBenchmark iso
```

#### Implements

* [AsyncMicroBenchmark](pony_bench-AsyncMicroBenchmark.md) iso

---

## Constructors

### create
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-90)</span>


```pony
new iso create()
: AsyncOverheadBenchmark iso^
```

#### Returns

* [AsyncOverheadBenchmark](pony_bench-AsyncOverheadBenchmark.md) iso^

---

## Public Functions

### name
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-94)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### apply
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-97)</span>


```pony
fun ref apply(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](pony_bench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### config
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-41)</span>


```pony
fun box config()
: BenchConfig val
```

#### Returns

* [BenchConfig](pony_bench-BenchConfig.md) val

---

### overhead
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-42)</span>


```pony
fun box overhead()
: AsyncMicroBenchmark iso^
```

#### Returns

* [AsyncMicroBenchmark](pony_bench-AsyncMicroBenchmark.md) iso^

---

### before
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-43)</span>


```pony
fun ref before(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](pony_bench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### before_iteration
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-44)</span>


```pony
fun ref before_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](pony_bench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### after
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-46)</span>


```pony
fun ref after(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](pony_bench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### after_iteration
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-47)</span>


```pony
fun ref after_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](pony_bench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

