/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java.com.lowagie.text.pdf;

import com.gitlab.pdftk_java.com.lowagie.text.ExceptionConverter;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.BaseFont;

class PdfFont
implements Comparable {
    private BaseFont font;
    private float size;
    protected float hScale = 1.0f;

    PdfFont(BaseFont bf, float size) {
        this.size = size;
        this.font = bf;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            PdfFont pdfFont = (PdfFont)object;
            if (this.font != pdfFont.font) {
                return 1;
            }
            if (this.size() != pdfFont.size()) {
                return 2;
            }
            return 0;
        }
        catch (ClassCastException cce) {
            return -2;
        }
    }

    float size() {
        return this.size;
    }

    float width() {
        return this.width(' ');
    }

    float width(char character) {
        return this.font.getWidthPoint(character, this.size) * this.hScale;
    }

    float width(String s) {
        return this.font.getWidthPoint(s, this.size) * this.hScale;
    }

    BaseFont getFont() {
        return this.font;
    }

    static PdfFont getDefaultFont() {
        try {
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            return new PdfFont(bf, 12.0f);
        }
        catch (Exception ee) {
            throw new ExceptionConverter(ee);
        }
    }

    void setHorizontalScaling(float hScale) {
        this.hScale = hScale;
    }
}

