/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlLambdaScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.UnmodifiableArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlLambda
extends SqlCall {
    public static final SqlOperator OPERATOR = new SqlLambdaOperator();
    SqlNodeList parameters;
    SqlNode expression;

    public SqlLambda(SqlParserPos pos, SqlNodeList parameters, SqlNode expression) {
        super(pos);
        this.parameters = parameters;
        this.expression = expression;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LAMBDA;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return UnmodifiableArrayList.of(new SqlNode[]{this.parameters, this.expression});
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.parameters = Objects.requireNonNull((SqlNodeList)operand, "parameters");
                break;
            }
            case 1: {
                this.expression = Objects.requireNonNull(operand, "operand");
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.parameters.size() != 1) {
            writer.list(SqlWriter.FrameTypeEnum.PARENTHESES, SqlWriter.COMMA, SqlPivot.stripList(this.parameters));
        } else {
            this.parameters.unparse(writer, leftPrec, rightPrec);
        }
        writer.keyword(OPERATOR.getName());
        this.expression.unparse(writer, leftPrec, rightPrec);
    }

    public SqlNodeList getParameters() {
        return this.parameters;
    }

    public SqlNode getExpression() {
        return this.expression;
    }

    private static class SqlLambdaOperator
    extends SqlSpecialOperator {
        SqlLambdaOperator() {
            super("->", SqlKind.LAMBDA);
        }

        @Override
        public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
            SqlLambda lambdaExpr = (SqlLambda)call;
            SqlLambdaScope lambdaScope = (SqlLambdaScope)scope;
            List paramNames = (List)lambdaExpr.getParameters().stream().map(SqlNode::toString).collect(ImmutableList.toImmutableList());
            List paramTypes = (List)lambdaScope.getParameterTypes().values().stream().collect(ImmutableList.toImmutableList());
            RelDataType paramRowType = validator.getTypeFactory().createStructType(paramTypes, paramNames);
            RelDataType returnType = validator.getValidatedNodeType(lambdaExpr.getExpression());
            return validator.getTypeFactory().createFunctionSqlType(paramRowType, returnType);
        }
    }
}

