/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.http;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.httpclient.HttpClientRequestContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.httpclient.HttpClientResponseMessageDecoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.httpclient.HttpClientRequestMessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipeline;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.opensaml.security.messaging.HttpClientSecurityContext;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.SOAPFaultException;
import org.opensaml.soap.common.SOAP11FaultDecodingException;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractPipelineHttpSOAPClient
extends AbstractInitializableComponent
implements SOAPClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractPipelineHttpSOAPClient.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @Nullable
    private Function<InOutOperationContext, CriteriaSet> tlsCriteriaSetStrategy;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
    }

    @NonnullAfterInit
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = Constraint.isNotNull(client, "HttpClient cannot be null");
    }

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @Nullable
    public Function<InOutOperationContext, CriteriaSet> getTLSCriteriaSetStrategy() {
        return this.tlsCriteriaSetStrategy;
    }

    public void setTLSCriteriaSetStrategy(@Nullable Function<InOutOperationContext, CriteriaSet> function) {
        this.checkSetterPreconditions();
        this.tlsCriteriaSetStrategy = function;
    }

    @Override
    public void send(@Nonnull @NotEmpty String endpoint, @Nonnull InOutOperationContext operationContext) throws SOAPException, SecurityException {
        Constraint.isNotNull(endpoint, "Endpoint cannot be null");
        Constraint.isNotNull(operationContext, "Operation context cannot be null");
        HttpClientMessagePipeline pipeline = null;
        try {
            operationContext.ensureSubcontext(SOAPClientContext.class).setDestinationURI(endpoint);
            pipeline = this.resolvePipeline(operationContext);
            MessageHandler handler = pipeline.getOutboundPayloadMessageHandler();
            if (handler != null) {
                handler.invoke(operationContext.ensureOutboundMessageContext());
            }
            ClassicHttpRequest httpRequest = this.buildHttpRequest(endpoint, operationContext);
            HttpClientRequestMessageEncoder encoder = pipeline.getEncoder();
            encoder.setHttpRequest(httpRequest);
            encoder.setMessageContext(operationContext.getOutboundMessageContext());
            encoder.initialize();
            encoder.prepareContext();
            handler = pipeline.getOutboundTransportMessageHandler();
            if (handler != null) {
                handler.invoke(operationContext.ensureOutboundMessageContext());
            }
            encoder.encode();
            HttpClientContext httpContext = this.buildHttpContext(httpRequest, operationContext);
            try (ClassicHttpResponse httpResponse = this.getHttpClient().executeOpen(null, httpRequest, (HttpContext)httpContext);){
                HttpClientSecuritySupport.checkTLSCredentialEvaluated(httpContext, httpRequest.getScheme());
                HttpClientResponseMessageDecoder decoder = pipeline.getDecoder();
                decoder.setHttpResponse(httpResponse);
                decoder.initialize();
                decoder.decode();
                operationContext.setInboundMessageContext(decoder.getMessageContext());
            }
            handler = pipeline.getInboundMessageHandler();
            if (handler != null) {
                handler.invoke(operationContext.ensureInboundMessageContext());
            }
        }
        catch (SOAP11FaultDecodingException e) {
            SOAPFaultException faultException = new SOAPFaultException(e.getMessage(), e);
            faultException.setFault(e.getFault());
            throw faultException;
        }
        catch (SSLException e) {
            throw new SecurityException("Problem establising TLS connection to: " + endpoint, e);
        }
        catch (ComponentInitializationException e) {
            throw new SOAPException("Problem initializing a SOAP client component", e);
        }
        catch (MessageEncodingException e) {
            throw new SOAPException("Problem encoding SOAP request message to: " + endpoint, e);
        }
        catch (MessageDecodingException e) {
            throw new SOAPException("Problem decoding SOAP response message from: " + endpoint, e);
        }
        catch (MessageHandlerException e) {
            throw new SOAPException("Problem handling SOAP message exchange with: " + endpoint, e);
        }
        catch (ClientProtocolException e) {
            throw new SOAPException("Client protocol problem sending SOAP request message to: " + endpoint, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SOAPException("I/O problem with SOAP message exchange with: " + endpoint, e);
        }
        finally {
            if (pipeline != null) {
                pipeline.getEncoder().destroy();
                pipeline.getDecoder().destroy();
            }
        }
    }

    @Nonnull
    protected HttpClientMessagePipeline resolvePipeline(@Nonnull InOutOperationContext operationContext) throws SOAPException {
        try {
            return this.newPipeline();
        }
        catch (SOAPException e) {
            this.log.warn("Problem resolving pipeline instance: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.log.warn("Problem resolving pipeline instance: {}", (Object)e.getMessage());
            throw new SOAPException("Could not resolve pipeline", e);
        }
    }

    @Nonnull
    protected abstract HttpClientMessagePipeline newPipeline() throws SOAPException;

    @Nonnull
    protected ClassicHttpRequest buildHttpRequest(@Nonnull @NotEmpty String endpoint, @Nonnull InOutOperationContext operationContext) {
        return new HttpPost(endpoint);
    }

    @Nonnull
    protected HttpClientContext buildHttpContext(@Nonnull ClassicHttpRequest request, @Nonnull InOutOperationContext operationContext) {
        HttpClientContext clientContext = this.resolveClientContext(operationContext);
        HttpClientSecurityParameters contextSecurityParameters = this.resolveContextSecurityParameters(operationContext);
        HttpClientSecuritySupport.marshalSecurityParameters(clientContext, contextSecurityParameters, false);
        HttpClientSecuritySupport.marshalSecurityParameters(clientContext, this.getHttpClientSecurityParameters(), false);
        if ("https".equalsIgnoreCase(request.getScheme()) && clientContext.getAttribute("opensaml.TrustEngine") != null) {
            if (clientContext.getAttribute("opensaml.CriteriaSet") == null) {
                clientContext.setAttribute("opensaml.CriteriaSet", (Object)this.buildTLSCriteriaSet(request, operationContext));
            }
            if (clientContext.getAttribute("opensaml.ServerTLSFailureIsFatal") == null) {
                clientContext.setAttribute("opensaml.ServerTLSFailureIsFatal", (Object)Boolean.FALSE);
            }
        }
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria(clientContext, (HttpRequest)request);
        return clientContext;
    }

    @Nullable
    protected HttpClientSecurityParameters resolveContextSecurityParameters(@Nonnull InOutOperationContext operationContext) {
        HttpClientSecurityContext securityContext = operationContext.ensureOutboundMessageContext().getSubcontext(HttpClientSecurityContext.class);
        if (securityContext != null) {
            return securityContext.getSecurityParameters();
        }
        return null;
    }

    @Nonnull
    protected HttpClientContext resolveClientContext(@Nonnull InOutOperationContext operationContext) {
        HttpClientRequestContext requestContext = operationContext.ensureOutboundMessageContext().ensureSubcontext(HttpClientRequestContext.class);
        HttpClientContext clientCtx = requestContext.getHttpClientContext();
        if (clientCtx == null) {
            clientCtx = HttpClientContext.create();
            requestContext.setHttpClientContext(clientCtx);
        }
        assert (clientCtx != null);
        return clientCtx;
    }

    @Nonnull
    protected CriteriaSet buildTLSCriteriaSet(@Nonnull ClassicHttpRequest request, @Nonnull InOutOperationContext operationContext) {
        CriteriaSet resolved;
        CriteriaSet criteriaSet = new CriteriaSet();
        Function<InOutOperationContext, CriteriaSet> strategy = this.getTLSCriteriaSetStrategy();
        if (strategy != null && (resolved = strategy.apply(operationContext)) != null) {
            criteriaSet.addAll(resolved);
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add(new UsageCriterion(UsageType.SIGNING));
        }
        return criteriaSet;
    }
}

