/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DecryptItemInput {
    private final Map<String, AttributeValue> encryptedItem;

    protected DecryptItemInput(BuilderImpl builder) {
        this.encryptedItem = builder.encryptedItem();
    }

    public Map<String, AttributeValue> encryptedItem() {
        return this.encryptedItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, AttributeValue> encryptedItem;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptItemInput model) {
            this.encryptedItem = model.encryptedItem();
        }

        @Override
        public Builder encryptedItem(Map<String, AttributeValue> encryptedItem) {
            this.encryptedItem = encryptedItem;
            return this;
        }

        @Override
        public Map<String, AttributeValue> encryptedItem() {
            return this.encryptedItem;
        }

        @Override
        public DecryptItemInput build() {
            if (Objects.isNull(this.encryptedItem())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedItem`");
            }
            return new DecryptItemInput(this);
        }
    }

    public static interface Builder {
        public Builder encryptedItem(Map<String, AttributeValue> var1);

        public Map<String, AttributeValue> encryptedItem();

        public DecryptItemInput build();
    }
}

