/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.profile;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.IOSupplier;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.QueryProfiler;

public class KNNProfileUtil {
    public static QueryProfiler getProfiler(IndexSearcher searcher) {
        ContextIndexSearcher contextIndexSearcher;
        if (searcher instanceof ContextIndexSearcher && (contextIndexSearcher = (ContextIndexSearcher)searcher).getProfiler() != null) {
            return contextIndexSearcher.getProfiler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object profileBreakdown(ContextualProfileBreakdown profile, LeafReaderContext leafReaderContext, Enum<?> timingType, IOSupplier<?> action) throws IOException {
        if (profile != null) {
            Timer timer = profile.context((Object)leafReaderContext).getTimer(timingType);
            timer.start();
            try {
                Object object = action.get();
                return object;
            }
            finally {
                timer.stop();
            }
        }
        return action.get();
    }

    public static Object profile(QueryProfiler profiler, Query query, LeafReaderContext leafReaderContext, Enum<?> timingType, IOSupplier<?> action) throws IOException {
        if (profiler != null) {
            ContextualProfileBreakdown profile = (ContextualProfileBreakdown)profiler.getProfileBreakdown(query);
            return KNNProfileUtil.profileBreakdown(profile, leafReaderContext, timingType, action);
        }
        return action.get();
    }
}

