/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelState;

public class Model
implements Writeable,
ToXContentObject {
    private String modelID;
    private ModelMetadata modelMetadata;
    private AtomicReference<byte[]> modelBlob;

    public Model(ModelMetadata modelMetadata, @Nullable byte[] modelBlob, String modelID) {
        this.modelMetadata = Objects.requireNonNull(modelMetadata, "modelMetadata must not be null");
        if (ModelState.CREATED.equals((Object)this.modelMetadata.getState()) && modelBlob == null) {
            throw new IllegalArgumentException("Cannot construct model in state CREATED when model binary is null. State must be either TRAINING or FAILED");
        }
        this.modelBlob = new AtomicReference<byte[]>(modelBlob);
        this.modelID = Objects.requireNonNull(modelID, "model id must not be null");
    }

    private byte[] readOptionalModelBlob(StreamInput in) throws IOException {
        return in.readBoolean() ? in.readByteArray() : null;
    }

    public Model(StreamInput in) throws IOException {
        this.modelMetadata = new ModelMetadata(in);
        this.modelBlob = new AtomicReference<byte[]>(this.readOptionalModelBlob(in));
        this.modelID = in.readString();
    }

    public ModelMetadata getModelMetadata() {
        return this.modelMetadata;
    }

    public String getModelID() {
        return this.modelID;
    }

    public byte[] getModelBlob() {
        return this.modelBlob.get();
    }

    public int getLength() {
        if (this.getModelBlob() == null) {
            return 0;
        }
        return this.getModelBlob().length;
    }

    public synchronized void setModelBlob(byte[] modelBlob) {
        this.modelBlob = new AtomicReference<byte[]>(Objects.requireNonNull(modelBlob, "model blob cannot be updated to null"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        return other.getModelID().equals(this.getModelID());
    }

    public int hashCode() {
        return this.getModelID().hashCode();
    }

    public static Model getModelFromSourceMap(Map<String, Object> sourceMap) {
        String modelID = Model.getModelIDFromResponse(sourceMap);
        ModelMetadata modelMetadata = ModelMetadata.getMetadataFromSourceMap(sourceMap);
        byte[] blob = Model.getModelBlobFromResponse(sourceMap);
        return new Model(modelMetadata, blob, modelID);
    }

    private void writeOptionalModelBlob(StreamOutput output) throws IOException {
        if (this.getModelBlob() == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        output.writeByteArray(this.getModelBlob());
    }

    public void writeTo(StreamOutput output) throws IOException {
        this.getModelMetadata().writeTo(output);
        this.writeOptionalModelBlob(output);
        output.writeString(this.modelID);
    }

    private static String getModelIDFromResponse(Map<String, Object> responseMap) {
        Object modelId = responseMap.get("model_id");
        if (modelId == null) {
            return null;
        }
        return (String)modelId;
    }

    private static byte[] getModelBlobFromResponse(Map<String, Object> responseMap) {
        Object blob = responseMap.get("model_blob");
        if (blob == null) {
            return null;
        }
        return Base64.getDecoder().decode((String)blob);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        builder.field("model_id", this.modelID);
        String base64Model = "";
        if (this.getModelBlob() != null) {
            base64Model = Base64.getEncoder().encodeToString(this.getModelBlob());
        }
        builder.field("model_blob", base64Model);
        this.getModelMetadata().toXContent(builder, params);
        return xContentBuilder.endObject();
    }
}

