"use strict";

var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/components/icon', () => ({
  EuiIcon: () => /*#__PURE__*/_react.default.createElement("div", null, "EuiIconMock"),
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/components/icon/icon').COLORS
}));
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility', () => ({
  htmlIdGenerator: () => () => 'generated-id',
  cascadingMenuKeys: require('@elastic/eui/lib/services/accessibility/cascading_menu_keys'),
  comboBoxKeys: require('@elastic/eui/lib/services/accessibility/combo_box_keys'),
  accessibleClickKeys: require('@elastic/eui/lib/services/accessibility/accessible_click_keys')
}));

// https://github.com/facebook/jest/issues/5785
// https://github.com/facebook/jest/pull/5267#issuecomment-356605468
beforeEach(() => {
  jest.spyOn(console, 'error');
  console.error.mockImplementation(() => {});
});
afterEach(() => {
  console.error.mockRestore();
});
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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