/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum ADSuggestName implements Name
{
    INTERVAL("detection_interval"),
    HISTORY("history"),
    WINDOW_DELAY("window_delay");

    private String name;

    private ADSuggestName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ADSuggestName getName(String name) {
        switch (name) {
            case "detection_interval": {
                return INTERVAL;
            }
            case "history": {
                return HISTORY;
            }
            case "window_delay": {
                return WINDOW_DELAY;
            }
        }
        throw new IllegalArgumentException("The given suggest type doesn't exist");
    }

    public static Set<ADSuggestName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, ADSuggestName::getName);
    }
}

