/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import mediathek.config.MVColor;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.FilmResolution;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.MVPanelDownloadZiel;
import mediathek.swing.IconUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GetFile;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome6.FontAwesomeSolid;

public class DialogEditDownload
extends JDialog {
    private final DatenDownload datenDownload;
    public boolean ok;
    private final JTextField[] textfeldListe = new JTextField[40];
    private final JLabel[] labelListe = new JLabel[40];
    private final JCheckBox jCheckBoxRestart = new JCheckBox();
    private final JCheckBox jCheckBoxDownloadmanager = new JCheckBox();
    private final JCheckBox jCheckBoxUnterbrochen = new JCheckBox();
    private final JCheckBox jCheckBoxInfodatei = new JCheckBox();
    private final JCheckBox jCheckBoxSubtitle = new JCheckBox();
    private final JCheckBox jCheckBoxSpotlight = new JCheckBox();
    private final MVPanelDownloadZiel mVPanelDownloadZiel;
    private final boolean gestartet;
    private String dateiGroesse_HD = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private final JFrame parent;
    private final String orgProgArray;
    private FilmResolution.Enum resolution = FilmResolution.Enum.NORMAL;
    private final JCheckBox cbHighQuality = new JCheckBox();
    private final JCheckBox cbSubtitleAvailable = new JCheckBox();
    private final TableColumnModel columnModel;
    private final GridBagLayout gridbag;
    private static final Logger logger = LogManager.getLogger(DialogEditDownload.class);
    private JPanel jPanelExtra;
    private JPanel jPanelRes;
    private JRadioButton jRadioButtonResHd;
    private JRadioButton jRadioButtonResHi;
    private JRadioButton jRadioButtonResLo;
    private JButton jButtonOk;
    private JButton jButtonAbbrechen;

    public DialogEditDownload(JFrame parent, DatenDownload datenDownload, boolean started, TableColumnModel colModel) {
        super(parent);
        this.initComponents();
        this.gridbag = (GridBagLayout)this.jPanelExtra.getLayout();
        this.parent = parent;
        this.datenDownload = datenDownload;
        this.gestartet = started;
        this.columnModel = colModel;
        this.cbSubtitleAvailable.setEnabled(false);
        this.cbHighQuality.setEnabled(false);
        this.orgProgArray = this.datenDownload.arr[27];
        this.mVPanelDownloadZiel = new MVPanelDownloadZiel(parent, this.datenDownload, false);
        this.mVPanelDownloadZiel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.setupButtonBar();
        this.setupResolutionButtons();
        this.setupResolutionButtonListeners();
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.buildLayout();
        this.restoreLocation();
        this.setupComponentListeners();
    }

    private void setupComponentListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DialogEditDownload.this.saveLocation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                DialogEditDownload.this.saveLocation();
            }
        });
    }

    private void setupButtonBar() {
        this.jButtonOk.addActionListener(actionEvent -> {
            if (this.check()) {
                this.dispose();
            }
        });
        this.jButtonAbbrechen.addActionListener(actionEvent -> this.dispose());
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    private void setupResolutionButtonListeners() {
        this.jRadioButtonResHd.addActionListener(actionEvent -> this.changeRes());
        this.jRadioButtonResHi.addActionListener(actionEvent -> this.changeRes());
        this.jRadioButtonResLo.addActionListener(actionEvent -> this.changeRes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreLocation() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = config.getInt("edit_download_dialog.x");
            newLocation.y = config.getInt("edit_download_dialog.y");
            this.setLocation(newLocation);
            int w = config.getInt("edit_download_dialog.width", -1);
            int h = config.getInt("edit_download_dialog.height", -1);
            if (w != -1 && h != -1) {
                this.setSize(w, h);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            Point location = this.getLocationOnScreen();
            config.setProperty("edit_download_dialog.x", (Object)location.x);
            config.setProperty("edit_download_dialog.y", (Object)location.y);
            config.setProperty("edit_download_dialog.width", (Object)this.getWidth());
            config.setProperty("edit_download_dialog.height", (Object)this.getHeight());
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private void setupResolutionButtons() {
        this.jRadioButtonResHd.setEnabled(false);
        this.jRadioButtonResHi.setEnabled(false);
        this.jRadioButtonResLo.setEnabled(false);
        if (this.datenDownload.art != 1 && this.datenDownload.pSet == null) {
            this.jPanelRes.setVisible(false);
            return;
        }
        if (this.datenDownload.film != null) {
            this.jRadioButtonResHi.setEnabled(!this.gestartet);
            this.jRadioButtonResHi.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL)));
            this.dateiGroesse_Hoch = this.datenDownload.film.getFileSizeForUrl(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL));
            if (!this.dateiGroesse_Hoch.isEmpty()) {
                this.jRadioButtonResHi.setText(this.jRadioButtonResHi.getText() + "   [ " + this.dateiGroesse_Hoch + " MB ]");
            }
            if (!this.datenDownload.film.getHighQualityUrl().isEmpty()) {
                this.jRadioButtonResHd.setEnabled(!this.gestartet);
                this.jRadioButtonResHd.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY)));
                this.dateiGroesse_HD = this.datenDownload.film.getFileSizeForUrl(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY));
                if (!this.dateiGroesse_HD.isEmpty()) {
                    this.jRadioButtonResHd.setText(this.jRadioButtonResHd.getText() + "   [ " + this.dateiGroesse_HD + " MB ]");
                }
            }
            if (!this.datenDownload.film.getLowQualityUrl().isEmpty()) {
                this.jRadioButtonResLo.setEnabled(!this.gestartet);
                this.jRadioButtonResLo.setSelected(this.datenDownload.arr[21].equals(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)));
                this.dateiGroesse_Klein = this.datenDownload.film.getFileSizeForUrl(this.datenDownload.film.getUrlFuerAufloesung(FilmResolution.Enum.LOW));
                if (!this.dateiGroesse_Klein.isEmpty()) {
                    this.jRadioButtonResLo.setText(this.jRadioButtonResLo.getText() + "   [ " + this.dateiGroesse_Klein + " MB ]");
                }
            }
        }
        this.resolution = this.getRadioButtonResolution();
    }

    private FilmResolution.Enum getRadioButtonResolution() {
        FilmResolution.Enum res = this.jRadioButtonResHd.isSelected() ? FilmResolution.Enum.HIGH_QUALITY : (this.jRadioButtonResLo.isSelected() ? FilmResolution.Enum.LOW : FilmResolution.Enum.NORMAL);
        return res;
    }

    private void changeRes() {
        FilmResolution.Enum res = this.getRadioButtonResolution();
        this.datenDownload.arr[21] = this.datenDownload.film.getUrlFuerAufloesung(res);
        this.textfeldListe[21].setText(this.datenDownload.arr[21]);
        String size = this.jRadioButtonResHd.isSelected() ? this.dateiGroesse_HD : (this.jRadioButtonResLo.isSelected() ? this.dateiGroesse_Klein : this.dateiGroesse_Hoch);
        if (this.datenDownload.art == 2 && this.datenDownload.pSet != null) {
            DatenDownload d = new DatenDownload(this.datenDownload.pSet, this.datenDownload.film, this.datenDownload.quelle, this.datenDownload.abo, this.datenDownload.arr[29], this.datenDownload.arr[30], res.toString());
            this.datenDownload.arr[26] = d.arr[26];
            this.datenDownload.arr[27] = d.arr[27];
            this.textfeldListe[26].setText(this.datenDownload.arr[26]);
            this.textfeldListe[27].setText(this.datenDownload.arr[27]);
        }
        this.datenDownload.setGroesse(size);
    }

    private void buildLayout() {
        this.jPanelExtra.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(this.gridbag);
        int zeile = 0;
        int colCount = this.columnModel.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            JLabel label;
            if (this.doNotShow(i) || i == 2 && this.datenDownload.arr[2].isEmpty() || i == 18 && this.datenDownload.arr[18].isEmpty() || i == 23 && this.datenDownload.arr[23].isEmpty()) continue;
            this.labelListe[i] = label = new JLabel(DatenDownload.XML_NAMES[i] + ": ");
            JTextField textfeld = new JTextField();
            textfeld.setEditable(false);
            textfeld.setText(this.datenDownload.arr[i]);
            this.textfeldListe[i] = textfeld;
            this.addExtraFeld(i, c);
            c.gridy = ++zeile;
        }
        this.jPanelExtra.validate();
    }

    private boolean doNotShow(int i) {
        return i == 34 || i == 22 || i == 7 || i == 6 || i == 39 || i == 10 || i == 0 || i == 1 || i == 20 || i == 8 || i == 9;
    }

    private void addExtraFeld(int i, GridBagConstraints c) {
        c.gridx = 0;
        c.weightx = 0.0;
        if (this.doNotShow(i)) {
            return;
        }
        if (!(this.datenDownload.art != 1 || i != 29 && i != 31 && i != 30 || this.gestartet)) {
            if (i == 29) {
                c.gridx = 1;
                c.weightx = 10.0;
                this.gridbag.setConstraints(this.mVPanelDownloadZiel, c);
                this.jPanelExtra.add(this.mVPanelDownloadZiel);
            }
        } else {
            switch (i) {
                case 28: {
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.jCheckBoxRestart.setSelected(this.datenDownload.isRestart());
                    this.jCheckBoxRestart.addActionListener(new BeobCheckbox());
                    this.jCheckBoxRestart.setEnabled(!this.gestartet);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxRestart, c);
                    this.jPanelExtra.add(this.jCheckBoxRestart);
                    if (!this.datenDownload.isDownloadManager()) break;
                    this.jCheckBoxRestart.setEnabled(false);
                    break;
                }
                case 38: {
                    this.jCheckBoxDownloadmanager.setSelected(this.datenDownload.isDownloadManager());
                    this.jCheckBoxDownloadmanager.setEnabled(false);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxDownloadmanager, c);
                    this.jPanelExtra.add(this.jCheckBoxDownloadmanager);
                    break;
                }
                case 17: {
                    if (!this.datenDownload.isInterrupted()) {
                        return;
                    }
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.jCheckBoxUnterbrochen.setSelected(this.datenDownload.isInterrupted());
                    this.jCheckBoxUnterbrochen.addActionListener(new BeobCheckbox());
                    this.jCheckBoxUnterbrochen.setEnabled(!this.gestartet);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxUnterbrochen, c);
                    this.jPanelExtra.add(this.jCheckBoxUnterbrochen);
                    break;
                }
                case 35: {
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.datenDownload.arr[35]));
                    this.jCheckBoxInfodatei.addActionListener(new BeobCheckbox());
                    this.jCheckBoxInfodatei.setEnabled(!this.gestartet);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxInfodatei, c);
                    this.jPanelExtra.add(this.jCheckBoxInfodatei);
                    break;
                }
                case 37: {
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.datenDownload.arr[37]));
                    this.jCheckBoxSubtitle.addActionListener(new BeobCheckbox());
                    this.jCheckBoxSubtitle.setEnabled(!this.gestartet);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxSubtitle, c);
                    this.jPanelExtra.add(this.jCheckBoxSubtitle);
                    break;
                }
                case 36: {
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.jCheckBoxSpotlight.setSelected(Boolean.parseBoolean(this.datenDownload.arr[36]));
                    this.jCheckBoxSpotlight.addActionListener(new BeobCheckbox());
                    this.jCheckBoxSpotlight.setEnabled(!this.gestartet);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.jCheckBoxSpotlight, c);
                    this.jPanelExtra.add(this.jCheckBoxSpotlight);
                    break;
                }
                case 15: {
                    this.cbHighQuality.setSelected(true);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.cbHighQuality, c);
                    this.jPanelExtra.add(this.cbHighQuality);
                    if (this.datenDownload.film != null) {
                        this.cbHighQuality.setVisible(this.datenDownload.film.isHighQuality());
                        break;
                    }
                    this.cbHighQuality.setVisible(false);
                    break;
                }
                case 16: {
                    this.cbSubtitleAvailable.setSelected(true);
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.cbSubtitleAvailable, c);
                    this.jPanelExtra.add(this.cbSubtitleAvailable);
                    if (this.datenDownload.film != null) {
                        this.cbSubtitleAvailable.setVisible(this.datenDownload.film.hasSubtitle());
                        break;
                    }
                    this.cbSubtitleAvailable.setVisible(false);
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    if (this.datenDownload.art != 2) break;
                    if (this.datenDownload.arr[27].isEmpty()) {
                        this.labelListe[27].setForeground(MVColor.getBlueColor());
                        this.textfeldListe[26].setEditable(!this.gestartet);
                        this.textfeldListe[26].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(26));
                        this.gridbag.setConstraints(this.labelListe[27], c);
                        this.jPanelExtra.add(this.labelListe[27]);
                        c.gridx = 1;
                        c.weightx = 10.0;
                        this.gridbag.setConstraints(this.textfeldListe[26], c);
                        this.jPanelExtra.add(this.textfeldListe[26]);
                        break;
                    }
                    this.labelListe[i].setForeground(MVColor.getBlueColor());
                    this.textfeldListe[i].setEditable(!this.gestartet);
                    this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    JPanel jp = new JPanel();
                    jp.setBorder(BorderFactory.createTitledBorder(""));
                    GridBagLayout gb = new GridBagLayout();
                    GridBagConstraints gc = new GridBagConstraints();
                    gc.fill = 2;
                    gc.insets = new Insets(2, 2, 2, 2);
                    jp.setLayout(gb);
                    JButton jButtonReset = new JButton("");
                    jButtonReset.setToolTipText("Reset");
                    jButtonReset.setIcon((Icon)IconUtils.of((Ikon)FontAwesomeSolid.REDO_ALT));
                    jButtonReset.addActionListener(actionEvent -> this.textfeldListe[27].setText(this.orgProgArray));
                    JButton jButtonHelp = new JButton("");
                    jButtonHelp.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
                    jButtonHelp.setToolTipText("Hilfe anzeigen");
                    jButtonHelp.addActionListener(actionEvent -> new DialogHilfe(this.parent, true, GetFile.getHilfeSuchen("/mediathek/file/hilfetext_editDownloadProg.txt")).setVisible(true));
                    gc.gridy = 0;
                    gc.gridx = 0;
                    gc.weightx = 1.0;
                    gb.setConstraints(jButtonHelp, gc);
                    jp.add(jButtonHelp);
                    gc.gridx = 1;
                    gc.weightx = 10.0;
                    gb.setConstraints(this.textfeldListe[26], gc);
                    jp.add(this.textfeldListe[26]);
                    gc.gridy = 1;
                    gc.gridx = 0;
                    gc.weightx = 1.0;
                    gb.setConstraints(jButtonReset, gc);
                    jp.add(jButtonReset);
                    gc.gridx = 1;
                    gc.weightx = 10.0;
                    gb.setConstraints(this.textfeldListe[i], gc);
                    jp.add(this.textfeldListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(jp, c);
                    this.jPanelExtra.add(jp);
                    break;
                }
                default: {
                    switch (i) {
                        case 0: {
                            this.textfeldListe[i].setText(String.valueOf(this.datenDownload.nr));
                            break;
                        }
                        case 1: {
                            if (this.datenDownload.film == null) break;
                            this.textfeldListe[i].setText(String.valueOf(this.datenDownload.film.getFilmNr()));
                            break;
                        }
                        case 21: {
                            if (this.datenDownload.art != 1) break;
                            this.labelListe[i].setForeground(MVColor.getBlueColor());
                            this.textfeldListe[i].setEditable(!this.gestartet);
                            this.textfeldListe[i].getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
                            break;
                        }
                        case 11: {
                            this.textfeldListe[i].setText(this.datenDownload.mVFilmSize.toString());
                            break;
                        }
                        case 8: {
                            this.textfeldListe[i].setText(Start.getTextProgress(this.datenDownload.isDownloadManager(), this.datenDownload.start));
                            break;
                        }
                        case 9: {
                            this.textfeldListe[i].setText(this.datenDownload.getTextRestzeit());
                            break;
                        }
                        case 32: {
                            switch (this.datenDownload.art) {
                                case 1: {
                                    this.textfeldListe[i].setText("direkter Download");
                                    break;
                                }
                                case 2: {
                                    this.textfeldListe[i].setText("Programm");
                                }
                            }
                            break;
                        }
                        case 33: {
                            switch (this.datenDownload.quelle) {
                                case -1: {
                                    this.textfeldListe[i].setText("Alle");
                                    break;
                                }
                                case 3: {
                                    this.textfeldListe[i].setText("Abo");
                                    break;
                                }
                                case 1: {
                                    this.textfeldListe[i].setText("Button");
                                    break;
                                }
                                case 2: {
                                    this.textfeldListe[i].setText("Download");
                                }
                            }
                            break;
                        }
                    }
                    this.gridbag.setConstraints(this.labelListe[i], c);
                    this.jPanelExtra.add(this.labelListe[i]);
                    c.gridx = 1;
                    c.weightx = 10.0;
                    this.gridbag.setConstraints(this.textfeldListe[i], c);
                    this.jPanelExtra.add(this.textfeldListe[i]);
                }
            }
        }
    }

    private boolean downloadDateiLoeschen(DatenDownload datenDownload) {
        try {
            File file = new File(datenDownload.arr[31]);
            if (!file.exists()) {
                return true;
            }
            int ret = JOptionPane.showConfirmDialog(this.parent, "Die Aufl\u00f6sung wurde ge\u00e4ndert, der Film kann nicht weitergef\u00fchrt werden.\nDatei muss zuerst gel\u00f6scht werden.", "Film L\u00f6schen?", 0);
            if (ret != 0) {
                return false;
            }
            logger.info("Datei l\u00f6schen: {}", (Object)file.getAbsolutePath());
            if (!file.delete()) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            logger.error("Fehler beim l\u00f6schen: {}", (Object)datenDownload.arr[31]);
        }
        return true;
    }

    private boolean check() {
        this.mVPanelDownloadZiel.setPfadName_geaendert();
        this.ok = this.jRadioButtonResHd.isSelected() && this.resolution != FilmResolution.Enum.HIGH_QUALITY || this.jRadioButtonResLo.isSelected() && this.resolution != FilmResolution.Enum.LOW || this.jRadioButtonResHi.isSelected() && this.resolution != FilmResolution.Enum.NORMAL ? this.downloadDateiLoeschen(this.datenDownload) : true;
        return this.ok;
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jPanelRes = new JPanel();
        this.jRadioButtonResHd = new JRadioButton();
        this.jRadioButtonResHi = new JRadioButton();
        this.jRadioButtonResLo = new JRadioButton();
        JPanel jPanel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Download \u00e4ndern");
        this.setMinimumSize(new Dimension(500, 50));
        this.setModal(true);
        this.setPreferredSize(null);
        Container contentPane = this.getContentPane();
        this.jPanelExtra.setLayout(new GridBagLayout());
        ((GridBagLayout)this.jPanelExtra.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.jPanelExtra.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.jPanelExtra.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)this.jPanelExtra.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        jScrollPane1.setViewportView(this.jPanelExtra);
        this.jPanelRes.setBorder(new TitledBorder("Download-Qualit\u00e4t:"));
        this.jPanelRes.setLayout(new FlowLayout(0, 10, 5));
        this.jRadioButtonResHd.setText("H\u00f6chste/Hoch");
        this.jPanelRes.add(this.jRadioButtonResHd);
        this.jRadioButtonResHi.setText("Mittel");
        this.jPanelRes.add(this.jRadioButtonResHi);
        this.jRadioButtonResLo.setText("Niedrig");
        this.jPanelRes.add(this.jRadioButtonResLo);
        jPanel1.setLayout(new FlowLayout());
        this.jButtonOk.setText("Ok");
        jPanel1.add(this.jButtonOk);
        this.jButtonAbbrechen.setText("Abbrechen");
        jPanel1.add(this.jButtonAbbrechen);
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(this.jPanelRes, -1, -1, Short.MAX_VALUE).addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(jPanel1, -2, -1, -2))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -1, 547, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelRes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonResHd);
        buttonGroup1.add(this.jRadioButtonResHi);
        buttonGroup1.add(this.jRadioButtonResLo);
    }

    private class BeobCheckbox
    implements ActionListener {
        private BeobCheckbox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditDownload.this.datenDownload.arr[28] = Boolean.toString(DialogEditDownload.this.jCheckBoxRestart.isSelected());
            DialogEditDownload.this.datenDownload.arr[17] = Boolean.toString(DialogEditDownload.this.jCheckBoxUnterbrochen.isSelected());
            DialogEditDownload.this.datenDownload.arr[35] = Boolean.toString(DialogEditDownload.this.jCheckBoxInfodatei.isSelected());
            DialogEditDownload.this.datenDownload.arr[37] = Boolean.toString(DialogEditDownload.this.jCheckBoxSubtitle.isSelected());
            DialogEditDownload.this.datenDownload.arr[36] = Boolean.toString(DialogEditDownload.this.jCheckBoxSpotlight.isSelected());
        }
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        final int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            DialogEditDownload.this.datenDownload.arr[this.nr] = DialogEditDownload.this.textfeldListe[this.nr].getText().trim();
            if (this.nr == 27) {
                DialogEditDownload.this.datenDownload.arr[26] = DatenProg.makeProgAufrufArray(DialogEditDownload.this.datenDownload.arr[27]);
                DialogEditDownload.this.textfeldListe[26].setText(DialogEditDownload.this.datenDownload.arr[26]);
            }
        }
    }
}

