/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.CalendarListener;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.CalendarSelectionEvent;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import com.github.lgooddatepicker.zinternaltools.YearMonthChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TestUpdateHighlightPolicy {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TestUpdateHighlightPolicy.createUI();
            }
        });
    }

    public static void createUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(new ProcedureTest());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static class ProcedureTest
    extends JPanel
    implements CalendarListener {
        private CalendarPanel picker;
        private LocalDate selectedDate;

        public ProcedureTest() {
            this.setLayout(new BorderLayout(5, 5));
            this.picker = this.createDatePicker();
            this.add((Component)this.picker, "Center");
        }

        private CalendarPanel createDatePicker() {
            DatePickerSettings settings = new DatePickerSettings();
            settings.setWeekNumberRules(WeekFields.ISO);
            settings.setWeekNumbersDisplayed(true, true);
            settings.setAllowEmptyDates(false);
            settings.setHighlightPolicy(new DynamicHighlightPolicy());
            CalendarPanel customizedPicker = new CalendarPanel(settings);
            customizedPicker.addCalendarListener(this);
            settings.setVetoPolicy(new VetoPolicy());
            return customizedPicker;
        }

        @Override
        public void selectedDateChanged(CalendarSelectionEvent event) {
            this.selectedDate = event.getNewDate();
            System.out.println(this.selectedDate);
        }

        @Override
        public void yearMonthChanged(YearMonthChangeEvent event) {
        }

        private class VetoPolicy
        implements DateVetoPolicy {
            private VetoPolicy() {
            }

            @Override
            public boolean isDateAllowed(LocalDate someDate) {
                return someDate.isAfter(LocalDate.now()) || someDate.isEqual(LocalDate.now());
            }
        }

        private class DynamicHighlightPolicy
        implements DateHighlightPolicy {
            private DynamicHighlightPolicy() {
            }

            @Override
            public HighlightInformation getHighlightInformationOrNull(LocalDate someDate) {
                if (ProcedureTest.this.selectedDate == null) {
                    return null;
                }
                if ((someDate.isAfter(LocalDate.now()) || someDate.isEqual(LocalDate.now())) && (someDate.isBefore(ProcedureTest.this.selectedDate) || someDate.isEqual(ProcedureTest.this.selectedDate))) {
                    return new HighlightInformation(Color.GREEN, Color.BLACK, "selected period");
                }
                return null;
            }
        }
    }
}

