/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/declaration/IrFieldVisibilityChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "<init>", "()V", "JVM_FIELD_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "isExemptFromValidation", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Z", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrFieldVisibilityChecker
extends IrElementChecker<IrField> {
    @NotNull
    public static final IrFieldVisibilityChecker INSTANCE = new IrFieldVisibilityChecker();
    @NotNull
    private static final ClassId JVM_FIELD_CLASS_ID = ClassId.Companion.fromString$default(ClassId.Companion, "kotlin/jvm/JvmField", false, 2, null);

    private IrFieldVisibilityChecker() {
        super(Reflection.getOrCreateKotlinClass(IrField.class));
    }

    private final boolean isExemptFromValidation(IrField $this$isExemptFromValidation) {
        Object object = $this$isExemptFromValidation.getCorrespondingPropertySymbol();
        return (object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false) || IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isExemptFromValidation, JVM_FIELD_CLASS_ID);
    }

    @Override
    public void check(@NotNull IrField element, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!Intrinsics.areEqual(element.getVisibility(), DescriptorVisibilities.PRIVATE) && !this.isExemptFromValidation(element)) {
            context2.error(this, element, "Kotlin fields are expected to always be private");
        }
    }
}

