/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.nio.ByteBuffer;

public interface Deserializer<T> {
    public T deserialize(ByteBuffer var1, ByteBuffer var2) throws RuntimeException;

    public static class UnknownRecordVersionException
    extends RuntimeException {
        private final short type;
        private final short unknownVersion;

        public UnknownRecordVersionException(short type, short unknownVersion) {
            super(String.format("Found an unknown record version %d for %d type", unknownVersion, type));
            this.type = type;
            this.unknownVersion = unknownVersion;
        }

        public short type() {
            return this.type;
        }

        public short unknownVersion() {
            return this.unknownVersion;
        }
    }

    public static class UnknownRecordTypeException
    extends RuntimeException {
        private final short unknownType;

        public UnknownRecordTypeException(short unknownType) {
            super(String.format("Found an unknown record type %d", unknownType));
            this.unknownType = unknownType;
        }

        public short unknownType() {
            return this.unknownType;
        }
    }
}

