/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import org.jsampler.CC;
import org.jsampler.SamplerChannelModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.SessionViewConfig;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.ChannelView;
import org.jsampler.view.std.StdChannelsPane;

public class ChannelsPane
extends StdChannelsPane {
    private ActionListener listener;

    public ChannelsPane(String string) {
        this(string, null);
    }

    public ChannelsPane(String string, ActionListener actionListener) {
        super(string);
        this.listener = actionListener;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.chnList);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected StdChannelsPane.ChannelList createChannelList() {
        return new FantasiaChannelList();
    }

    @Override
    protected StdChannelsPane.ChannelListModel createChannelListModel() {
        return new FantasiaChannelListModel();
    }

    @Override
    protected JSChannel createChannel(SamplerChannelModel samplerChannelModel) {
        return new Channel(samplerChannelModel, this.listener);
    }

    @Override
    public void addChannel(SamplerChannelModel samplerChannelModel) {
        this.addChannel(samplerChannelModel, null);
    }

    @Override
    public void addChannel(SamplerChannelModel samplerChannelModel, SessionViewConfig.ChannelConfig channelConfig) {
        JSChannel jSChannel = null;
        if (channelConfig != null) {
            switch (channelConfig.type) {
                case SMALL: {
                    jSChannel = new Channel(samplerChannelModel, this.listener, ChannelView.Type.SMALL);
                    break;
                }
                case NORMAL: {
                    jSChannel = new Channel(samplerChannelModel, this.listener, ChannelView.Type.NORMAL);
                }
            }
        }
        if (jSChannel == null) {
            jSChannel = new Channel(samplerChannelModel, this.listener);
        }
        if (channelConfig != null) {
            if (channelConfig.expanded) {
                ((Channel)jSChannel).expandChannel(false);
            }
        } else if (jSChannel.getChannelInfo().getEngine() == null) {
            ((Channel)jSChannel).expandChannel(false);
        }
        this.listModel.add(jSChannel);
        this.chnList.setSelectedComponent(jSChannel, true);
    }

    class FantasiaChannelListModel
    extends StdChannelsPane.ChannelListModel {
        FantasiaChannelListModel() {
        }

        @Override
        public boolean getComponentListIsAdjusting() {
            boolean bl = CC.getSamplerModel().getChannelListIsAdjusting();
            return super.getComponentListIsAdjusting() || bl;
        }
    }

    class FantasiaChannelList
    extends StdChannelsPane.ChannelList {
        FantasiaChannelList() {
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

