# frozen_string_literal: true

require_relative 'table'

module GitlabQuality
  module TestTooling
    module CodeCoverage
      module ClickHouse
        class TestFileMappingsTable < GitlabQuality::TestTooling::CodeCoverage::ClickHouse::Table
          TABLE_NAME = "test_file_mappings"

          private

          # @return [Boolean] True if the record is valid, false otherwise
          def valid_record?(record)
            valid_test_file?(record) && valid_source_file?(record)
          end

          # @return [Boolean] True if the test_file field is present
          def valid_test_file?(record)
            return true unless record[:test_file].blank?

            logger.warn("#{LOG_PREFIX} Skipping record with nil/empty test_file: #{record}")
            false
          end

          # @return [Boolean] True if the source_file field is present
          def valid_source_file?(record)
            return true unless record[:source_file].blank?

            logger.warn("#{LOG_PREFIX} Skipping record with nil/empty source_file: #{record}")
            false
          end

          # @return [Hash] Transformed mapping data including timestamp and CI metadata
          def sanitized_data_record(record)
            {
              timestamp: time,
              test_file: record[:test_file],
              source_file: record[:source_file],
              ci_project_path: ENV.fetch('CI_PROJECT_PATH', nil)
            }
          end
        end
      end
    end
  end
end
