# frozen_string_literal: true

module Labkit
  ##
  # Fields is intended to be a SSOT for all of the common field names that
  # we emit via any observability we add to our systems.
  #
  # These fields should span multiple services. This is
  #
  # The goal of this package is to reduce the likelihood for typos or
  # subtly different naming conventions. This will help to ensure we
  # are able to marry up logs between different systems as a request
  # is being processed.
  #
  # Usage:
  #   require 'labkit/fields'
  #   ...
  #   data[Labkit::Fields::GL_USER_ID] = user.id
  #   ...
  #
  # Labkit (Go): https://gitlab.com/gitlab-org/labkit/-/tree/master/fields?ref_type=heads
  #
  # For Engineers Looking to add fields:
  #
  # These fields are derived from the Go Labkit variant. Please ensure that you've made the
  # respective changes in that repository prior to including the fields in this package.
  #
  # Please see the handbook page for more information
  # https://handbook.gitlab.com/handbook/engineering/architecture/design-documents/observability_field_standardisation/
  module Fields
    # correlation_id - string
    #
    # correlation_id - string
    # This field is used to correlate
    # the logs emitted by all of our systems.
    # This should be present in all log line
    # emissions.
    CORRELATION_ID = "correlation_id"

    # GitLabUserID - an integer field that
    # captures the user's numeric ID for logging purposes.
    GL_USER_ID = "gl_user_id"

    # GitLabUserName - a string field that
    # captures the user's username for logging purposes.
    GL_USER_NAME = "gl_user_name"

    # New fields being added to this section should have
    # the appropriate doc comments added above. These
    # should clearly indicate what the intended use of the
    # field is and should be replicated across the labkit
    # variations.
  end
end
