---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 作業を計画し、実行します。
title: 作業計画を始める
---

GitLabには、作業の計画、実行、追跡に役立つツールが用意されています。計画、コラボレーション、ドキュメント、タイムトラッキング、レポート機能により、透明性、責任、効率的なプロジェクト管理を促進するワークフローを作成できます。

作業を計画するプロセスは、以下に示すより大きなワークフローの一部です。

![GitLabで行う主な作業の図で、「作業の計画と追跡」のセクションが強調表示されています。](img/get_started_planning_v16_11.png)

## ステップ1: タイムラインを定義する {#step-1-define-timelines}

まず、チームがプロジェクトの目標やタスクにどのように取り組みたいかを検討します。

`1.0`、`2.0`、`3.0`などのマイルストーンを使用してリリースを定義します。メジャーリリースとマイナーリリースの両方を実施するかどうかを決めます。

次に、チームの計画を標準的なケイデンスで進める場合は、イテレーションを使用します。イテレーションは、スプリントに似た一定の期間で区切られたサイクルです。たとえば、2週間ごとにリリースするように設定できます。

詳細については、以下を参照してください。

- [マイルストーン](../project/milestones/_index.md)
- [イテレーション](../group/iterations/_index.md)

## ステップ2: 作業を計画して整理する {#step-2-plan-and-organize-work}

リリースのケイデンスを決定したら、作業の整理を開始できます。

エピックは最上位レベルにあり、プロジェクトの主要な目標を全体的に把握し、チームの取り組みを全体のビジョンと整合させるのに役立ちます。

次に、イシューを定義してエピックに割り当てます。イシューは、対応が必要な特定のバグまたはユーザーストーリーを表します。イシューは、チームメンバーに割り当てたり、分類や優先順位付けのためにラベルを付けたり、完了に至るまでのさまざまなステージにわたって追跡したりできます。

さらに、イシュー内でタスクを使用して、作業をより小さく実行可能な項目に分割できます。

最後に、プロジェクトの目標を組織の目標と整合させるために、OKR（目標と主な成果）を作成し、エピックに関連付けることができます。測定可能な主な成果を定義することで、チームは進捗状況を追跡し、より広範な組織の目標に対する作業の影響を評価できます。

詳細については、以下を参照してください。

- [エピック](../group/epics/_index.md)
- [イシュー](../project/issues/_index.md)
- [タスク](../tasks.md)
- [OKR](../okrs.md)

## ステップ3: ワークフローを視覚化する {#step-3-visualize-your-workflow}

イシューボードは、プロジェクトのワークフローを視覚的に表現し、「To Do」、「進行中」、「完了」などのステータス別にイシューを分類して表示します。イシューボードを使用すると、プロジェクトの現在の状況を迅速に評価し、ボトルネックやブロッカーを特定できます。

詳細については、以下を参照してください。

- [イシューボード](../project/issue_board.md)

## ステップ4: コラボレーションとコミュニケーションを行う {#step-4-collaborate-and-communicate}

イシューを分類し優先順位を付けて、特定の作業領域を識別しやすくし、集中できるようにするために、ラベルを使用します。「バグ」、「機能強化」、「高優先度」などの説明的なラベルをイシューに割り当てることで、関連するタスクをフィルタリングして見つけやすくなります。

イシューでは、コメントとスレッドを使用して、ディスカッション、フィードバック、コラボレーションのための一元化されたスペースを提供します。チームメンバーは、イシューのコンテキスト内で質問したり、最新情報を提供したり、アイデアを共有したり、互いの作業をレビューしたりできます。

また、コメントではメンション（`@username`）を使用して、ディスカッションに参加してほしい他のユーザーに通知できます。誰かに対してメンションすると、そのユーザーに通知が送信されます。

詳細については、以下を参照してください。

- [ラベル](../project/labels.md)
- [コメントとスレッド](../discussions/_index.md)

## ステップ5: 進捗状況を追跡する {#step-5-track-progress}

進捗状況の追跡には、タスク、マイルストーン、プロジェクト全体の目標のステータスと完了を監視することが含まれます。

ロードマップを使用すると、エピックとマイルストーンのタイムラインを視覚化し、進捗状況を追跡できます。ロードマップは、プロジェクトの戦略的かつ長期的なビューを示し、主要な成果物の計画時期や、それらがプロジェクト全体の目標にどのように貢献しているのかを把握するのに役立ちます。

各イシューに費やした時間を記録して進捗状況を監視し、今後の作業を見積もるには、タイムトラッキングを使用します。

マイルストーンのバーンダウンチャートを使用すると、特定のマイルストーンに向けた進捗状況の概要をグラフィカルに表示できます。バーンダウンチャートには、時系列でオープン、クローズ、残りのイシュー数が表示されます。これを使用して進捗状況を追跡し、それに応じて作業を調整します。

詳細については、以下を参照してください。

- [ロードマップ](../group/roadmap/_index.md)
- [タイムトラッキング](../project/time_tracking.md)
- [マイルストーンのバーンアップチャートとバーンダウンチャート](../project/milestones/burndown_and_burnup_charts.md)

## ステップ6: レポートを作成して分析する {#step-6-report-and-analyze}

時間が経つにつれて、分析を使用してチームのパフォーマンスと生産性に関するインサイトを得られます。

ラベル、マイルストーン、イテレーションでフィルタリングしてイシューを分析します。優先度、カテゴリ、またはその他のカスタム条件でイシューをグループ化することもできます。

詳細については、以下を参照してください。

- [GitLabの使用状況を分析する](../analytics/_index.md)

## ステップ7: ドキュメントを作成して知識を共有する {#step-7-create-documentation-and-share-knowledge}

プロセス全体を通して、進捗状況と手順を文書化できます。

イシューとマージリクエストにコメントやメモを追加することに加え、要件もGitLabのワークフローにおけるドキュメントの重要な要素の1つです。要件は、特定の機能またはタスクにおいて期待される結果、受け入れ基準、制約を定義します。要件はイシューまたはWikiで文書化できます。これにより、提供すべき内容や成功の測定方法を明確に把握できるようになります。

Wikiは、プロジェクトのドキュメントおよびナレッジ管理の主要なハブとして機能します。これにより、チームメンバーがプロジェクトに関連するコンテンツを作成、編集、整理できる共同作業スペースが提供されます。Wikiには、プロジェクトのガイドライン、技術仕様、ベストプラクティスなど、幅広い情報を含めることができます。

詳細については、以下を参照してください。

- [要件](../project/requirements/_index.md)
- [Wiki](../project/wiki/_index.md)
