---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンPostman APIトークンの公開'
---

## 説明 {#description}

応答本文には、Postman APIトークンのパターンに一致するコンテンツが含まれていることが確認されました。APIキーは、アカウントがアクセス許可を持つすべてのPostmanデータへのアクセスを提供します。このトークンへのアクセス権を持つ悪意のある攻撃者は、APIキーを作成したユーザーがアクセスできるPostmanサービスに保存されているすべてのデータにアクセスできます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースへのアクセス権を取得できるようになる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

APIトークンを再生成するには:

- <https://www.postman.com/>でPostmanアカウントにサインインします
- 右上にあるプロフィール画像を選択し、「設定」を選択します
- 左側のメニューで「APIキー」を選択します
- 識別されたキーを見つけ、「APIキー」セクションのステータス列の横にある省略記号を選択します
- 「再生成」を選択します
- メッセージが表示されたら、「APIキーの再生成」ダイアログで「APIキーの再生成」を選択します

詳細については、[PostmanのAPIキーに関するドキュメント](https://learning.postman.com/docs/developer/postman-api/authentication/)を参照してください。

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.93 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
