---
stage: Application Security Testing
group: Composition Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 継続的な脆弱性スキャン
description: スキャン、依存関係、アドバイザリー、バックグラウンドジョブ
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 継続的な依存関係スキャンは、[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/371063)されました。[機能フラグ](../../../administration/feature_flags/_index.md) `dependency_scanning_on_advisory_ingestion`および`package_metadata_advisory_scans`は、デフォルトで有効になっています。
- GitLab 16.10で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/425753)になりました。機能フラグ`dependency_scanning_on_advisory_ingestion`および`package_metadata_advisory_scans`は削除されました。
- 継続的なコンテナスキャンは、GitLab 16.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/435435)されました。`container_scanning_continuous_vulnerability_scans`という名前の[フラグ](../../../administration/feature_flags/_index.md)付きです。デフォルトでは無効になっています。
- 継続的なコンテナスキャンは、GitLab 16.10の[GitLab Self-Managed、およびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/437162)になりました。
- GitLab 17.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/443712)になりました。機能フラグ`container_scanning_continuous_vulnerability_scans`は削除されました。
- コンテナスキャンと依存関係スキャンの新しいコンポーネントでのCVSのトリガーは、GitLab 17.3で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/464575)されました。`dependency_scanning_using_sbom_reports`という名前の[フラグ](../../../administration/feature_flags/_index.md)付きです。デフォルトでは無効になっています。
- コンテナスキャンの新しいコンポーネントでのCVSのトリガーは、GitLab 17.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165368)されました。`cvs_for_container_scanning`という名前の[フラグ](../../../administration/feature_flags/_index.md)付きです。デフォルトでは無効になっています。
- 依存関係スキャンのみの新しいコンポーネントでのCVSのトリガーは、17.5の[GitLab Self-Managed、およびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/395692)になりました。
- 機能フラグ`dependency_scanning_using_sbom_reports`はGitLab 17.10で削除されました。

{{< /history >}}

継続的脆弱性スキャンは、プロジェクトの依存関係にあるセキュリティ脆弱性を、最新の[セキュリティアドバイザリー](#security-advisories)の情報とコンポーネント名およびバージョンを比較することによって検索します。

継続的脆弱性スキャンが、[サポートされているパッケージタイプ](#supported-package-types)のコンポーネントを含むすべてのプロジェクトでスキャンをトリガーすると、[新しい脆弱性が発生する可能性](#checking-new-vulnerabilities)があります。

継続的脆弱性スキャンによって作成された脆弱性は、`GitLab SBoM Vulnerability Scanner`をスキャナー名として使用します。

CIベースのセキュリティスキャンとは対照的に、継続的脆弱性スキャンは、CIパイプラインではなく、バックグラウンドジョブ（Sidekiq）を通じて実行され、セキュリティレポートアーティファクトは生成されません。

## 前提要件 {#prerequisites}

- 継続的脆弱性スキャンで[サポート](#supported-package-types)されている依存関係があるプロジェクト。[CycloneDX SBOMレポートを生成する方法](#how-to-generate-a-cyclonedx-sbom-report)を参照してください。
- [セキュリティアドバイザリー](#security-advisories)がGitLabインスタンスに同期されました。

## サポートされているパッケージタイプ {#supported-package-types}

継続的な脆弱性スキャンは、次の[PURLタイプ](https://github.com/package-url/purl-spec/blob/346589846130317464b677bc4eab30bf5040183a/PURL-TYPES.rst)のコンポーネントをサポートしています:

- `apk`
- `cargo`
- `conan`
- `deb`
- `go`
- `maven`
- `npm`
- `nuget`
- `packagist`
- `pub`
- `pypi`
- `rpm`
- `rubygem`
- `swift`

Goの疑似バージョンはサポートされていません。Goの疑似バージョンを参照するプロジェクトの依存関係は、誤検出につながる可能性があるため、影響を受けているとは見なされません。

`^`を含むRPMバージョンはサポートされていません。これらのバージョンをサポートする作業は、[イシュー459969](https://gitlab.com/gitlab-org/gitlab/-/issues/459969)で追跡されます。先頭にゼロを含むAPKバージョンはサポートされていません。これらのバージョンをサポートする作業は、[イシュー471509](https://gitlab.com/gitlab-org/gitlab/-/issues/471509)で追跡されます。

Red HatディストリビューションのRPMパッケージはサポートされていません。このユースケースをサポートする作業は、[エピック12980](https://gitlab.com/groups/gitlab-org/-/epics/12980)で追跡されます。

## CycloneDX SBOMレポートを生成する方法 {#how-to-generate-a-cyclonedx-sbom-report}

CycloneDX SBOM [レポート](../../../ci/yaml/artifacts_reports.md#artifactsreportscyclonedx)を使用して、プロジェクトのコンポーネントをGitLabに登録します。

GitLabは、GitLabと互換性のあるレポートを生成できるセキュリティアナライザーを提供しています:

- [コンテナスキャン](../container_scanning/_index.md#getting-started)
- [レジストリのコンテナスキャン](../container_scanning/_index.md#container-scanning-for-registry)
- [依存関係スキャン](../dependency_scanning/_index.md#getting-started)
- [依存関係スキャンCI/CDコンポーネント](https://gitlab.com/explore/catalog/components/dependency-scanning)（試験的）

## 新しい脆弱性のチェック {#checking-new-vulnerabilities}

継続的な脆弱性スキャンによって検出された新しい脆弱性は、[脆弱性レポート](../vulnerability_report/_index.md)に表示されます。ただし、影響を受けるSBOMコンポーネントが検出されたパイプラインにはリストされていません。

脆弱性は、次のシナリオに従って作成されます:

- [セキュリティアドバイザリー](#security-advisories)が追加または更新された後、コードベースが変更されていない場合、対応する脆弱性がプロジェクトに追加されるまでに数時間かかることがあります。継続的な脆弱性スキャンでは、過去14日以内に公開されたアドバイザリーのみが考慮されます。

- 既存の[セキュリティアドバイザリー](#security-advisories)の場合、新しいコンポーネントが検出され、次のいずれかの条件に該当する場合**only**（のみ）脆弱性が作成されます:

  - このコンポーネントは、[依存関係スキャン](../dependency_scanning/_index.md#cyclonedx-software-bill-of-materials)によって生成されたCycloneDX SBOMにリストされています。
  - [機能フラグ](../../../administration/feature_flags/_index.md) `cvs_for_container_scanning`が有効になっており、コンポーネントが[コンテナスキャン](../container_scanning/_index.md#cyclonedx-software-bill-of-materials)によって生成されたCycloneDX SBOMにリストされています。

## 脆弱性が検出されなくなった場合 {#when-vulnerabilities-are-no-longer-detected}

継続的脆弱性スキャンは、新しいアドバイザリーが公開されると脆弱性を自動的に作成しますが、プロジェクトに脆弱性が存在しなくなったことを通知することはできません。これを行うために、GitLabは、[コンテナスキャン](../container_scanning/_index.md)または[依存関係スキャン](../dependency_scanning/_index.md)スキャンがデフォルトブランチのパイプラインで実行され、最新の情報で生成された対応するセキュリティレポートアーティファクトを持つことを引き続き要求します。これらのレポートが処理され、一部の脆弱性が含まれなくなった場合、継続的な脆弱性スキャンによって作成された場合でも、これらはそのようにフラグが設定されます。この動作は、[イシュー441490](https://gitlab.com/gitlab-org/gitlab/-/issues/441490)で17.1で導入され、GitLabによって管理されるスキャナー（`Trivy`、`gemnasium`、`gemnasium-python`、`gemnasium-maven`）に適用されます。

## セキュリティアドバイザリー {#security-advisories}

継続的脆弱性スキャンは、パッケージメタデータデータベースを使用します。これは、GitLabが管理するサービスであり、ライセンスとセキュリティアドバイザリーデータを集約し、GitLab.comおよびGitLab Self-Managedインスタンスで使用される更新プログラムを定期的に公開します。

GitLab.comでは、同期はGitLabによって管理され、すべてのプロジェクトで利用できます。

GitLab Self-Managedでは、GitLabインスタンスの**管理者**エリアで[同期するパッケージレジストリメタデータを選択](../../../administration/settings/security_and_compliance.md#choose-package-registry-metadata-to-sync)できます。

### データソース {#data-sources}

セキュリティアドバイザリーの現在のデータソースは次のとおりです:

- [GitLab Advisory Database](https://advisories.gitlab.com/)
- [Trivy DB](https://github.com/aquasecurity/trivy-db)

### 脆弱性データベースにコントリビュートする {#contributing-to-the-vulnerability-database}

脆弱性を検索するには、[`GitLab advisory database`](https://advisories.gitlab.com/)を検索します。[新しい脆弱性を送信](https://gitlab.com/gitlab-org/security-products/gemnasium-db/blob/master/CONTRIBUTING.md)することもできます。
