---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab.comおよびGitLab Self-ManagedのインスタンスRunnerのコンピューティング時間、購入、使用状況の追跡、クォータ管理。
title: インスタンスRunnerのコンピューティング使用量
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プロジェクトが管理者が管理する[インスタンスRunner](../runners/runners_scope.md#instance-runners)でジョブを実行するために消費できるコンピューティング時間の使用量は制限されています。この制限は、GitLabサーバー上のインスタンスRunnerのコンピューティングクォータで追跡されます。ネームスペースがクォータを超えると、[クォータが適用](#enforcement)されます。

管理者が管理するインスタンスRunnerとは、[GitLabインスタンスの管理者によって管理されているもの](../../administration/cicd/compute_minutes.md)です。

{{< alert type="note" >}}

GitLab.comのインスタンスRunnerは、インスタンスがGitLabによって管理されているため、管理者が管理し、GitLabがホストします。

{{< /alert >}}

## コンピューティングクォータの適用 {#compute-quota-enforcement}

### 毎月のリセット {#monthly-reset}

コンピューティング時間の使用量は、毎月`0`にリセットされます。コンピューティングクォータは[毎月の割り当てにリセット](https://about.gitlab.com/pricing/)されます。

たとえば、月次割り当てが10,000コンピューティング時間の場合:

1. 4月1日に、利用可能な10,000コンピューティング時間があります。
1. たとえば、4月には、クォータで利用可能な10,000コンピューティング時間のうち、6,000コンピューティング時間を使用するとします。
1. 5月1日に、累積コンピューティング使用量が0にリセットされ、5月に10,000コンピューティング時間が利用できるようになります。

前月の使用量データは、時間の経過に伴う消費量の履歴ビューを表示するために保持されます。

### 通知 {#notifications}

残りのコンピューティング時間が以下の状態になると、アプリ内バナーが表示され、ネームスペースのメール通知がネームスペースのオーナーに送信されます:

- 割り当ての25％未満。
- 割り当ての5％未満。
- 完全に使用済み（残り時間ゼロ）。

### 適用 {#enforcement}

当月のコンピューティング割り当てが使い果たされると、インスタンスRunnerは新しいジョブの処理を停止します。すでに開始されているパイプラインでは、次のようになります:

- インスタンスRunnerで処理する必要がある保留中のジョブ（まだ開始されていない）または再試行されたジョブはドロップされます。
- インスタンスRunnerで実行されているジョブは、ネームスペースの使用量全体が割り当てを1,000コンピューティング時間超過するまで実行を続けることができます。1,000コンピューティング時間の猶予期間後、残りの実行中のジョブもドロップされます。

プロジェクトグループRunnerは、コンピューティング割り当ての影響を受けないため、ジョブの処理を続行します。

## 使用状況の表示 {#view-usage}

グループネームスペースまたはパーソナルネームスペースのコンピューティング使用量を表示して、コンピューティング使用量の傾向と残りのコンピューティング時間を確認できます。

場合によっては、割り当て制限が次のいずれかのラベルに置き換えられます:

- **無制限**: コンピューティング割り当てが無制限のネームスペースの場合。
- **未サポート**: インスタンスRunnerが有効になっていないネームスペースの場合。

### グループの使用状況の表示 {#view-usage-for-a-group}

前提要件: 

- グループのオーナーロールを持っている必要があります。

グループのコンピューティング使用量を表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。グループはサブグループであってはなりません。
1. **設定** > **使用量クォータ**を選択します。
1. **パイプライン**タブを選択します。

プロジェクトリストには、当月のコンピューティング使用量またはインスタンスRunner使用量が含まれたプロジェクトのみが表示されます。リストには、ネームスペースとそのサブグループ内のすべてのプロジェクトが含まれ、コンピューティング使用量で降順にソートされています。

### 個人のネームスペースの使用状況の表示 {#view-usage-for-a-personal-namespace}

パーソナルネームスペースのコンピューティング使用量を表示できます:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**使用量クォータ**を選択します。

プロジェクトリストには、当月のコンピューティング使用量またはインスタンスRunner使用量が含まれた[パーソナルプロジェクト](../../user/project/working_with_projects.md)のみが表示されます。
