---
stage: Runtime
group: Geo
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ディザスターリカバリーのために、2つのシングルノードサイト間でGitLab Geoのレプリケーションを構成し、LinuxパッケージとDockerのインストールをサポートします。
title: 2つの単一ノードサイト用のGeoをセットアップする
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

このガイドでは、外部サービスを設定せずに、2つのLinuxパッケージインスタンスを使用する2つのシングルノードサイトインストール用にGitLab Geoをデプロイする方法について、簡潔な手順を説明します。このガイドは、[Docker](../../../install/docker/_index.md)に基づくインストールにも適用できます。

前提要件: 

- 少なくとも2つの独立して動作するGitLabサイトが必要です。サイトを作成するには、[GitLabのリファレンスアーキテクチャのドキュメント](../../reference_architectures/_index.md)を参照してください。
  - 1つのGitLabサイトが**Geo primary site**（Geoプライマリサイト）として機能します。各Geoサイトに異なるリファレンスアーキテクチャのサイズを使用できます。すでに動作しているGitLabインスタンスがある場合は、プライマリサイトとして使用できます。
  - 2番目のGitLabサイトは、**Geo secondary site**（Geoセカンダリサイト）として機能します。Geoは、複数のセカンダリサイトをサポートします。
- Geoプライマリサイトには、少なくとも[GitLab Premium](https://about.gitlab.com/pricing/)ライセンスが必要です。すべてのサイトに必要なライセンスは1つだけです。
- すべてのサイトが[Geoの実行要件](../_index.md#requirements-for-running-geo)を満たしていることを確認します。

## Linuxパッケージ（Omnibus）でのGeoの設定 {#set-up-geo-for-linux-package-omnibus}

前提要件: 

- [`pg_basebackup`ツール](https://www.postgresql.org/docs/16/app-pgbasebackup.html)を含むPostgreSQL 12以降を使用します。

### プライマリサイトの設定 {#configure-the-primary-site}

{{< alert type="note" >}}

Dockerベースのインストールの場合:

以下の設定をGitLabコンテナの`/etc/gitlab/gitlab.rb`ファイルに直接適用するか、[Docker Compose](../../../install/docker/installation.md#install-gitlab-by-using-docker-compose)ファイルの`GITLAB_OMNIBUS_CONFIG`環境変数に追加します。

[Docker Compose](../../../install/docker/installation.md#install-gitlab-by-using-docker-compose)を使用する場合は、`docker-compose -f <docker-compose-file-name>.yml up`の代わりに`gitlab-ctl reconfigure`を使用して、設定の変更を適用します。

{{< /alert >}}

1. GitLabのプライマリサイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. [PostgreSQLの自動アップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)して、GitLabのアップグレード時に意図しないダウンタイムが発生するのを防ぎます。[GeoでPostgreSQLをアップグレードする際の既知の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのアップグレードは計画的に実行する必要があります。その結果、今後、PostgreSQLのアップグレードが定期的なメンテナンス作業の一部であることを確認してください。

1. 一意のGeoサイト名を`/etc/gitlab/gitlab.rb`に追加します:

   ```ruby
   ##
   ## The unique identifier for the Geo site. See
   ## https://docs.gitlab.com/ee/administration/geo_sites.html#common-settings
   ##
   gitlab_rails['geo_node_name'] = '<site_name_here>'
   ```

1. 変更を適用するには、プライマリサイトを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

1. サイトをプライマリGeoサイトとして定義します:

   ```shell
   gitlab-ctl set-geo-primary-node
   ```

   このコマンドは、`/etc/gitlab/gitlab.rb`で定義された`external_url`を使用します。

1. [プライマリサイトの完全な設定](#complete-primary-site)の設定例をコピーします。

1. `gitlab`データベースユーザーのパスワードを作成し、新しいパスワードを使用するようにRailを更新します。

   {{< alert type="note" >}}

   `gitlab_rails['db_password']`および`postgresql['sql_user_password']`の設定に設定された値は一致する必要があります。ただし、`postgresql['sql_user_password']`の値のみがMD5暗号化されたパスワードである必要があります。これに対する変更は、[CookbookでPostgreSQLパスワードを処理する方法の見直し](https://gitlab.com/gitlab-org/omnibus-gitlab/-/issues/5713)で議論されています。

   {{< /alert >}}

   1. 目的のパスワードのMD5ハッシュを生成します:

      ```shell
      gitlab-ctl pg-password-md5 gitlab
      # Enter password: <your_db_password_here>
      # Confirm password: <your_db_password_here>
      # fca0b89a972d69f00eb3ec98a5838484
      ```

   1. `/etc/gitlab/gitlab.rb`を編集します: 

      ```ruby
      # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab`
      postgresql['sql_user_password'] = '<md5_hash_of_your_db_password>'

      # Every node that runs Puma or Sidekiq needs to have the database
      # password specified as below. If you have a high-availability setup, this
      # must be present in all application nodes.
      gitlab_rails['db_password'] = '<your_db_password_here>'
      ```

1. [データベースレプリケーションユーザー](https://www.postgresql.org/docs/16/warm-standby.html#STREAMING-REPLICATION)のパスワードを定義します。`/etc/gitlab/gitlab.rb`の`postgresql['sql_replication_user']`設定で定義されているユーザー名を使用します。デフォルト値は`gitlab_replicator`です。

   1. 目的のパスワードのMD5ハッシュを生成します:

      ```shell
      gitlab-ctl pg-password-md5 gitlab_replicator

      # Enter password: <your_replication_password_here>
      # Confirm password: <your_replication_password_here>
      # 950233c0dfc2f39c64cf30457c3b7f1e
      ```

   1. `/etc/gitlab/gitlab.rb`を編集します: 

      ```ruby
      # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab_replicator`
      postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
      ```

   1. オプション。Linuxパッケージで管理されていない外部データベースを使用する場合は、`gitlab_replicator`ユーザーを作成し、そのユーザーのパスワードを手動で定義する必要があります:

      ```sql
      --- Create a new user 'replicator'
      CREATE USER gitlab_replicator;

      --- Set/change a password and grants replication privilege
      ALTER USER gitlab_replicator WITH REPLICATION ENCRYPTED PASSWORD '<replication_password>';
      ```

1. `/etc/gitlab/gitlab.rb`で、ロールを[`geo_primary_role`](https://docs.gitlab.com/omnibus/roles/#gitlab-geo-roles)に設定します:

   ```ruby
   ## Geo Primary role
   roles(['geo_primary_role'])
   ```

1. ネットワークインターフェースでリッスンするようにPostgreSQLを設定します:

   1. Geoサイトのアドレスを検索するには、GeoサイトにSSHで接続して実行します:

      ```shell
      ##
      ## Private address
      ##
      ip route get 255.255.255.255 | awk '{print "Private address:", $NF; exit}'

      ##
      ## Public address
      ##
      echo "External address: $(curl --silent "ipinfo.io/ip")"
      ```

      ほとんどの場合、次のアドレスはGitLab Geoの設定に使用されます:

      | 設定                           | アドレス                                                               |
      |:----------------------------------------|:----------------------------------------------------------------------|
      | `postgresql['listen_address']`          | プライマリサイトのパブリックアドレスまたはVPCプライベートアドレス。                     |
      | `postgresql['md5_auth_cidr_addresses']` | プライマリサイトとセカンダリサイトのパブリックアドレスまたはVPCプライベートアドレス。 |

      Google Cloud Platform、SoftLayer、またはバーチャルプライベートクラウド（VPC）を提供するその他のベンダーを使用している場合は、`postgresql['md5_auth_cidr_addresses']`および`postgresql['listen_address']`にプライマリサイトとセカンダリサイトのプライベートアドレス（Google Cloud Platformの「内部アドレス」に対応）を使用できます。

      {{< alert type="note" >}}

      `0.0.0.0`または`*`を`listen_address`として使用する必要がある場合は、`127.0.0.1/32`を`postgresql['md5_auth_cidr_addresses']`設定に追加して、Railsが`127.0.0.1`経由で接続できるようにする必要もあります。詳細については、[issue 5258](https://gitlab.com/gitlab-org/omnibus-gitlab/-/issues/5258)を参照してください。

      {{< /alert >}}

      ネットワーク設定によっては、推奨されるアドレスが正しくない場合があります。プライマリサイトとセカンダリサイトがローカルエリアネットワーク経由、または[Amazon VPC](https://aws.amazon.com/vpc/)や[Google VPC](https://cloud.google.com/vpc/)などのアベイラビリティーゾーンを接続する仮想ネットワーク経由で接続する場合は、`postgresql['md5_auth_cidr_addresses']`にセカンダリサイトのプライベートアドレスを使用する必要があります。

   1. `/etc/gitlab/gitlab.rb`に次の行を追加します。IPアドレスを、ネットワーク設定に適したアドレスに置き換えてください:

      ```ruby
      ##
      ## Primary address
      ## - replace '<primary_node_ip>' with the public or VPC address of your Geo primary node
      ##
      postgresql['listen_address'] = '<primary_site_ip>'

      ##
      # Allow PostgreSQL client authentication from the primary and secondary IPs. These IPs may be
      # public or VPC addresses in CIDR format, for example ['198.51.100.1/32', '198.51.100.2/32']
      ##
      postgresql['md5_auth_cidr_addresses'] = ['<primary_site_ip>/32', '<secondary_site_ip>/32']
      ```

1. PostgreSQLが再起動され、プライベートアドレスでリッスンするまで、自動データベースの移行を一時的に無効にします。`/etc/gitlab/gitlab.rb`で、`gitlab_rails['auto_migrate']`をfalseに設定します:

   ```ruby
   ## Disable automatic database migrations
   gitlab_rails['auto_migrate'] = false
   ```

1. これらの変更を適用するには、GitLabを再設定し、PostgreSQLを再起動します:

   ```shell
   gitlab-ctl reconfigure
   gitlab-ctl restart postgresql
   ```

1. 移行を再度有効にするには、`/etc/gitlab/gitlab.rb`を編集し、`gitlab_rails['auto_migrate']`を`true`に変更します:

   ```ruby
   gitlab_rails['auto_migrate'] = true
   ```

   ファイルを保存して、GitLabを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

   PostgreSQLサーバーは、リモート接続を受け入れるようにセットアップされています

1. `netstat -plnt | grep 5432`を実行して、PostgreSQLがポート`5432`でプライマリサイトのプライベートアドレスをリッスンしていることを確認します。

1. GitLabを再設定すると、証明書が自動的に生成されました。この証明書は、PostgreSQLトラフィックを盗聴者から保護するために自動的に使用されます。アクティブな（「中間者」）攻撃者から保護するには、証明書をセカンダリサイトにコピーします:

   1. プライマリサイトで`server.crt`のコピーを作成します:

      ```shell
      cat ~gitlab-psql/data/server.crt
      ```

   1. セカンダリサイトを設定するときのために出力を保存します。証明書は機密データではありません。

   この証明書は、汎用的な`PostgreSQL`共通名で作成されます。ホスト名が一致しないエラーを防ぐには、データベースをレプリケートする際に`verify-ca`モードを使用する必要があります。

### セカンダリサーバーの設定 {#configure-the-secondary-server}

1. GitLabのセカンダリサイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. [PostgreSQLの自動アップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)して、GitLabのアップグレード時に意図しないダウンタイムが発生するのを防ぎます。[GeoでPostgreSQLをアップグレードする際の既知の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのアップグレードは計画的に実行する必要があります。その結果、今後、PostgreSQLのアップグレードが定期的なメンテナンス作業の一部であることを確認してください。

1. サイトが設定される前にコマンドが実行されないようにするには、アプリケーションサーバーとSidekiqを停止します:

   ```shell
   gitlab-ctl stop puma
   gitlab-ctl stop sidekiq
   ```

1. プライマリサイトのPostgreSQLサーバーへの[TCP接続](../../raketasks/maintenance.md)を確認します:

   ```shell
   gitlab-rake gitlab:tcp_check[<primary_site_ip>,5432]
   ```

   この手順が失敗した場合は、間違ったIPアドレスを使用しているか、ファイアウォールがサイトへのアクセスを妨げている可能性があります。IPアドレスを確認し、パブリックアドレスとプライベートアドレスの違いに注意してください。ファイアウォールが存在する場合は、セカンダリサイトがポート5432でプライマリサイトに接続できることを確認します。

1. セカンダリサイトで、`server.crt`というファイルを作成し、プライマリサイトを設定したときに作成した証明書のコピーを追加します。

   ```shell
   editor server.crt
   ```

1. セカンダリサイトでPostgreSQL TLS検証をセットアップするには、`server.crt`をインストールします:

   ```shell
   install \
      -D \
      -o gitlab-psql \
      -g gitlab-psql \
      -m 0400 \
      -T server.crt ~gitlab-psql/.postgresql/root.crt
   ```

   PostgreSQLは、TLS接続を検証する際に、この正確な証明書のみを認識するようになりました。証明書は、プライベートキーへのアクセス権を持つユーザーがレプリケートできます。このキーは、プライマリサイトにのみ存在します。

1. `gitlab-psql`ユーザーがプライマリサイトのデータベースに接続できることをテストします。デフォルトのLinuxパッケージ名は`gitlabhq_production`です:

    {{< tabs >}}

    {{< tab title="Linuxパッケージ" >}}

    ```shell
    sudo \
        -u gitlab-psql /opt/gitlab/embedded/bin/psql \
        --list \
        -U gitlab_replicator \
        -d "dbname=gitlabhq_production sslmode=verify-ca" \
        -W \
        -h <primary_site_ip>
    ```

    {{< /tab >}}

    {{< tab title="Docker" >}}

    ```shell
    docker exec -it <container_name> su - gitlab-psql -c '/opt/gitlab/embedded/bin/psql \
        --list \
        -U gitlab_replicator \
        -d "dbname=gitlabhq_production sslmode=verify-ca" \
        -W \
        -h <primary_site_ip>'
    ```

    {{< /tab >}}

    {{< /tabs >}}

   プロンプトが表示されたら、`gitlab_replicator`ユーザー用に設定した平文パスワードを入力します。すべてが正しく動作していれば、プライマリサイトのデータベースのリストが表示されます。

1. `/etc/gitlab/gitlab.rb`を編集し、ロールを`geo_secondary_role`に設定します:

   ```ruby
   ##
   ## Geo Secondary role
   ## - configure dependent flags automatically to enable Geo
   ##
   roles(['geo_secondary_role'])
   ```

   詳細については、[Geoロール](https://docs.gitlab.com/omnibus/roles/#gitlab-geo-roles)を参照してください。

1. PostgreSQLを設定するには、`/etc/gitlab/gitlab.rb`を編集して以下を追加します:

   ```ruby
   ##
   ## Secondary address
   ## - replace '<secondary_site_ip>' with the public or VPC address of your Geo secondary site
   ##
   postgresql['listen_address'] = '<secondary_site_ip>'
   postgresql['md5_auth_cidr_addresses'] = ['<secondary_site_ip>/32']

   ##
   ## Database credentials password (defined previously in primary site)
   ## - replicate same values here as defined in primary site
   ##
   postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
   postgresql['sql_user_password'] = '<md5_hash_of_your_db_password>'
   gitlab_rails['db_password'] = '<your_db_password_here>'
   ```

   IPアドレスを、ネットワーク設定に適したアドレスに置き換えてください。

1. [セカンダリサイトの完全な設定](#complete-secondary-site)から設定例をコピーします。

1. 変更を適用するには、ファイルを保存してGitLabを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

1. IPアドレスの変更を適用するには、PostgreSQLを再起動します:

   ```shell
   gitlab-ctl restart postgresql
   ```

### データベースのレプリケート {#replicate-the-database}

セカンダリサイトのデータベースを、プライマリサイトのデータベースに接続します。以下のスクリプトを使用して、データベースをレプリケートし、ストリーミングレプリケーションに必要なファイルを作成できます。

スクリプトは、デフォルトのLinuxパッケージディレクトリを使用します。デフォルトを変更した場合は、以下のスクリプトのディレクトリ名とパス名を独自の名前に置き換えます。

{{< alert type="warning" >}}

レプリケーションスクリプトは、セカンダリサイトでのみ実行してください。このスクリプトは、`pg_basebackup`を実行する前にすべてのPostgreSQLデータを削除するため、データが失われる可能性があります。

{{< /alert >}}

データベースをレプリケートするには:

1. GitLabのセカンダリサイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. レプリケーションスロット名として使用するセカンダリサイトの[データベースに適した名前](https://www.postgresql.org/docs/16/warm-standby.html#STREAMING-REPLICATION-SLOTS-MANIPULATION)を選択します。たとえば、ドメインが`secondary.geo.example.com`の場合、スロット名として`secondary_example`を使用します。レプリケーションスロット名には、小文字、数字、アンダースコア文字のみを含める必要があります。

1. 次のコマンドを実行して、データベースをバックアップおよびリストアし、レプリケーションを開始します。

   {{< alert type="warning" >}}

   各Geoセカンダリサイトには、独自のレプリケーションスロット名が必要です。2つのセカンダリ間で同じスロット名を使用すると、PostgreSQLレプリケーションが中断されます。

   {{< /alert >}}

   ```shell
   gitlab-ctl replicate-geo-database \
      --slot-name=<secondary_site_name> \
      --host=<primary_site_ip> \
      --sslmode=verify-ca
   ```

   プロンプトが表示されたら、`gitlab_replicator`にセットアップした平文パスワードを入力します。

レプリケーションプロセスが完了しました。

## 新しいセカンダリサイトの設定 {#configure-a-new-secondary-site}

初期レプリケーションプロセスが完了したら、セカンダリサイトで次の項目の設定に進みます。

### 承認されたSSHキーの高速検索 {#fast-lookup-of-authorized-ssh-keys}

ドキュメントに従って、[承認されたSSHキーの高速ルックアップを設定](../../operations/fast_ssh_key_lookup.md)します。

高速ルックアップは[Geoに必須](../../operations/fast_ssh_key_lookup.md#fast-lookup-is-required-for-geo)です。

{{< alert type="note" >}}

認証はプライマリサイトによって処理されます。セカンダリサイトのカスタム認証はセットアップしないでください。**管理者**エリアへのアクセスが必要な変更は、プライマリサイトで行う必要があります。セカンダリサイトは読み取り専用コピーであるためです。

{{< /alert >}}

### シークレットなGitLabの値を手動でレプリケート {#manually-replicate-secret-gitlab-values}

GitLabは、`/etc/gitlab/gitlab-secrets.json`に多数のシークレット値を保存します。このJSONファイルは、各サイトノード間で同じである必要があります。すべてのセカンダリサイトでシークレットファイルを手動でレプリケートする必要がありますが、[イシュー3789](https://gitlab.com/gitlab-org/gitlab/-/issues/3789)ではこの動作を変更することが提案されています。

1. プライマリサイトのRailsノードにSSHで接続し、以下のコマンドを実行します:

   ```shell
   sudo cat /etc/gitlab/gitlab-secrets.json
   ```

   これにより、レプリケートする必要があるシークレットがJSON形式で表示されます。

1. Geoのセカンダリサイトの各ノードにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. 既存のシークレットのバックアップを作成します:

   ```shell
   mv /etc/gitlab/gitlab-secrets.json /etc/gitlab/gitlab-secrets.json.`date +%F`
   ```

1. プライマリサイトのRailsノードから各セカンダリサイトノードに`/etc/gitlab/gitlab-secrets.json`をコピーします。ノード間でファイルの内容をコピーアンドペーストすることもできます:

   ```shell
   sudo editor /etc/gitlab/gitlab-secrets.json

   # paste the output of the `cat` command you ran on the primary
   # save and exit
   ```

1. ファイルの権限が正しいことを確認してください:

   ```shell
   chown root:root /etc/gitlab/gitlab-secrets.json
   chmod 0600 /etc/gitlab/gitlab-secrets.json
   ```

1. 変更を適用するには、すべてのRails、Sidekiq、およびGitalyのセカンダリサイトノードを再設定します:

   ```shell
   gitlab-ctl reconfigure
   gitlab-ctl restart
   ```

### プライマリサイトのSSHホストキーを手動でレプリケート {#manually-replicate-the-primary-site-ssh-host-keys}

1. セカンダリサイトの各ノードにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. 既存のSSHホストキーをバックアップします:

   ```shell
   find /etc/ssh -iname 'ssh_host_*' -exec cp {} {}.backup.`date +%F` \;
   ```

1. プライマリサイトからOpenSSHホストキーをコピーします。

   - SSHトラフィックを提供するプライマリサイトノードの1つにrootとしてアクセスできる場合（通常は、メインのGitLab Railsアプリケーションノード）:

     ```shell
     # Run this from the secondary site, change `<primary_site_fqdn>` for the IP or FQDN of the server
     scp root@<primary_node_fqdn>:/etc/ssh/ssh_host_*_key* /etc/ssh
     ```

   - `sudo`権限を持つユーザーを通じてのみアクセスできる場合:

     ```shell
     # Run this from the node on your primary site:
     sudo tar --transform 's/.*\///g' -zcvf ~/geo-host-key.tar.gz /etc/ssh/ssh_host_*_key*

     # Run this on each node on your secondary site:
     scp <user_with_sudo>@<primary_site_fqdn>:geo-host-key.tar.gz .
     tar zxvf ~/geo-host-key.tar.gz -C /etc/ssh
     ```

1. セカンダリサイトの各ノードについて、ファイルの権限が正しいことを確認します:

   ```shell
   chown root:root /etc/ssh/ssh_host_*_key*
   chmod 0600 /etc/ssh/ssh_host_*_key
   ```

1. キーのフィンガープリントの一致を確認するには、各サイトのプライマリノードとセカンダリノードの両方で次のコマンドを実行します:

   ```shell
   for file in /etc/ssh/ssh_host_*_key; do ssh-keygen -lf $file; done
   ```

   次のような出力が得られるはずです:

   ```shell
   1024 SHA256:FEZX2jQa2bcsd/fn/uxBzxhKdx4Imc4raXrHwsbtP0M root@serverhostname (DSA)
   256 SHA256:uw98R35Uf+fYEQ/UnJD9Br4NXUFPv7JAUln5uHlgSeY root@serverhostname (ECDSA)
   256 SHA256:sqOUWcraZQKd89y/QQv/iynPTOGQxcOTIXU/LsoPmnM root@serverhostname (ED25519)
   2048 SHA256:qwa+rgir2Oy86QI+PZi/QVR+MSmrdrpsuH7YyKknC+s root@serverhostname (RSA)
   ```

   出力は両方のノードで同一である必要があります。

1. 既存のプライベートキーに正しいパブリックキーがあることを確認します:

   ```shell
   # This will print the fingerprint for private keys:
   for file in /etc/ssh/ssh_host_*_key; do ssh-keygen -lf $file; done

   # This will print the fingerprint for public keys:
   for file in /etc/ssh/ssh_host_*_key.pub; do ssh-keygen -lf $file; done
   ```

   パブリックキーとプライベートキーのコマンドの出力は、同じフィンガープリントを生成する必要があります。

1. セカンダリサイトの各ノードについて、`sshd`を再起動します:

   ```shell
   # Debian or Ubuntu installations
   sudo service ssh reload

   # CentOS installations
   sudo service sshd reload
   ```

1. SSHがまだ機能していることを確認するには、新しいターミナルから、GitLabのセカンダリサーバーにSSHで接続します。接続できない場合は、正しい権限があることを確認してください。

### セカンダリサイトを追加します {#add-the-secondary-site}

1. セカンダリサイトの各RailsおよびSidekiqノードにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. `/etc/gitlab/gitlab.rb`を編集し、サイトの一意の名前を追加します。

   ```ruby
   ##
   ## The unique identifier for the Geo site. See
   ## https://docs.gitlab.com/ee/administration/geo_sites.html#common-settings
   ##
   gitlab_rails['geo_node_name'] = '<site_name_here>'
   ```

   次の手順のために、一意の名前を保存します。

1. 変更を適用するには、セカンダリサイトの各RailsおよびSidekiqノードを再設定します。

   ```shell
   gitlab-ctl reconfigure
   ```

1. プライマリノードのGitLabインスタンスに移動します:
   1. 左側のサイドバーの下部で、**管理者**を選択します。
   1. **Geo** > **サイト**を選択します。
   1. **サイトを追加**を選択します。

      ![3つの入力フィールドを使用して新しいサイトを追加するフォーム:名前、外部URL、および内部URL（オプション）。](img/adding_a_secondary_v15_8.png)

   1. **名前**に、`/etc/gitlab/gitlab.rb`の`gitlab_rails['geo_node_name']`の値を入力します。値は完全に一致する必要があります。
   1. **外部URL**に、`/etc/gitlab/gitlab.rb`の`external_url`の値を入力します。一方の値が`/`で終わり、もう一方の値が終わっていなくても問題ありません。それ以外の場合、値は正確に一致する必要があります。
   1. オプション。**内部URL (オプション)**に、プライマリGeoサイトの内部URLを入力します。
   1. オプション。セカンダリサイトでレプリケーションするグループまたはストレージシャードを選択します。すべてレプリケーションするには、フィールドを空白のままにします。[選択的同期](../replication/selective_synchronization.md)を参照してください。
   1. **変更を保存**を選択します。
1. SSHでセカンダリサイトの各RailsノードとSidekiqノードに接続し、サービスを再起動します:

   ```shell
   gitlab-ctl restart
   ```

1. 次を実行して、Geoのセットアップに関する一般的なイシューがあるかどうかを確認します:

   ```shell
   gitlab-rake gitlab:geo:check
   ```

   いずれかのチェックに失敗した場合は、[トラブルシューティングドキュメント](../replication/troubleshooting/_index.md)を参照してください。

1. セカンダリサイトに到達できることを確認するには、プライマリサイトのRailsまたはSidekiqサーバーにSSHで接続し、rootとしてサインインします:

   ```shell
   gitlab-rake gitlab:geo:check
   ```

   いずれかのチェックに失敗した場合は、[トラブルシューティングドキュメント](../replication/troubleshooting/_index.md)を確認してください。

セカンダリサイトがGeo管理ページに追加され、再起動されると、サイトはバックフィルと呼ばれるプロセスで、プライマリサイトから不足しているデータのレプリケーションを自動的に開始します。

一方、プライマリサイトは各セカンダリサイトに変更を通知し始め、セカンダリサイトはすぐに通知に対応できます。

セカンダリサイトが実行中で、アクセスできることを確認してください。プライマリサイトで使用したのと同じ認証情報でセカンダリサイトにサインインできます。

### HTTP/HTTPSおよびSSH経由でのGitアクセスを有効にする {#enable-git-access-over-httphttps-and-ssh}

GeoはHTTP/HTTPS経由でリポジトリを同期するため、このクローンメソッドを有効にする必要があります。これはデフォルトで有効になっています。既存のサイトをGeoに変換する場合は、クローンメソッドが有効になっていることを確認する必要があります。

プライマリサイトで次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. SSH経由でGitを使用する場合:
   1. **有効なGitアクセスプロトコル**が**SSHとHTTP(S)の両方**に設定されていることを確認します。
   1. プライマリサイトとセカンダリサイトの両方で、[データベース内の許可されたSSHキーの高速キー検索](../../operations/fast_ssh_key_lookup.md)に従ってください。
1. SSH経由でGitを使用しない場合は、**有効なGitアクセスプロトコル**を**HTTP(S)のみ**に設定します。

### セカンダリサイトの適切な機能を検証する {#verify-proper-functioning-of-the-secondary-site}

プライマリサイトで使用したのと同じ認証情報でセカンダリサイトにサインインできます。

サインイン後:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **Geo** > **サイト**を選択します。
1. サイトがセカンダリGeoサイトとして正しく識別され、Geoが有効になっていることを確認します。

最初のレプリケーションには時間がかかる場合があります。ブラウザで、プライマリサイトの**Geoサイト**サイトダッシュボードから、各Geoサイトの同期プロセスをモニタリングできます。

![同期ステータスを表示するGeoサイトダッシュボード。](img/geo_dashboard_v14_0.png)

## 設定例 {#example-configurations}

### プライマリサイトを完了する {#complete-primary-site}

<!-- If you update this configuration example, also update the example in two_single_node_external_services.md -->

この完全な`gitlab.rb`の設定例は、Geoプライマリサイトに使用されます:

```ruby
# Primary site configuration example

## Geo Primary role
roles(['geo_primary_role'])

## The unique identifier for the Geo site
gitlab_rails['geo_node_name'] = 'headquarters'

## External URL
external_url 'https://gitlab.example.com'

## Database configuration
gitlab_rails['db_password'] = 'your_database_password_here'
postgresql['sql_user_password'] = 'md5_hash_of_your_database_password'
postgresql['sql_replication_password'] = 'md5_hash_of_your_replication_password'

## PostgreSQL network configuration
postgresql['listen_address'] = '10.0.1.10'  # Primary site IP
postgresql['md5_auth_cidr_addresses'] = ['10.0.1.10/32', '10.0.2.10/32']  # Primary and secondary IPs

## Disable automatic migrations (handled centrally, and to avoid unplanned downtime)
gitlab_rails['auto_migrate'] = false

## SSL/TLS configuration
nginx['listen_port'] = 80
nginx['listen_https'] = false
letsencrypt['enable'] = false

## Object Storage configuration (optional)
gitlab_rails['object_store']['enabled'] = true
gitlab_rails['object_store']['connection'] = {
  'provider' => 'AWS',
  'region' => 'us-east-1',
  'aws_access_key_id' => 'your_access_key',
  'aws_secret_access_key' => 'your_secret_key'
}

## Monitoring configuration (optional)
node_exporter['listen_address'] = '0.0.0.0:9100'
gitlab_workhorse['prometheus_listen_addr'] = '0.0.0.0:9229'
gitlab_rails['monitoring_whitelist'] = ['127.0.0.0/8', '10.0.0.0/8']

## Gitaly configuration
gitaly['configuration'] = {
  prometheus_listen_addr: '0.0.0.0:9236',
}
```

### セカンダリサイトを完了する {#complete-secondary-site}

<!-- If you update this configuration example, also update the example in two_single_node_external_services.md -->

この完全な`gitlab.rb`の設定例は、Geoセカンダリサイト用です:

```ruby
# Secondary site configuration example

## Geo Secondary role
roles(['geo_secondary_role'])

## The unique identifier for the Geo site
gitlab_rails['geo_node_name'] = 'location-2'

## External URL (can be the same as primary for unified URL setup)
external_url 'https://gitlab.example.com'

## Database configuration
gitlab_rails['db_password'] = 'your_database_password_here'
postgresql['sql_user_password'] = 'md5_hash_of_your_database_password'
postgresql['sql_replication_password'] = 'md5_hash_of_your_replication_password'

## PostgreSQL network configuration
postgresql['listen_address'] = '10.0.2.10'  # Secondary site IP
postgresql['md5_auth_cidr_addresses'] = ['10.0.2.10/32']

## SSL/TLS configuration
nginx['listen_port'] = 80
nginx['listen_https'] = false
letsencrypt['enable'] = false

## Object Storage configuration (must match primary)
gitlab_rails['object_store']['enabled'] = true
gitlab_rails['object_store']['connection'] = {
  'provider' => 'AWS',
  'region' => 'us-east-1',
  'aws_access_key_id' => 'your_access_key',
  'aws_secret_access_key' => 'your_secret_key'
}

## Monitoring configuration (optional)
node_exporter['listen_address'] = '0.0.0.0:9100'
gitlab_workhorse['prometheus_listen_addr'] = '0.0.0.0:9229'
gitlab_rails['monitoring_whitelist'] = ['127.0.0.0/8', '10.0.0.0/8']

## Gitaly configuration
gitaly['configuration'] = {
  prometheus_listen_addr: '0.0.0.0:9236',
}
```

## 関連トピック {#related-topics}

- [トラブルシューティング](../replication/troubleshooting/_index.md)Geo
