---
stage: None - Facilitated functionality, see https://handbook.gitlab.com/handbook/product/categories/#facilitated-functionality
group: Unassigned - Facilitated functionality, see https://handbook.gitlab.com/handbook/product/categories/#facilitated-functionality
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabインスタンスを管理し、UIで機能を設定します。
title: GitLab管理者エリア
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**管理者**エリアは、GitLab Self-Managedインスタンスの機能を管理および設定するためのWeb UIを提供します。管理者として**管理者**エリアにアクセスするには、次の手順に従います:

- GitLab 18.5以降、[新しいナビゲーションをオンにした](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合:
  - 右上隅で、アバターを選択し、**管理者**を選択します。
  - 上部のバーで、**検索または移動先**を選択し、**管理者エリア**を選択します。
- GitLab 17.3以降: 左側のサイドバーの下部で、**管理者**を選択します。
- GitLab 16.7以降: 左側のサイドバーの下部で、**管理者エリア**を選択します。
- GitLab 16.1以降: 左側のサイドバーで、**検索または移動先**を選択し、次に**管理者**を選択します。
- GitLab 16.0以前: 上部のバーで、**Main menu**（メインメニュー） > **管理者**を選択します。

GitLabインスタンスで管理者モードを使用している場合、**管理者**を表示するには、[セッションの管理者モードを有効にする](settings/sign_in_restrictions.md#turn-on-admin-mode-for-your-session)必要があります。

{{< alert type="note" >}}

**管理者**エリアにアクセスできるのは、GitLab Self-ManagedまたはGitLab Dedicatedの管理者のみです。GitLab.comでは、**管理者**エリア機能は利用できません。

{{< /alert >}}

## プロジェクトを管理する {#administering-projects}

{{< history >}}

- 新しい外観が、GitLab 18.2で`admin_projects_vue`という名前の[フラグ](feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/17782)されました。デフォルトでは無効になっています。
- GitLab 18.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/549452)になりました。機能フラグ`admin_projects_vue`は削除されました。

{{< /history >}}

GitLabインスタンス内のすべてのプロジェクトを管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **プロジェクト**を選択します。ページには、各プロジェクトの以下が表示されます:

   - 名前
   - 説明
   - 表示レベル
   - ロール
   - トピック
   - ステータス
   - ストレージサイズ
   - スターの数
   - フォーク数
   - マージリクエスト数
   - Issue数

1. （オプション）タブを選択します:

   - **アクティブ**は、すべて有効なプロジェクトを表示します。
   - **非アクティブ**は、アーカイブされているか、削除保留中のプロジェクトを表示します。

1. （オプション）フィルターを組み合わせて、目的のプロジェクトを検索します。絞り込み条件は以下のとおりです:

   - 名前。3文字以上入力してください。
   - 表示レベル（パブリック、内部、またはプライベート）。
   - プログラミング言語。
   - グループまたはユーザーネームスペース。
   - オーナーロールを持つプロジェクト。

1. （オプション）並べ替え順を変更するには、並べ替えのドロップダウンリストを選択し、目的の順序を選択します。使用可能な並べ替えオプションは次のとおりです:

   - 名前
   - 作成日
   - 更新日
   - お気に入り
   - ストレージサイズ

### プロジェクトを編集する {#edit-a-project}

**管理者**エリアのプロジェクトページからプロジェクトの名前または説明を編集するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **プロジェクト**を選択します。
1. 編集するプロジェクトを見つけ、**アクション**（{{< icon name="ellipsis_v" >}}）> **編集**を選択します。
1. **プロジェクト名**または**プロジェクトの説明**を編集します。
1. **変更を保存**を選択します。

### プロジェクトを削除する {#delete-a-project}

プロジェクトを削除するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **プロジェクト**を選択します。
1. 編集するプロジェクトを見つけ、**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
1. 確認ダイアログで、**はい、プロジェクトを削除します**を選択します。

## ユーザーを管理する {#administering-users}

{{< history >}}

- ユーザーのフィルタリングは、GitLab 17.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/238183)されました。

{{< /history >}}

**管理者**エリアのユーザーページには、各ユーザーに関する次の情報が表示されます:

- ユーザー名
- メールアドレス
- プロジェクトメンバーシップ数
- グループメンバーシップ数
- アカウント作成日
- 最後のアクティビティーの日付

**管理者**エリアのユーザーページからすべてのユーザーを管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. （オプション）並べ替え順（デフォルトはユーザー名）を変更するには、次の手順に従います:

   1. 並べ替えのドロップダウンリストを選択します。
   1. 目的の順序を選択します。

1. （オプション）ユーザー検索ボックスを使用して、次の条件でユーザーを検索およびフィルタリングします:

   - ユーザーの**access level**（アクセスレベル）。
   - **2要素認証**が有効/無効。
   - ユーザーの**state**（状態）。
   - ユーザーの**type**（タイプ）が[プレースホルダー](../user/project/import/_index.md#placeholder-users)であるかどうか。

1. （オプション）ユーザー検索ボックスにテキストを入力し、<kbd>Enter</kbd>キーを押します。この大文字と小文字を区別しないテキスト検索では、名前、ユーザー名、メールアドレスに部分一致が適用されます。

ユーザーを編集するには、ユーザーの行を見つけて**編集**を選択します。

### ユーザーを削除する {#delete-a-user}

**管理者**エリアのユーザーページから、ユーザーを削除するか、ユーザーとそのコントリビュートを削除するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. 削除するユーザーを見つけます。その行で、**ユーザー管理**（{{< icon name="ellipsis_v">}}）を選択し、目的のオプションを選択します。

### ユーザーの代理 {#user-impersonation}

管理者は、他の管理者を含む他のユーザーの代理となることができます。これにより、GitLabでユーザーに表示される内容を確認し、ユーザーに代わってアクションを実行できます。

ユーザーの代理となるには、次の手順に従います:

- UIを使用する場合は、以下のとおりです:
  1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
  1. 左側のサイドバーで、**概要** > **ユーザー**を選択します。
  1. ユーザーのリストからユーザーを選択します。
  1. 右上で、**なりすまし**を選択します。
  1. インパーソネーションを停止するには、左側のサイドバーの上部にある**代理を停止**（{{< icon name="incognito">}}）を選択します。
- APIを使用する場合は、[代理トークン](../api/rest/authentication.md#impersonation-tokens)を使用します。

すべての代理アクティビティーは、[監査イベントとしてキャプチャ](compliance/audit_event_reports.md#user-impersonation)されます。デフォルトでは、代理は有効になっています。GitLabの設定で[代理を無効](../api/rest/authentication.md#disable-impersonation)にすることもできます。

### ユーザーアイデンティティ {#user-identities}

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

{{< history >}}

- GitLab 15.3で、ユーザーのSCIMアイデンティティの表示が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/294608)されました。

{{< /history >}}

認証プロバイダーを使用している場合、管理者はユーザーのアイデンティティを確認できます。このページでは、SCIMアイデンティティを含むユーザーのアイデンティティが表示されます。この情報を使用して、SCIM関連の問題を解決したり、アカウントに使用されているアイデンティティを確認したりできます。

この設定を行うには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. ユーザーのリストからユーザーを選択します。
1. **識別子**を選択します。

### ユーザー権限をエクスポートする {#user-permission-export}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ユーザー権限をエクスポートすると、エクスポートされた情報には、ユーザーがグループやプロジェクトに対して持つ直接的なメンバーシップが表示されます。これには次のデータが含まれます。ただし、最初の100,000人のユーザーに制限されています:

- ユーザー名
- メール
- 種類
- パス
- アクセスレベル（[プロジェクト](../user/permissions.md#project-members-permissions)および[グループ](../user/permissions.md#group-members-permissions)）
- 最後のアクティビティーの日付。この列に入力されるアクティビティーのリストについては、[Users APIのドキュメント](../api/users.md#list-a-users-activity)を参照してください。

GitLabインスタンスにおけるすべてのアクティブユーザーのユーザー権限をエクスポートするには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. 右上で、**Export permissions as CSV**（CSV形式でエクスポートする）（{{< icon name="export" >}}）を選択します。

### ユーザー統計 {#users-statistics}

**ユーザー統計**ページには、ロールごとのユーザーアカウントの概要が表示されます。この統計は毎日計算されます。最後の更新以降に行われたユーザーの変更は反映されません。以下の合計も含まれます:

- 請求対象ユーザー
- ブロックされたユーザー
- 総ユーザー数

GitLabの請求は、[請求対象ユーザー](../subscriptions/manage_users_and_seats.md#billable-users)の数に基づいています。

### ユーザーにメールアドレスを追加する {#add-email-to-user}

メールアドレスをユーザーアカウントに手動で追加するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. ユーザーを見つけて選択します。
1. **編集**を選択します。
1. **メール**に、新しいメールアドレスを入力します。これにより、新しいメールアドレスがユーザーに追加され、以前のメールアドレスがセカンダリに設定されます。
1. **変更を保存**を選択します。

## ユーザーの世代 {#user-cohorts}

[世代](user_cohorts.md)タブには、新しいユーザーの月別の世代とその経時的なアクティビティーが表示されます。

## ユーザーがトップレベルグループを作成できないようにする {#prevent-a-user-from-creating-top-level-groups}

管理者は、特定のユーザーがトップレベルグループを作成できないようにすることができます。これらのユーザーは、サブグループを作成し、既存の組織構造で共同作業できます。

ユーザーがトップレベルグループを作成できないようにするには、次のようにします:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. ユーザーを見つけて選択します。
1. **編集**を選択します。
1. **トップレベルグループを作成できる**チェックボックスをオフにします。
1. **変更を保存**を選択します。

この設定をオフにした場合:

- ユーザーはトップレベルグループを作成できません。
- ユーザーは、グループの[サブグループ作成権限](../user/group/subgroups/_index.md#change-who-can-create-subgroups)に応じて、少なくともメンテナーロールを持つグループにサブグループを作成できます。

## グループを管理する {#administering-groups}

{{< history >}}

- 新しい外観が、GitLab 18.2で`admin_groups_vue`という名前の[フラグ](feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/17783)されました。デフォルトでは無効になっています。
- GitLab 18.5の[GitLab.com、GitLab Dedicated、およびGitLab Self-Managedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/553229)。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

GitLabインスタンス内のすべてのグループを管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **グループ**を選択します。ページには、各グループの以下が表示されます:

   - 名前
   - 説明
   - 表示レベル
   - ロール
   - ステータス
   - ストレージサイズ
   - サブグループ数
   - プロジェクト数
   - メンバー数

1. （オプション）タブを選択します:

   - **アクティブ**は、すべて有効なグループを表示します。
   - **非アクティブ**は、削除保留中のグループを表示します。

1. （オプション）並べ替え順を変更するには、並べ替えのドロップダウンリストを選択し、目的の順序を選択します。使用可能な並べ替えオプションは次のとおりです:

   - 名前
   - 作成日
   - 更新日
   - [ストレージサイズ](../user/storage_usage_quotas.md)

1. （オプション）グループを名前でフィルターするには、検索ボックスに3文字以上入力します。
1. （オプション）[新しいグループを作成](../user/group/_index.md#create-a-group)するには、**新規グループ**を選択します。

### グループの編集 {#edit-a-group}

**管理者**エリアのグループページからグループの名前または説明を編集するには、次の手順を実行します:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **グループ**を選択します。
1. 編集するグループを見つけ、**アクション**（{{< icon name="ellipsis_v" >}}）> **編集**を選択します。
1. **グループ名**または**Group description**を編集します。
1. **変更を保存**を選択します。

### グループを削除する {#delete-a-group}

グループを削除するには、次の手順を実行します:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **グループ**を選択します。
1. 編集するグループを見つけ、**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
1. 確認ダイアログで、**確認**を選択します。

## トピックを管理する {#administering-topics}

{{< history >}}

- GitLab 15.5でトピックのマージが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/366884)されました。

{{< /history >}}

[トピック](../user/project/project_topics.md)を使用して、プロジェクトを分類し、類似のプロジェクトを見つけることができます。

### すべてのトピックを表示する {#view-all-topics}

GitLabインスタンス内のすべてのトピックを表示するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。

このページにはトピックごとに、トピック名と、そのトピックでラベル付けされたプロジェクトの数が表示されます。

### トピックを検索する {#search-for-topics}

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。
1. 検索ボックスに検索条件を入力します。トピック検索では大文字と小文字は区別されず、部分一致が適用されます。

### トピックを作成する {#create-a-topic}

トピックを作成するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。
1. **新規トピック**を選択します。
1. **トピックslug(名前)**と**トピックタイトル**を入力します。
1. （オプション）**説明**を入力し、**トピックのアバター**を追加します。
1. **変更を保存**を選択します。

作成されたトピックが、**トピックを見る**ページに表示されます。

割り当てられたトピックは、そのプロジェクトにアクセスできるユーザーのみに表示されますが、GitLabインスタンスに存在するトピックは誰でも確認できます。トピック名に機密情報を含めないでください。

### トピックを編集する {#edit-a-topic}

トピックの名前、タイトル、説明、アバターはいつでも編集できます。トピックを編集するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。
1. そのトピックの行で**編集**を選択します。
1. トピックslug（名前）、タイトル、説明、またはアバターを編集します。
1. **変更を保存**を選択します。

### トピックを削除する {#remove-a-topic}

トピックが不要になった場合は、完全に削除できます。トピックを削除するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。
1. トピックを削除するには、そのトピックの行で**削除**を選択します。

### トピックをマージする {#merge-topics}

あるトピックに割り当てられているすべてのプロジェクトを、別のトピックに移動できます。その後、移動元のトピックは完全に削除されます。マージ済みトピックが削除された後、復元することはできません。

トピックをマージするには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **トピック**を選択します。
1. **マージトピック**を選択します。
1. **ソーストピック**ドロップダウンリストから、マージして削除するトピックを選択します。
1. **ターゲットトピック**ドロップダウンリストから、ソーストピックのマージ先となるトピックを選択します。
1. **マージ**を選択します。

## Gitalyサーバーを管理する {#administering-gitaly-servers}

**管理者**エリアの**Gitalyサーバー**ページから、GitLabインスタンス内のすべてのGitalyサーバーを一覧表示できます。詳細については、[Gitaly](gitaly/_index.md)を参照してください。

**Gitalyサーバー**ページにアクセスするには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **Gitalyサーバー**を選択します。

このページには、各Gitalyサーバーに関する次の情報が含まれています:

| フィールド          | 説明 |
|----------------|-------------|
| ストレージ        | リポジトリのストレージ |
| アドレス        | Gitalyサーバーがリッスンしているネットワークアドレス |
| サーバーバージョン | Gitalyバージョン |
| Gitのバージョン    | GitalyサーバーにインストールされているGitのバージョン |
| 最新     | Gitalyサーバーのバージョンが利用可能な最新バージョンであるかどうかを示します。緑色の点は、サーバーが最新であることを示します。 |

## 組織を管理する {#administering-organizations}

{{< history >}}

- GitLab 16.10で`ui_for_organizations`[フラグ](feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/419540)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

GitLab Self-Managedでは、デフォルトでこの機能は使用できません。管理者が`ui_for_organizations`という名前の[機能フラグを有効にする](feature_flags/_index.md)と、この機能を使用できるようになります。GitLab.comとGitLab Dedicatedでは、この機能は使用できません。この機能は本番環境での使用には対応していません。

{{< /alert >}}

**管理者**エリアの組織ページには、デフォルトですべてのプロジェクトが、最終更新日時の降順に表示されます。各プロジェクトの次の情報が表示されます:

- 名前
- ネームスペース
- 説明
- サイズ（最大15分ごとに更新）

このページからGitLabインスタンス内のすべての組織を管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **組織**を選択します。

## CI/CDセクション {#cicd-section}

### Runnerを管理する {#administering-runners}

{{< history >}}

- GitLab 15.8で**概要** > **Runners**から**CI/CD** > **Runners**に[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/340859)しました。

{{< /history >}}

GitLabインスタンス内のすべてのRunnerを管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **CI/CD** > **Runners**を選択します。

各Runnerの次の情報が表示されます:

| 属性    | 説明 |
|--------------|-------------|
| ステータス       | Runnerのステータス。[GitLab 15.1以降](https://gitlab.com/gitlab-org/gitlab/-/issues/22224)では、Ultimateプランの場合、アップグレードステータスを利用できます。 |
| Runnerの詳細 | Runnerに関する情報。部分的なトークンと、Runnerの登録元のコンピューターに関する詳細が含まれます。 |
| バージョン      | GitLab Runnerのバージョン。 |
| ジョブ         | Runnerによって実行されたジョブの合計数。 |
| タグ         | Runnerに関連付けられているタグ。 |
| 最終コンタクト | RunnerがGitLabインスタンスに最後に接続したときのタイムスタンプ。 |

各Runnerを編集、一時停止、削除することもできます。

詳細については、[GitLab Runner](https://docs.gitlab.com/runner/)を参照してください。

#### Runnerを検索およびフィルタリングする {#search-and-filter-runners}

Runnerの説明を検索するには、次の手順に従います:

1. **結果を検索またはフィルタリング**テキストボックスに、検索するRunnerの説明を入力します。
1. <kbd>Enter</kbd>キーを押します。

ステータス、タイプ、タグでRunnerをフィルタリングするには、次の手順に従います:

1. タブを選択するか、**結果を検索またはフィルタリング**テキストボックスを選択します。
1. **種類**を選択するか、**ステータス**または**タグ**でフィルタリングします。
1. 検索条件を選択または入力します。

![ステータスでフィルタリング済みRunnerの属性。](img/index_runners_search_or_filter_v14_5.png)

#### Runnerを一括削除する {#bulk-delete-runners}

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/370241)されました。
- GitLab 15.5で[機能フラグが削除](https://gitlab.com/gitlab-org/gitlab/-/issues/353981)されました。

{{< /history >}}

複数のRunnerを同時に削除するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **概要** > **Runners**を選択します。
1. 削除するRunnerの左側にあるチェックボックスをオンにします。ページ上のすべてのRunnerを選択するには、リストの上にあるチェックボックスをオンにします。
1. **一括削除**を選択します。

### ジョブを管理する {#administering-jobs}

{{< history >}}

- GitLab 15.8で**概要** > **ジョブ**から**CI/CD** > **ジョブ**に[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/386311)しました。

{{< /history >}}

GitLabインスタンス内のすべてのジョブを管理するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオンにしている](../user/interface_redesign.md#turn-new-navigation-on-or-off)場合は、右上隅でアバターを選択し、次に**管理者**を選択します。
1. **CI/CD** > **ジョブ**を選択します。すべてのジョブが、ジョブIDの降順で一覧表示されます。
1. すべてのジョブを一覧表示するには、**すべて**タブを選択します。特定のステータスのジョブのみを一覧表示するには、**保留中**、**実行中**、または**完了**タブを選択します。

各ジョブの次の詳細が表示されます:

| フィールド    | 説明 |
|----------|-------------|
| ステータス   | ジョブのステータス。**成功**、**スキップ済み**、**失敗**のいずれか。              |
| ジョブ      | ジョブ、ブランチ、およびジョブを開始したコミットへの各リンクが含まれます。 |
| パイプライン | 特定のパイプラインへのリンクが含まれます。                               |
| プロジェクト  | ジョブが属するプロジェクトと組織の名前。        |
| Runner   | ジョブの実行に割り当てられたCI Runnerの名前。                      |
| ステージ    | ジョブが`.gitlab-ci.yml`ファイルで宣言されているステージ。              |
| 名前     | `.gitlab-ci.yml`ファイルで指定されたジョブの名前。                   |
| タイミング   | ジョブの所要時間、およびジョブが完了してからの経過時間。                |
| カバレッジ | テストカバレッジの割合。                                           |

## モニタリングセクション {#monitoring-section}

次のトピックでは、**管理者**エリアの**モニタリング**セクションについて説明します。

### システム情報 {#system-information}

{{< history >}}

- GitLab 15.2で相対時間のサポートが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/341248)されました。「アップタイム」統計は「システムの起動日時」に名称変更されました。

{{< /history >}}

**システム情報**ページには、次の統計が表示されます:

| フィールド          | 説明                                       |
|:---------------|:--------------------------------------------------|
| CPU            | 利用可能なCPUコアの数                     |
| メモリ使用状況   | 使用中のメモリと利用可能なメモリの合計         |
| ディスク使用状況     | 使用中のディスク容量と利用可能なディスク容量の合計 |
| システムの起動日時 | GitLabをホストしているシステムが起動した日時。GitLab 15.1以前では、これはアップタイム統計でした。 |

これらの統計は、**システム情報**ページに移動するか、ブラウザでページを更新した場合にのみ更新されます。

### バックグラウンドジョブ {#background-jobs}

**バックグラウンドジョブ**ページには、Sidekiqダッシュボードが表示されます。Sidekiqは、GitLabがバックグラウンドプロセスを実行するために使用します。

Sidekiqダッシュボードには、以下の情報が含まれています:

- 各[ジョブのライフサイクル状態](https://github.com/sidekiq/sidekiq/wiki/Job-Lifecycle)のタブ。
- バックグラウンドジョブの統計の内訳。
- **Processed**（処理済み）ジョブと**失敗**ジョブのライブグラフ（ポーリングの間隔を選択可能）。
- **Processed**（処理済み）ジョブと**失敗**ジョブの履歴グラフ（時間範囲を選択可能）。
- Redisの統計。以下の情報が含まれています:
  - バージョン番号
  - アップタイム（日単位）
  - 接続数
  - 現在のメモリ使用量（MB単位）
  - ピークメモリ使用量（MB単位）

### データベース診断 {#database-diagnostics}

{{< history >}}

- 照合ヘルスチェック[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/555916) GitLab 18.3。
- スキーマヘルスチェック[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199796) GitLab 18.3（インデックス、テーブル、外部キー、およびシーケンスチェックがありません）。
- 誤ったシーケンスオーナーチェックが、GitLab 18.4のスキーマヘルスチェック[に追加されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197521)。

{{< /history >}}

データベース診断ページは、データベースの一般的な問題を検出するための多数のチェックで構成されています:

- [PostgreSQL照合順序の変更](https://gitlab.com/groups/gitlab-org/-/epics/8573)によって引き起こされたインデックスの破損
- [スキーマの不一致](https://gitlab.com/groups/gitlab-org/-/epics/3928)

各チェックを実行するには、チェックの実行ボタンを選択します。実行ボタンを選択すると、チェックからの情報をページにレポートするバックグラウンドジョブがスケジュールされます。

#### 照合ヘルスチェック {#collation-health-check}

照合ヘルスチェックは、破損したインデックスを引き起こすPostgreSQLの問題を検出します。これは通常、PostgreSQLを実行している以前のオペレーティングシステムが、`glibc`バージョン2.28より以前のバージョンを使用している場合に発生します。詳細については、[PostgreSQLのオペレーティングシステムのアップグレード](postgresql/upgrading_os.md)に関するドキュメントを参照してください。

問題は**Corrupted Indexes**セクションにリストされています。問題がある場合は、[破損したインデックスを修復](raketasks/maintenance.md#repair-corrupted-database-indexes)できます。

照合ヘルスチェックは、一般的に影響を受けるテーブルの重複を検出します:

- `ci_refs`
- `ci_resource_groups`
- `environments`
- `merge_request_diff_commit_users`
- `sbom_components`
- `tags`
- `topics`

詳細については、[イシュー505982](https://gitlab.com/gitlab-org/gitlab/-/issues/505982)を参照してください。

ダッシュボードには、[`gitlab:db:collation_checker` Rakeタスク](raketasks/maintenance.md#detect-postgresql-collation-version-mismatches)に表示される同一の情報がリストされます。

#### スキーマヘルスチェック {#schema-health-check}

スキーマヘルスチェックは、データベースの状態をターゲットスキーマと比較し、検出された不一致をリストします。自動スキーマ修復ツールは利用できません。

誤検出に気付いた場合、またはチェックの結果について質問がある場合は、[フィードバックイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues/567561)を参照してください。

### ログ {#logs}

以下のログファイルの内容は、問題を解決するために役立ちます。各ログファイルの内容は、時系列順に表示されます。パフォーマンスの問題を最小限に抑えるため、各ログファイルの最大2,000行が表示されます。

| ログファイル                | 内容 |
|:------------------------|:---------|
| `application_json.log`  | GitLabユーザーアクティビティー |
| `git_json.log`          | GitLabとGitリポジトリ間の失敗したインタラクション |
| `production.log`        | Pumaから受信したリクエストと、それを処理するために実行されたアクション |
| `sidekiq.log`           | バックグラウンドジョブ |
| `repocheck.log`         | リポジトリのアクティビティー |
| `integrations_json.log` | GitLabと統合システム間のアクティビティー |
| `kubernetes.log`        | Kubernetesのアクティビティー |

これらのログファイルとその内容の詳細については、[ログシステム](logs/_index.md)を参照してください。

マルチノードシステムの管理者の混乱を防ぐため、**管理者**エリアのダッシュボードから**ログ**ビューが削除されました。このビューには、マルチノードセットアップの部分的な情報しか表示されません。マルチノードシステムの場合は、ElasticsearchやSplunkなどのサービスにログをインジェストしてください。

### 監査イベント {#audit-events}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**監査イベント**ページには、GitLabサーバーに加えられた変更が一覧表示されます。この情報を使用して、すべての変更を制御、分析、追跡できます。

### 統計 {#statistics}

ダッシュボードの**インスタンスの概要**セクションには、GitLabインスタンスの現在の統計が一覧表示されます。[アプリケーション統計API](../api/statistics.md#get-details-on-current-application-statistics)を使用して、この情報を取得します。

これらの統計は、10,000未満の値については正確な数を示しています。値が10,000以上の場合は、[`TablesampleCountStrategy`](https://gitlab.com/gitlab-org/gitlab/-/blob/master/lib/gitlab/database/count/tablesample_count_strategy.rb?ref_type=heads#L16)および[`ReltuplesCountStrategy`](https://gitlab.com/gitlab-org/gitlab/-/blob/master/lib/gitlab/database/count/reltuples_count_strategy.rb?ref_type=heads)の戦略に基づいて計算され、おおよそのデータを示しています。
