/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.apiimpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.ContextMenuItemManipulator;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.bridge.DataBridge;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.spi.GraphContextMenuItem;
import org.openide.util.Lookup;

public class GraphContextMenu {
    private final VizConfig config = VizController.getInstance().getVizConfig();
    private final AbstractEngine engine = VizController.getInstance().getEngine();
    private final DataBridge dataBridge = VizController.getInstance().getDataBridge();

    public JPopupMenu getMenu() {
        GraphContextMenuItem[] items = this.getGraphContextMenuItems();
        List<NodeModel> selectedNodeModels = this.engine.getSelectedNodes();
        Node[] selectedNodes = new Node[selectedNodeModels.size()];
        int i = 0;
        for (NodeModel nm : selectedNodeModels) {
            selectedNodes[i++] = nm.getNode();
        }
        Graph graph = this.dataBridge.getGraph();
        JPopupMenu contextMenu = new JPopupMenu();
        Integer lastItemType = null;
        for (GraphContextMenuItem item : items) {
            item.setup(graph, selectedNodes);
            if (lastItemType == null) {
                lastItemType = item.getType();
            }
            if (lastItemType.intValue() != item.getType()) {
                contextMenu.addSeparator();
            }
            lastItemType = item.getType();
            if (!item.isAvailable()) continue;
            contextMenu.add(this.createMenuItemFromGraphContextMenuItem(item, graph, selectedNodes));
        }
        return contextMenu;
    }

    public GraphContextMenuItem[] getGraphContextMenuItems() {
        ArrayList items = new ArrayList();
        items.addAll(Lookup.getDefault().lookupAll(GraphContextMenuItem.class));
        this.sortItems(items);
        return items.toArray(new GraphContextMenuItem[0]);
    }

    public JMenuItem createMenuItemFromGraphContextMenuItem(final GraphContextMenuItem item, Graph graph, Node[] nodes) {
        ContextMenuItemManipulator[] subItems = item.getSubItems();
        if (subItems != null && item.canExecute()) {
            JMenu subMenu = new JMenu();
            subMenu.setText(item.getName());
            if (item.getDescription() != null && !item.getDescription().isEmpty()) {
                subMenu.setToolTipText(item.getDescription());
            }
            subMenu.setIcon(item.getIcon());
            Integer lastItemType = null;
            for (ContextMenuItemManipulator subItem : subItems) {
                ((GraphContextMenuItem)subItem).setup(graph, nodes);
                if (lastItemType == null) {
                    lastItemType = subItem.getType();
                }
                if (lastItemType.intValue() != subItem.getType()) {
                    subMenu.addSeparator();
                }
                lastItemType = subItem.getType();
                if (!subItem.isAvailable()) continue;
                subMenu.add(this.createMenuItemFromGraphContextMenuItem((GraphContextMenuItem)subItem, graph, nodes));
            }
            if (item.getMnemonicKey() != null) {
                subMenu.setMnemonic(item.getMnemonicKey());
            }
            return subMenu;
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(item.getName());
        if (item.getDescription() != null && !item.getDescription().isEmpty()) {
            menuItem.setToolTipText(item.getDescription());
        }
        menuItem.setIcon(item.getIcon());
        if (item.canExecute()) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)item);
                        }
                    }.start();
                }
            });
        } else {
            menuItem.setEnabled(false);
        }
        if (item.getMnemonicKey() != null) {
            menuItem.setMnemonic(item.getMnemonicKey());
            menuItem.setAccelerator(KeyStroke.getKeyStroke(item.getMnemonicKey(), 128));
        }
        return menuItem;
    }

    private void sortItems(ArrayList<? extends GraphContextMenuItem> m) {
        Collections.sort(m, new Comparator<GraphContextMenuItem>(){

            @Override
            public int compare(GraphContextMenuItem o1, GraphContextMenuItem o2) {
                if (o1.getType() == o2.getType()) {
                    return o1.getPosition() - o2.getPosition();
                }
                return o1.getType() - o2.getType();
            }
        });
    }
}

