/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.tools.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.gephi.ui.components.gradientslider.GradientSlider;
import org.gephi.utils.PaletteUtils;
import org.openide.util.NbBundle;

public class HeatMapPanel
extends JPanel {
    private PaletteComboBox paletteComboBox;
    private GradientSlider slider;
    private JCheckBox dontPaintUnreachableCheckbox;
    private JCheckBox invertPaletteCheckbox;
    private boolean usePalette = false;
    private JPanel gradientPanel;
    private JLabel labelGradient;
    private JLabel labelMode;
    private JLabel labelPalette;
    private JComboBox modeComboBox;
    private JPanel palettePanel;
    private JLabel statusLabel;

    public HeatMapPanel(Color[] gradientColors, float[] gradientPositions, boolean dontPaintUnreachable) {
        this.initComponents();
        this.slider = new GradientSlider(0, gradientPositions, gradientColors);
        this.slider.putClientProperty((Object)"GradientSlider.includeOpacity", (Object)"false");
        this.gradientPanel.add((Component)this.slider);
        this.dontPaintUnreachableCheckbox = new JCheckBox();
        this.dontPaintUnreachableCheckbox.setSelected(dontPaintUnreachable);
        this.dontPaintUnreachableCheckbox.setFont(new Font("Tahoma", 0, 10));
        this.dontPaintUnreachableCheckbox.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.dontPaintUnreachableCheckbox.text"));
        this.dontPaintUnreachableCheckbox.setToolTipText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.dontPaintUnreachableCheckbox.text"));
        this.dontPaintUnreachableCheckbox.setPreferredSize(new Dimension(160, 28));
        this.gradientPanel.add(this.dontPaintUnreachableCheckbox);
        this.invertPaletteCheckbox = new JCheckBox();
        this.invertPaletteCheckbox.setSelected(dontPaintUnreachable);
        this.invertPaletteCheckbox.setFont(new Font("Tahoma", 0, 10));
        this.invertPaletteCheckbox.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.invertPalette.text"));
        this.invertPaletteCheckbox.setPreferredSize(new Dimension(139, 28));
        this.invertPaletteCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HeatMapPanel.this.paletteComboBox.initReverse();
            }
        });
        this.paletteComboBox = new PaletteComboBox(PaletteUtils.getSequencialPalettes());
        this.palettePanel.add(this.paletteComboBox);
        this.palettePanel.add(this.invertPaletteCheckbox);
        this.modeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HeatMapPanel.this.modeComboBox.getSelectedIndex() == 0) {
                    HeatMapPanel.this.usePalette = false;
                    HeatMapPanel.this.initMode();
                } else {
                    HeatMapPanel.this.usePalette = true;
                    HeatMapPanel.this.initMode();
                }
            }
        });
        this.initMode();
    }

    private void initMode() {
        if (this.usePalette) {
            this.gradientPanel.setVisible(false);
            this.palettePanel.setVisible(true);
        } else {
            this.gradientPanel.setVisible(true);
            this.palettePanel.setVisible(false);
        }
    }

    public boolean isUsePalette() {
        return this.usePalette;
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
        this.statusLabel.setToolTipText(status);
    }

    public Color[] getGradientColors() {
        return this.slider.getColors();
    }

    public float[] getGradientPositions() {
        return this.slider.getThumbPositions();
    }

    public boolean isDontPaintUnreachable() {
        return this.dontPaintUnreachableCheckbox.isSelected();
    }

    public PaletteUtils.Palette getSelectedPalette() {
        return (PaletteUtils.Palette)this.paletteComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.labelMode = new JLabel();
        this.modeComboBox = new JComboBox();
        this.gradientPanel = new JPanel();
        this.labelGradient = new JLabel();
        this.palettePanel = new JPanel();
        this.labelPalette = new JLabel();
        this.setPreferredSize(new Dimension(654, 28));
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        this.statusLabel.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.statusLabel.text"));
        this.labelMode.setFont(this.labelMode.getFont().deriveFont(10.0f));
        this.labelMode.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.labelMode.text"));
        this.modeComboBox.setFont(this.modeComboBox.getFont().deriveFont(10.0f));
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Gradient", "Palette"}));
        this.gradientPanel.setLayout(new FlowLayout(0, 5, 0));
        this.labelGradient.setFont(this.labelGradient.getFont().deriveFont(10.0f));
        this.labelGradient.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.labelGradient.text"));
        this.labelGradient.setPreferredSize(new Dimension(45, 28));
        this.gradientPanel.add(this.labelGradient);
        this.palettePanel.setLayout(new FlowLayout(0, 5, 0));
        this.labelPalette.setFont(this.labelPalette.getFont().deriveFont(10.0f));
        this.labelPalette.setText(NbBundle.getMessage(HeatMapPanel.class, (String)"HeatMapPanel.labelPalette.text"));
        this.labelPalette.setPreferredSize(new Dimension(45, 28));
        this.palettePanel.add(this.labelPalette);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modeComboBox, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gradientPanel, -2, 399, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.palettePanel, -2, 363, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusLabel, -2, 28, -2).addComponent(this.labelMode, -2, 28, -2).addComponent(this.modeComboBox, -2, -1, -2)).addComponent(this.gradientPanel, -2, 28, -2).addComponent(this.palettePanel, -2, 28, -2));
    }

    private class PaletteComboBox
    extends JComboBox {
        private PaletteUtils.Palette[] palettes;

        public PaletteComboBox(PaletteUtils.Palette[] pallettes) {
            super(pallettes);
            this.palettes = pallettes;
            PaletteListCellRenderer r = new PaletteListCellRenderer();
            r.setPreferredSize(new Dimension(70, 18));
            r.setOpaque(true);
            this.setRenderer(r);
            this.initReverse();
        }

        public void initReverse() {
            if (HeatMapPanel.this.invertPaletteCheckbox.isSelected()) {
                int selectedIndex = this.getSelectedIndex();
                DefaultComboBoxModel<PaletteUtils.Palette> newModel = new DefaultComboBoxModel<PaletteUtils.Palette>();
                for (int i = 0; i < this.getModel().getSize(); ++i) {
                    newModel.addElement(PaletteUtils.reversePalette((PaletteUtils.Palette)((PaletteUtils.Palette)this.getModel().getElementAt(i))));
                }
                this.setModel(newModel);
                this.setSelectedIndex(selectedIndex);
            } else {
                int selectedIndex = this.getSelectedIndex();
                this.setModel(new DefaultComboBoxModel<PaletteUtils.Palette>(this.palettes));
                this.setSelectedIndex(selectedIndex);
            }
        }

        private class PaletteListCellRenderer
        extends JLabel
        implements ListCellRenderer {
            private PaletteListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                PaletteUtils.Palette p = (PaletteUtils.Palette)value;
                PaletteIcon icon = new PaletteIcon(p.getColors());
                this.setIcon(icon);
                return this;
            }
        }
    }

    private static class PaletteIcon
    implements Icon {
        private static int COLOR_WIDTH = 13;
        private static int COLOR_HEIGHT = 13;
        private static Color BORDER_COLOR = new Color(0x444444);
        private Color[] colors;

        public PaletteIcon(Color[] colors) {
            this.colors = colors;
        }

        @Override
        public int getIconWidth() {
            return COLOR_WIDTH * this.colors.length;
        }

        @Override
        public int getIconHeight() {
            return COLOR_HEIGHT + 2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            for (int i = 0; i < this.colors.length; ++i) {
                g.setColor(BORDER_COLOR);
                g.drawRect(x + 2 + i * COLOR_WIDTH, y, COLOR_WIDTH, COLOR_HEIGHT);
                g.setColor(this.colors[i]);
                g.fillRect(x + 2 + i * COLOR_WIDTH + 1, y + 1, COLOR_WIDTH - 1, COLOR_HEIGHT - 1);
            }
        }
    }
}

