/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import net.java.dev.colorchooser.AlphaPalette;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.DefaultColorChooserUI;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PalettePopup;
import net.java.dev.colorchooser.RecentColors;

public abstract class ColorChooserUI
extends ComponentUI {
    static boolean MAC = DefaultColorChooserUI.isMac();

    protected ColorChooserUI() {
    }

    @Override
    public final void installUI(JComponent jc) {
        this.installListeners((ColorChooser)jc);
        this.init((ColorChooser)jc);
    }

    @Override
    public final void uninstallUI(JComponent jc) {
        this.uninstallListeners((ColorChooser)jc);
        this.uninit((ColorChooser)jc);
    }

    protected void init(ColorChooser c) {
    }

    protected void uninit(ColorChooser c) {
    }

    protected void installListeners(ColorChooser c) {
        L l = new L();
        c.addMouseListener(l);
        c.addMouseMotionListener(l);
        c.addFocusListener(l);
        c.addKeyListener(l);
        c.putClientProperty("uiListener", l);
    }

    protected void uninstallListeners(ColorChooser c) {
        Object o = c.getClientProperty("uiListener");
        if (o instanceof L) {
            L l = (L)o;
            c.removeMouseListener(l);
            c.removeFocusListener(l);
            c.removeKeyListener(l);
        }
    }

    protected int paletteIndexFromKeyCode(KeyEvent ke) {
        int result;
        int keyCode = ke.getKeyCode();
        int n = result = keyCode == 16 ? 1 : 0;
        result = MAC ? (result += keyCode == 157 ? 2 : 0) : (result += keyCode == 17 ? 2 : 0);
        return result += keyCode == 18 ? 4 : 0;
    }

    protected int paletteIndexFromModifiers(InputEvent me) {
        MouseEvent m;
        int mods = me.getModifiersEx();
        int result = (mods & 0x40) != 0 ? 1 : 0;
        result += (mods & 0x80) != 0 ? 2 : 0;
        result += (mods & 0x200) != 0 ? 4 : 0;
        if (me instanceof MouseEvent && (m = (MouseEvent)me).getButton() == 3) {
            result += 8;
        }
        return result;
    }

    protected boolean keyboardInvoke(ColorChooser colorChooser) {
        if (!colorChooser.isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        Container top = colorChooser.getTopLevelAncestor();
        Color result = ColorPicker.showDialog(top, colorChooser.getColor());
        if (result != null) {
            colorChooser.setColor(result);
            return true;
        }
        return false;
    }

    protected void fireColorChanged(ColorChooser chooser) {
        chooser.fireActionPerformed(new ActionEvent(chooser, 1001, "color"));
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (!c.isMaximumSizeSet()) {
            return this.getPreferredSize(c);
        }
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!c.isMinimumSizeSet()) {
            return this.getPreferredSize(c);
        }
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (!c.isPreferredSizeSet()) {
            Dimension result = this.computePreferredSize(c);
            if (result == null) {
                result = new Dimension(18, 18);
            }
            return result;
        }
        return super.getPreferredSize(c);
    }

    private Dimension computePreferredSize(JComponent c) {
        FontMetrics fm;
        Font f = c.getFont();
        if (f == null) {
            f = UIManager.getFont("controlFont");
        }
        if (f == null) {
            f = UIManager.getFont("Label.font");
        }
        if ((fm = c.getFontMetrics(f)) != null) {
            int height = fm.getHeight();
            int width = fm.stringWidth("Z");
            int size = Math.max(16, Math.max(height, width));
            Insets ins = c.getInsets();
            return new Dimension(size + ins.left + ins.right, size + ins.top + ins.bottom);
        }
        return null;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return -1;
    }

    private class L
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private int paletteIndex = 0;
        private transient Point nextFocusPopupLocation = null;
        static final float BASE_KEY_ADJUST = 0.01f;

        private L() {
        }

        int getPaletteIndex() {
            return this.paletteIndex;
        }

        void initPaletteIndex(ColorChooser c, MouseEvent me) {
            this.paletteIndex = ColorChooserUI.this.paletteIndexFromModifiers(me);
            this.checkRange(c);
        }

        private void checkRange(ColorChooser chooser) {
            Palette[] p = chooser.getPalettes();
            if (this.paletteIndex >= p.length) {
                this.paletteIndex = p.length - 1;
            }
        }

        private void updatePaletteIndex(ColorChooser chooser, int value, boolean pressed) {
            int oldIndex = this.paletteIndex;
            int result = this.paletteIndex;
            result = pressed ? (result |= value) : (result ^= value);
            if (oldIndex != result && PalettePopup.getDefault().isPopupVisible(chooser)) {
                this.paletteIndex = result;
                this.checkRange(chooser);
                PalettePopup.getDefault().setPalette(chooser.getPalettes()[this.paletteIndex]);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ColorChooser chooser = (ColorChooser)e.getSource();
            if (e.getButton() == 2 && chooser.isDragDropEnabled()) {
                String txt = chooser.getColorAsText();
                try {
                    StringSelection sel = new StringSelection(txt);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(L.class.getName()).log(Level.INFO, null, ex);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ColorChooser chooser;
            Object o;
            int mask;
            int n = mask = MAC ? 128 : 256;
            if ((e.getModifiersEx() & mask) != 0 && (o = e.getSource()) instanceof ColorChooser && ColorChooserUI.this.keyboardInvoke(chooser = (ColorChooser)e.getSource())) {
                e.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 2) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, chooser);
            this.initPaletteIndex(chooser, me);
            int ix = this.getPaletteIndex();
            Palette[] palettes = chooser.getPalettes();
            if (ix < palettes.length) {
                PalettePopup.getDefault().setPalette(chooser.getPalettes()[ix]);
                if (!chooser.hasFocus()) {
                    this.nextFocusPopupLocation = p;
                    chooser.requestFocus();
                    return;
                }
                PalettePopup.getDefault().showPopup(chooser, p);
                me.consume();
                this.nextFocusPopupLocation = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.nextFocusPopupLocation = null;
            PalettePopup popup = PalettePopup.getDefault();
            if (popup.isPopupVisible(chooser)) {
                Palette current = popup.currentPalette();
                popup.hidePopup(chooser);
                Color oldColor = chooser.getColor();
                Color transientColor = chooser.transientColor();
                if (transientColor != null) {
                    if (!(current instanceof AlphaPalette) && oldColor != null && oldColor.getAlpha() != 255) {
                        transientColor = new Color(transientColor.getRed(), transientColor.getGreen(), transientColor.getBlue(), oldColor.getAlpha());
                    }
                    RecentColors.getDefault().add(transientColor);
                    Color old = new Color(transientColor.getRed(), transientColor.getGreen(), transientColor.getBlue(), transientColor.getAlpha());
                    chooser.setTransientColor(null);
                    chooser.setColor(old);
                    ColorChooserUI.this.fireColorChanged(chooser);
                    me.consume();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ColorChooser chooser = (ColorChooser)e.getSource();
            if (this.nextFocusPopupLocation != null && chooser.isEnabled()) {
                PalettePopup.getDefault().showPopup(chooser, this.nextFocusPopupLocation);
            }
            this.nextFocusPopupLocation = null;
            chooser.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ColorChooser chooser = (ColorChooser)e.getSource();
            chooser.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processKeyEvent(e, true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKeyEvent(e, false);
        }

        protected void processKeyEvent(KeyEvent ke, boolean pressed) {
            boolean altAltKey;
            boolean ctrl;
            ColorChooser chooser = (ColorChooser)ke.getSource();
            this.updatePaletteIndex(chooser, ColorChooserUI.this.paletteIndexFromKeyCode(ke), pressed);
            int dir = ke.isShiftDown() ? -1 : 1;
            boolean bl = ctrl = DefaultColorChooserUI.isMac() ? ke.isMetaDown() : ke.isControlDown();
            if (ctrl) {
                dir *= 10;
            }
            float amount = (float)dir * 0.01f;
            float alt = 0.0f;
            boolean altKey = DefaultColorChooserUI.isMac() ? ke.isControlDown() : ke.isAltDown();
            boolean bl2 = altAltKey = DefaultColorChooserUI.isMac() ? ke.isAltDown() : ke.isControlDown();
            if (altKey) {
                alt = altAltKey ? -amount : amount;
            }
            switch (ke.getKeyCode()) {
                case 16: 
                case 17: 
                case 18: 
                case 157: {
                    ke.consume();
                    break;
                }
                case 10: 
                case 32: {
                    if (ke.getID() != 401 || !ColorChooserUI.this.keyboardInvoke(chooser)) break;
                    ke.consume();
                    break;
                }
                case 38: 
                case 66: {
                    if (!pressed || !chooser.adjustColor(0.0f, alt, amount)) break;
                    ke.consume();
                    break;
                }
                case 40: 
                case 68: {
                    if (!pressed || !chooser.adjustColor(0.0f, -alt, -amount)) break;
                    ke.consume();
                    break;
                }
                case 37: 
                case 83: {
                    if (!pressed || !chooser.adjustColor(alt, amount, 0.0f)) break;
                    ke.consume();
                    break;
                }
                case 39: 
                case 65: {
                    if (!pressed || !chooser.adjustColor(-alt, -amount, 0.0f)) break;
                    ke.consume();
                    break;
                }
                case 72: {
                    if (!pressed || !chooser.adjustColor(amount, 0.0f, alt)) break;
                    ke.consume();
                    break;
                }
                case 85: {
                    if (!pressed || !chooser.adjustColor(-amount, 0.0f, -alt)) break;
                    ke.consume();
                }
            }
        }
    }
}

