/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.GlobalNodes;
import org.freeplane.features.explorer.NodeMatcher;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeStream;

enum ExploringStep {
    ROOT{

        @Override
        public void assertValidString(String searchedString) {
            this.assertEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(NodeModel node, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            NodeModel rootNode = node.getMap().getRootNode();
            accessedNodes.accessNode(rootNode);
            return Collections.singletonList(rootNode);
        }
    }
    ,
    GLOBAL{

        @Override
        public void assertValidString(String searchedString) {
            this.assertNonEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(NodeModel start, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            GlobalNodes nodes = GlobalNodes.readableOf(start.getMap());
            accessedNodes.accessGlobalNode();
            return nodeMatcher.filterMatchingNodes(nodes, accessedNodes);
        }
    }
    ,
    ANCESTOR{

        @Override
        public void assertValidString(String searchedString) {
            this.assertNonEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(final NodeModel start, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            Iterable<NodeModel> nodes = new Iterable<NodeModel>(){
                NodeModel current;
                {
                    this.current = start;
                }

                @Override
                public Iterator<NodeModel> iterator() {
                    return new Iterator<NodeModel>(){

                        @Override
                        public boolean hasNext() {
                            return current.getParentNode() != null;
                        }

                        @Override
                        public NodeModel next() {
                            current = current.getParentNode();
                            if (current == null) {
                                throw new NoSuchElementException();
                            }
                            return current;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
            return nodeMatcher.filterMatchingNodes(nodes, accessedNodes);
        }
    }
    ,
    PARENT{

        @Override
        public void assertValidString(String searchedString) {
            this.assertEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(NodeModel node, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            NodeModel parentNode = node.getParentNode();
            accessedNodes.accessNode(parentNode);
            return Collections.singletonList(parentNode);
        }
    }
    ,
    CHILD{

        @Override
        public void assertValidString(String searchedString) {
            this.assertNonEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(NodeModel start, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            List<NodeModel> nodes = start.getChildren();
            return nodeMatcher.filterMatchingNodes(nodes, accessedNodes);
        }
    }
    ,
    DESCENDANT{

        @Override
        public void assertValidString(String searchedString) {
            this.assertNonEmpty(searchedString);
        }

        @Override
        List<NodeModel> getNodes(NodeModel start, NodeMatcher nodeMatcher, AccessedNodes accessedNodes) {
            accessedNodes.accessBranch(start);
            return NodeStream.of(start).skip(1L).filter(nodeMatcher::matches).collect(Collectors.toList());
        }
    };


    public void assertValidString(String searchedString) {
    }

    void assertNonEmpty(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty string");
        }
    }

    void assertEmpty(String string) {
        if (!string.isEmpty()) {
            throw new IllegalArgumentException("Unexpected non empty string: " + string);
        }
    }

    abstract List<NodeModel> getNodes(NodeModel var1, NodeMatcher var2, AccessedNodes var3);
}

