/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.dbvis;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.config.migration.dbvis.DbvisConfigurationCreator;
import org.jkiss.dbeaver.ui.config.migration.dbvis.DbvisConfigurationCreatorv233;
import org.jkiss.dbeaver.ui.config.migration.dbvis.DbvisConfigurationCreatorv7;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;

public class DbvisConfigurationImporter {
    private static final Log log = Log.getLog(DbvisConfigurationImporter.class);
    private static final Map<String, DbvisConfigurationCreator> version2creator = new LinkedHashMap<String, DbvisConfigurationCreator>();

    public ImportData importConfiguration(@NotNull ImportData data, @NotNull File folder) {
        for (Map.Entry<String, DbvisConfigurationCreator> configuration : version2creator.entrySet()) {
            DbvisConfigurationCreator dbvisConfigurationCreator = configuration.getValue();
            File configurationAsset = dbvisConfigurationCreator.getConfigurationAsset(folder);
            if (configurationAsset == null || !configurationAsset.exists()) continue;
            try {
                data = dbvisConfigurationCreator.create(data, configurationAsset);
            }
            catch (DBException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return data;
    }

    static {
        version2creator.put("version.7.x.x", new DbvisConfigurationCreatorv7());
        version2creator.put("version.24.3.x", new DbvisConfigurationCreatorv233());
    }
}

